/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.ArrayList;
import net.minecraftforge.oredict.OreDictionary;

public class StackUtils {
    public static boolean stowInInventory(ur itemstack, la inventory, boolean doAdd) {
        return StackUtils.stowInInventory(itemstack, inventory, doAdd, 0, inventory.k_());
    }

    public static boolean stowInInventory(ur itemstack, la inventory, boolean doAdd, int slot1, int count) {
        boolean added = false;
        for (int i = slot1; i < slot1 + count; ++i) {
            ur inventoryStack = inventory.a(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.a(i, itemstack.l());
                    itemstack.a = 0;
                }
                return true;
            }
            if (inventoryStack.a >= inventoryStack.d() || !inventoryStack.a(itemstack)) continue;
            int space = inventoryStack.d() - inventoryStack.a;
            if (space > itemstack.a) {
                if (doAdd) {
                    inventoryStack.a += itemstack.a;
                    itemstack.a = 0;
                }
                return true;
            }
            if (doAdd) {
                inventoryStack.a = inventoryStack.d();
                itemstack.a -= space;
            }
            added = true;
        }
        return added;
    }

    public static int addToInventory(ur itemstack, la inventory, boolean doAdd, int slot1, int count) {
        int added = 0;
        for (int i = slot1; i < slot1 + count; ++i) {
            ur inventoryStack = inventory.a(i);
            if (inventoryStack == null) {
                if (doAdd) {
                    inventory.a(i, itemstack.l());
                }
                return itemstack.a;
            }
            if (inventoryStack.a >= inventoryStack.d() || !inventoryStack.a(itemstack)) continue;
            int space = inventoryStack.d() - inventoryStack.a;
            if (space > itemstack.a - added) {
                if (doAdd) {
                    inventoryStack.a += itemstack.a;
                }
                return itemstack.a;
            }
            if (doAdd) {
                inventoryStack.a = inventoryStack.d();
            }
            added += space;
        }
        return added;
    }

    public static void mergeStacks(ur giver, ur receptor) {
        if (receptor.a >= 64) {
            return;
        }
        if (!receptor.a(giver)) {
            return;
        }
        if (giver.a <= receptor.d() - receptor.a) {
            receptor.a += giver.a;
            giver.a = 0;
            return;
        }
        ur temp = giver.a(receptor.d() - receptor.a);
        receptor.a += temp.a;
        temp.a = 0;
    }

    public static boolean freeSpaceInStack(ur stack, int maxSize) {
        if (stack == null) {
            return true;
        }
        return stack.a < maxSize;
    }

    public static boolean canAddToStack(ur stack, ur inventory) {
        if (inventory == null) {
            return true;
        }
        return stack.c == inventory.c;
    }

    public static ur createSplitStack(ur stack, int amount) {
        ur split = new ur(stack.c, amount, stack.j());
        if (stack.p() != null) {
            bq nbttagcompound = (bq)stack.p().b();
            split.d(nbttagcompound);
        }
        return split;
    }

    public static ur[] condenseStacks(ur[] stacks) {
        ArrayList<ur> condensed = new ArrayList<ur>();
        for (ur stack : stacks) {
            if (stack == null) continue;
            boolean matched = false;
            for (ur cached : condensed) {
                if (!cached.a(stack)) continue;
                cached.a += stack.a;
                matched = true;
            }
            if (matched) continue;
            condensed.add(stack.l());
        }
        return condensed.toArray(new ur[0]);
    }

    public static int containsSets(ur[] set, ur[] stock) {
        return StackUtils.containsSets(set, stock, false);
    }

    public static int containsSets(ur[] set, ur[] stock, boolean oreDictionary) {
        int count = 0;
        ur[] condensedRequired = StackUtils.condenseStacks(set);
        ur[] condensedOffered = StackUtils.condenseStacks(stock);
        for (ur req : condensedRequired) {
            boolean matched = false;
            for (ur offer : condensedOffered) {
                boolean isEqual = false;
                isEqual = oreDictionary ? StackUtils.isItemOreEqual(req, offer) : req.a(offer);
                if (!isEqual) continue;
                matched = true;
                int stackCount = (int)Math.floor(offer.a / req.a);
                if (stackCount <= 0) {
                    return 0;
                }
                if (count == 0) {
                    count = stackCount;
                    continue;
                }
                if (count <= stackCount) continue;
                count = stackCount;
            }
            if (matched) continue;
            return 0;
        }
        return count;
    }

    public static boolean isItemOreEqual(ur base, ur comparison) {
        if (base.a(comparison)) {
            return true;
        }
        ArrayList copperIngots = OreDictionary.getOres((String)"ingotCopper");
        for (ur ore : copperIngots) {
            if (!ore.a(base)) continue;
            for (ur ore1 : copperIngots) {
                if (!ore1.a(comparison)) continue;
                return true;
            }
            return false;
        }
        ArrayList tinIngots = OreDictionary.getOres((String)"ingotTin");
        for (ur ore : tinIngots) {
            if (!ore.a(base)) continue;
            for (ur ore1 : tinIngots) {
                if (!ore1.a(comparison)) continue;
                return true;
            }
            return false;
        }
        ArrayList bronzeIngots = OreDictionary.getOres((String)"ingotBronze");
        for (ur ore : bronzeIngots) {
            if (!ore.a(base)) continue;
            for (ur ore1 : bronzeIngots) {
                if (!ore1.a(comparison)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void dropItemStackAsEntity(ur items, yc world, int x2, int y2, int z2) {
        if (items.a <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.t.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.t.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.t.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        px entityitem = new px(world, (double)x2 + d, (double)y2 + d1, (double)z2 + d2, items);
        entityitem.b = 10;
        world.d((lq)entityitem);
    }
}

