/*
 * Decompiled with CFR 0.152.
 */
package forestry.cultivation.render;

import forestry.core.ForestryClient;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import forestry.cultivation.gadgets.TilePlanter;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderPlanter
implements IBlockRenderer {
    private axa model = new axa(){};
    private String gfxBase;
    private ayf base = new ayf(this.model, 0, 0);
    private ayf ceiling;
    private ayf terrarium;
    private ayf showcase;

    public RenderPlanter() {
        this.base.a(-8.0f, 4.0f, -8.0f, 16, 4, 16);
        this.base.c = 8.0f;
        this.base.d = 8.0f;
        this.base.e = 8.0f;
        this.ceiling = new ayf(this.model, 0, 0);
        this.ceiling.a(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.ceiling.c = 8.0f;
        this.ceiling.d = 8.0f;
        this.ceiling.e = 8.0f;
        this.terrarium = new ayf(this.model, 0, 0);
        this.terrarium.a(-6.0f, -7.0f, -6.0f, 12, 12, 12);
        this.terrarium.c = 8.0f;
        this.terrarium.d = 8.0f;
        this.terrarium.e = 8.0f;
        this.showcase = new ayf(this.model, 0, 0);
        this.showcase.a(-4.0f, -4.0f, -4.0f, 8, 8, 8);
        this.showcase.c = 8.0f;
        this.showcase.d = 8.0f;
        this.showcase.e = 8.0f;
    }

    public RenderPlanter(String baseTexture) {
        this();
        this.gfxBase = baseTexture;
    }

    @Override
    public void preloadTextures() {
        ForestryClient.preloadTexture(this.gfxBase + "base.png");
        ForestryClient.preloadTexture(this.gfxBase + "ceiling.png");
        ForestryClient.preloadTexture(this.gfxBase + "terrarium.png");
        ForestryClient.preloadTexture(this.gfxBase + "showcase.png");
    }

    @Override
    public void inventoryRender(double x2, double y2, double z2, float f, float f1) {
        this.render(ForgeDirection.UP, this.gfxBase, x2, y2, z2);
    }

    @Override
    public void renderTileEntityAt(any tileentity, double d, double d1, double d2, float f) {
        TilePlanter planter = (TilePlanter)tileentity;
        if (planter.machine != null) {
            this.render(planter.getOrientation(), this.gfxBase, d, d1, d2);
        }
    }

    private void render(ForgeDirection orientation, String gfxBase, double x2, double y2, double z2) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x2), (float)((float)y2), (float)((float)z2));
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        switch (orientation) {
            case EAST: {
                translate[1] = 1.0f;
                break;
            }
            case WEST: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case UP: {
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case DOWN: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.base.f = angle[0];
        this.base.g = angle[1];
        this.base.h = angle[2];
        this.ceiling.f = angle[0];
        this.ceiling.g = angle[1];
        this.ceiling.h = angle[2];
        this.terrarium.f = angle[0];
        this.terrarium.g = angle[1];
        this.terrarium.h = angle[2];
        this.showcase.f = angle[0];
        this.showcase.g = angle[1];
        this.showcase.h = angle[2];
        float factor = 0.0625f;
        Proxies.common.bindTexture(gfxBase + "base.png");
        this.base.a(factor);
        Proxies.common.bindTexture(gfxBase + "ceiling.png");
        this.ceiling.a(factor);
        Proxies.common.bindTexture(gfxBase + "terrarium.png");
        this.terrarium.a(factor);
        Proxies.common.bindTexture(gfxBase + "showcase.png");
        this.showcase.a(factor);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

