/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.circuits;

import forestry.core.circuits.Circuit;
import forestry.core.gadgets.TileEngine;
import forestry.energy.gadgets.EngineTin;

public abstract class CircuitElectricChange
extends Circuit {
    int euChange = 7;
    int mjChange = 2;

    public CircuitElectricChange(String uid, boolean requiresDiscovery, String name, String usage, String[] descriptions) {
        super(uid, requiresDiscovery, name, usage, descriptions);
    }

    protected void configureChange(int euChange, int mjChange) {
        this.euChange = euChange;
        this.mjChange = mjChange;
    }

    @Override
    public boolean isCircuitable(any tile) {
        return tile instanceof TileEngine && ((TileEngine)tile).engine instanceof EngineTin;
    }

    @Override
    public void onInsertion(any tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        EngineTin engine = (EngineTin)((TileEngine)tile).engine;
        engine.changeEnergyConfig(this.euChange, this.mjChange, 2 * this.euChange);
    }

    @Override
    public void onLoad(any tile) {
        this.onInsertion(tile);
    }

    @Override
    public void onRemoval(any tile) {
        if (!this.isCircuitable(tile)) {
            return;
        }
        EngineTin engine = (EngineTin)((TileEngine)tile).engine;
        engine.changeEnergyConfig(-this.euChange, -this.mjChange, -(2 * this.euChange));
    }

    @Override
    public void onTick(any tile) {
    }
}

