/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.EngineFactory;
import forestry.core.gadgets.TileEngine;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.TileInventoryAdapter;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class EngineCopper
extends Engine {
    public static final short SLOT_FUEL = 0;
    public static final short SLOT_WASTE_1 = 1;
    public static final short SLOT_WASTE_COUNT = 4;
    private int fuelItemId;
    private int fuelItemMeta;
    private int burnTime;
    private int totalBurnTime;
    private int ashProduction;
    private int ashForItem;
    private TileInventoryAdapter inventory;

    public EngineCopper(TileEngine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("engine.copper"));
        this.maxEnergy = 20000;
        this.maxEnergyExtracted = 400;
        this.maxHeat = 10000;
        this.ashForItem = 7500;
        this.inventory = new TileInventoryAdapter(tile, 5, "Items");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineCopperGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    private int getFuelSlot() {
        if (this.inventory.a(0) == null) {
            return -1;
        }
        if (this.determineFuelValue(this.inventory.a(0)) > 0) {
            return 0;
        }
        return -1;
    }

    private int getFreeWasteSlot() {
        for (int i = 1; i <= 4; ++i) {
            if (this.inventory.a(i) == null) {
                return i;
            }
            if (this.inventory.a((int)i).c != ForestryItem.ash.cj || this.inventory.a((int)i).a >= 64) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.tile.k.G() % 20L * 10L != 0L) {
            return;
        }
        if (this.mayBurn() && this.burnTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return;
        }
        if (this.forceCooldown) {
            this.setErrorState(EnumErrorCode.FORCEDCOOLDOWN);
            return;
        }
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot >= 0 && this.determineBurnDuration(this.inventory.a(fuelSlot)) > 0) {
            this.setErrorState(EnumErrorCode.OK);
        } else {
            this.setErrorState(EnumErrorCode.NOFUEL);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.burnTime > 0) {
            --this.burnTime;
            this.addAsh(1);
            if (this.tile.isActivated()) {
                this.currentOutput = this.determineFuelValue(new ur(this.fuelItemId, 1, this.fuelItemMeta));
                this.addEnergy(this.currentOutput);
            }
        } else if (this.tile.isActivated()) {
            int fuelslot = this.getFuelSlot();
            int wasteslot = this.getFreeWasteSlot();
            if (fuelslot >= 0 && wasteslot >= 0) {
                this.burnTime = this.totalBurnTime = this.determineBurnDuration(this.inventory.a(fuelslot));
                if (this.burnTime > 0) {
                    this.fuelItemId = this.inventory.a((int)fuelslot).c;
                    this.a(fuelslot, 1);
                }
            }
        }
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int heat = 0;
        if (this.isBurning()) {
            ++heat;
            if ((double)this.storedEnergy / (double)this.maxEnergy > 0.5) {
                ++heat;
            }
        }
        this.addHeat(heat);
        return heat;
    }

    private void addAsh(int amount) {
        this.ashProduction += amount;
        if (this.ashProduction < this.ashForItem) {
            return;
        }
        int wasteslot = this.getFreeWasteSlot();
        if (wasteslot >= 0) {
            if (this.inventory.a(wasteslot) == null) {
                this.inventory.a(wasteslot, new ur(ForestryItem.ash, 1));
            } else {
                ++this.inventory.a((int)wasteslot).a;
            }
        }
        this.ashProduction = 0;
        this.dumpStash();
    }

    private int determineFuelValue(ur fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return ((EngineCopperFuel)FuelManager.copperEngineFuel.get((Object)fuel)).powerPerCycle;
        }
        return 0;
    }

    private int determineBurnDuration(ur fuel) {
        if (FuelManager.copperEngineFuel.containsKey(fuel)) {
            return ((EngineCopperFuel)FuelManager.copperEngineFuel.get((Object)fuel)).burnDuration;
        }
        return 0;
    }

    private void dumpStash() {
        ForgeDirection[] pipes = BlockUtil.getPipeDirections(this.tile.k, this.tile.Coords(), this.tile.getOrientation());
        if (pipes.length > 0) {
            this.dumpToPipe(pipes);
        }
    }

    private void dumpToPipe(ForgeDirection[] pipes) {
        for (int i = 1; i < 5; ++i) {
            if (this.inventory.a(i) == null || this.inventory.a((int)i).a <= 0) continue;
            ForgeDirection[] filtered = BlockUtil.filterPipeDirections(pipes, new ForgeDirection[]{this.tile.getOrientation()});
            while (this.inventory.a((int)i).a > 0 && filtered.length > 0) {
                BlockUtil.putFromStackIntoPipe(this.tile, filtered, this.inventory.a(i));
            }
            if (this.inventory.a((int)i).a > 0) continue;
            this.inventory.a(i, null);
        }
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalBurnTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalBurnTime;
    }

    @Override
    public boolean hasFuelMin(float percentage) {
        int fuelSlot = this.getFuelSlot();
        if (fuelSlot < 0) {
            return false;
        }
        return (float)this.inventory.a((int)fuelSlot).a / (float)this.inventory.a(fuelSlot).d() > percentage;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.fuelItemId = nbttagcompound.e("EngineFuelItem");
        this.fuelItemMeta = nbttagcompound.e("EngineFuelMeta");
        this.burnTime = nbttagcompound.e("EngineBurnTime");
        this.totalBurnTime = nbttagcompound.e("EngineTotalTime");
        if (nbttagcompound.b("AshProduction")) {
            this.ashProduction = nbttagcompound.e("AshProduction");
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("EngineFuelItem", this.fuelItemId);
        nbttagcompound.a("EngineFuelMeta", this.fuelItemMeta);
        nbttagcompound.a("EngineBurnTime", this.burnTime);
        nbttagcompound.a("EngineTotalTime", this.totalBurnTime);
        nbttagcompound.a("AshProduction", this.ashProduction);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalBurnTime = j;
                break;
            }
            case 2: {
                this.currentOutput = j;
                break;
            }
            case 3: {
                this.storedEnergy = j;
                break;
            }
            case 4: {
                this.heat = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq containerEngine, rw iCrafting) {
        iCrafting.a(containerEngine, 0, this.burnTime);
        iCrafting.a(containerEngine, 1, this.totalBurnTime);
        iCrafting.a(containerEngine, 2, this.currentOutput);
        iCrafting.a(containerEngine, 3, this.storedEnergy);
        iCrafting.a(containerEngine, 4, this.heat);
    }

    @Override
    public int k_() {
        return this.inventory.k_();
    }

    @Override
    public ur a(int i) {
        return this.inventory.a(i);
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public ur a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public ur a_(int slot) {
        return this.inventory.a_(slot);
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 4;
        }
        return 1;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (FuelManager.copperEngineFuel.containsKey(stack)) {
            return this.inventory.addStack(stack, 0, 1, false, doAdd);
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        for (int i = 1; i < 5; ++i) {
            if (this.inventory.a(i) == null || this.inventory.a((int)i).c != ForestryItem.ash.cj) continue;
            ur product = new ur(ForestryItem.ash);
            if (doRemove) {
                this.a(i, 1);
            }
            return new ur[]{product};
        }
        return new ur[0];
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowFuel25);
        return res;
    }

    public static class Factory
    extends EngineFactory {
        @Override
        public Engine createEngine(any tile) {
            return new EngineCopper((TileEngine)tile);
        }
    }
}

