/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.GeneratorFuel;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import forestry.plugins.PluginIC2;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySource;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineGenerator
extends Machine {
    public static final short SLOT_CAN = 0;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    public int energyStored;
    public int energyMax;
    public boolean isAddedToEnergyNet;
    private int tickCount = 0;
    ur[] inventoryStacks = new ur[1];

    public MachineGenerator(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("generator"));
        this.energyMax = 30000;
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.4");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.GeneratorGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("EnergyStored", this.energyStored);
        nbttagcompound.a("EnergyMax", this.energyMax);
        nbttagcompound.a("IsAddedToEnergyNet", this.isAddedToEnergyNet);
        bq NBTresourceSlot = new bq();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (cd)NBTresourceSlot);
        by nbttaglist = new by();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Items", (cd)nbttaglist);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.energyStored = nbttagcompound.e("EnergyStored");
        this.energyMax = nbttagcompound.e("EnergyMax");
        this.isAddedToEnergyNet = nbttagcompound.n("IsAddedToEnergyNet");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.l("ResourceTank"));
        }
        by nbttaglist = nbttagcompound.m("Items");
        this.inventoryStacks = new ur[this.k_()];
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            byte byte0 = nbttagcompound1.c("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = ur.a((bq)nbttagcompound1);
        }
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        if (this.inventoryStacks[0] != null && (container = LiquidHelper.getLiquidContainer(this.inventoryStacks[0])) != null && GeneratorFuel.fuels.containsKey(container.stillLiquid.itemID)) {
            this.inventoryStacks[0] = this.replenishByContainer(this.inventoryStacks[0], container, this.resourceTank);
            if (this.inventoryStacks[0].a <= 0) {
                this.inventoryStacks[0] = null;
            }
        }
        if (!PluginIC2.instance.isAvailable()) {
            this.setErrorState(EnumErrorCode.NOENERGYNET);
            return;
        }
        if (!this.isAddedToEnergyNet) {
            EnergyNet.getForWorld(this.tile.k).addTileEntity(this.tile);
            this.isAddedToEnergyNet = true;
        }
        if (this.resourceTank.quantity > 0 && this.energyStored <= this.energyMax - 10) {
            if (GeneratorFuel.fuels.containsKey(this.resourceTank.liquidId)) {
                GeneratorFuel fuel = (GeneratorFuel)GeneratorFuel.fuels.get(this.resourceTank.liquidId);
                ++this.tickCount;
                if (this.tickCount >= fuel.rate) {
                    this.tickCount = 0;
                    this.energyStored += EnergyNet.getForWorld(this.tile.k).emitEnergyFrom((IEnergySource)((Object)this.tile), fuel.eu);
                    this.resourceTank.drain(fuel.fuelConsumed.amount, true);
                }
            }
        } else if (this.energyStored > 0) {
            int emit;
            if (this.energyStored >= 32) {
                emit = 32;
                this.energyStored -= 32;
            } else {
                emit = this.energyStored;
                this.energyStored = 0;
            }
            this.energyStored += EnergyNet.getForWorld(this.tile.k).emitEnergyFrom((IEnergySource)((Object)this.tile), emit);
        }
        if (this.resourceTank.quantity <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.resourceTank.quantity > 0;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    public int getStoredScaled(int i) {
        return this.energyStored * i / this.energyMax;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 1: {
                this.resourceTank.quantity = j;
                break;
            }
            case 2: {
                this.energyStored = j;
                break;
            }
            case 3: {
                this.energyMax = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.resourceTank.liquidId);
        iCrafting.a(container, 1, this.resourceTank.quantity);
        iCrafting.a(container, 2, this.energyStored);
        iCrafting.a(container, 3, this.energyMax);
    }

    @Override
    public int k_() {
        return this.inventoryStacks.length;
    }

    @Override
    public ur a(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public ur a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            ur var3 = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return var3;
        }
        ur var3 = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return var3;
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.c()) {
            itemstack.a = this.c();
        }
    }

    @Override
    public ur a_(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ur toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return this.inventoryStacks.length;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container == null) {
            return 0;
        }
        if (!GeneratorFuel.fuels.containsKey(container.stillLiquid.itemID)) {
            return 0;
        }
        if (this.inventoryStacks[0] == null) {
            if (doAdd) {
                this.inventoryStacks[0] = stack.l();
            }
            return stack.a;
        }
        if (!this.inventoryStacks[0].a(stack)) {
            return 0;
        }
        int space = this.inventoryStacks[0].d() - this.inventoryStacks[0].a;
        if (space <= 0) {
            return 0;
        }
        if (doAdd) {
            this.inventoryStacks[0].a += stack.a;
        }
        return Math.min(space, stack.a);
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex != 0) {
            return 0;
        }
        if (!GeneratorFuel.fuels.containsKey(resource.itemID)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.resourceTank;
    }

    @Override
    public boolean emitsEnergyTo(any receiver, Direction direction) {
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.isAddedToEnergyNet;
    }

    @Override
    public int getMaxEnergyOutput() {
        return 20;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineGenerator((TileMachine)tile);
        }
    }
}

