/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IBottlerManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineBottler
extends Machine {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    public static final short SLOT_CAN = 2;
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private ur[] inventoryStacks = new ur[3];
    private boolean productPending = false;
    private Recipe currentRecipe;
    private Stack pendingProducts = new Stack();
    private int fillingTime;
    private int fillingTotalTime;

    public MachineBottler(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("bottler"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.2");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.BottlerGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("FillingTime", this.fillingTime);
        nbttagcompound.a("FillingTotalTime", this.fillingTotalTime);
        nbttagcompound.a("ProductPending", this.productPending);
        bq NBTresourceSlot = new bq();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("ResourceTank", (cd)NBTresourceSlot);
        by nbttaglist = new by();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Items", (cd)nbttaglist);
        nbttaglist = new by();
        ur[] offspring = this.pendingProducts.toArray(new ur[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            offspring[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("PendingProducts", (cd)nbttaglist);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        bq nbttagcompound1;
        int i;
        super.readFromNBT(nbttagcompound);
        this.fillingTime = nbttagcompound.e("FillingTime");
        this.fillingTotalTime = nbttagcompound.e("FillingTotalTime");
        this.productPending = nbttagcompound.n("ProductPending");
        this.resourceTank = new TankSlot(10000);
        if (nbttagcompound.b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.l("ResourceTank"));
        }
        by nbttaglist = nbttagcompound.m("Items");
        this.inventoryStacks = new ur[this.k_()];
        for (i = 0; i < nbttaglist.c(); ++i) {
            nbttagcompound1 = (bq)nbttaglist.b(i);
            byte byte0 = nbttagcompound1.c("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = ur.a((bq)nbttagcompound1);
        }
        nbttaglist = nbttagcompound.m("PendingProducts");
        for (i = 0; i < nbttaglist.c(); ++i) {
            nbttagcompound1 = (bq)nbttaglist.b(i);
            this.pendingProducts.add(ur.a((bq)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        if (this.inventoryStacks[2] != null && (container = LiquidHelper.getLiquidContainer(this.inventoryStacks[2])) != null && RecipeManager.isInput(container.stillLiquid)) {
            this.inventoryStacks[2] = this.replenishByContainer(this.inventoryStacks[2], container, this.resourceTank);
            if (this.inventoryStacks[2].a <= 0) {
                this.inventoryStacks[2] = null;
            }
        }
        if (this.tile.k.G() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.fillingTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
            return false;
        }
        --this.fillingTime;
        if (this.fillingTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        this.pendingProducts.push(this.currentRecipe.bottled.l());
        --this.inventoryStacks[0].a;
        if (this.inventoryStacks[0].a <= 0) {
            this.inventoryStacks[0] = null;
        }
        this.resourceTank.quantity -= this.currentRecipe.input.amount;
        if (this.resourceTank.quantity < 0) {
            this.resourceTank.quantity = 0;
        }
        this.checkRecipe();
        this.resetRecipe();
        while (this.tryAddPending()) {
        }
        return true;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(new LiquidStack(this.resourceTank.liquidId, this.resourceTank.quantity), this.inventoryStacks[0]);
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.fillingTime = 0;
            this.fillingTotalTime = 0;
            return;
        }
        this.fillingTime = this.currentRecipe.cyclesPerUnit;
        this.fillingTotalTime = this.currentRecipe.cyclesPerUnit;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ur next = (ur)this.pendingProducts.peek();
        if (this.addProduct(next, true)) {
            this.pendingProducts.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private boolean addProduct(ur product, boolean all2) {
        for (int i = 1; i < 2; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                this.inventoryStacks[i] = product;
                return true;
            }
            if (!this.inventoryStacks[i].a(product) || (space = this.inventoryStacks[i].d() - this.inventoryStacks[i].a) <= 0) continue;
            if (space >= product.a) {
                this.inventoryStacks[i].a += product.a;
                product.a = 0;
                return true;
            }
            if (all2) continue;
            this.inventoryStacks[i].a = this.inventoryStacks[i].d();
            product.a -= space;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.fillingTime > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventoryStacks[0] == null) {
            return false;
        }
        return (float)this.inventoryStacks[0].a / (float)this.inventoryStacks[0].d() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getFillProgressScaled(int i) {
        if (this.fillingTotalTime == 0) {
            return 0;
        }
        return this.fillingTime * i / this.fillingTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
                break;
            }
            case 1: {
                this.fillingTotalTime = j;
                break;
            }
            case 2: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 3: {
                this.resourceTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.fillingTime);
        iCrafting.a(container, 1, this.fillingTotalTime);
        iCrafting.a(container, 2, this.resourceTank.liquidId);
        iCrafting.a(container, 3, this.resourceTank.quantity);
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (!RecipeManager.hasCan(stack)) {
            return 0;
        }
        if (this.inventoryStacks[0] == null) {
            if (doAdd) {
                this.inventoryStacks[0] = stack.l();
            }
            return stack.a;
        }
        if (this.inventoryStacks[0].a >= this.inventoryStacks[0].d()) {
            return 0;
        }
        if (!this.inventoryStacks[0].a(stack)) {
            return 0;
        }
        int space = this.c() - this.inventoryStacks[0].a;
        if (space >= stack.a) {
            if (doAdd) {
                this.inventoryStacks[0].a += stack.a;
            }
            return stack.a;
        }
        if (doAdd) {
            this.inventoryStacks[0].a = this.c();
        }
        return space;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.inventoryStacks[1] == null) {
            return new ur[0];
        }
        if (this.inventoryStacks[1].a <= 0) {
            return new ur[0];
        }
        ur product = new ur(this.inventoryStacks[1].c, 1, this.inventoryStacks[1].j());
        if (doRemove) {
            --this.inventoryStacks[1].a;
            if (this.inventoryStacks[1].a <= 0) {
                this.inventoryStacks[1] = null;
            }
        }
        return new ur[]{product};
    }

    @Override
    public int k_() {
        return this.inventoryStacks.length;
    }

    @Override
    public ur a(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public ur a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            ur removed = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return removed;
        }
        ur removed = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return removed;
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.c()) {
            itemstack.a = this.c();
        }
    }

    @Override
    public ur a_(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ur toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        switch (side) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 2;
    }

    @Override
    public int getSizeInventorySide(int side) {
        return 1;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.resourceTank.quantity > 0 && this.resourceTank.liquidId != resource.itemID) {
            return 0;
        }
        if (!RecipeManager.isInput(resource)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.resourceTank;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static void initialize() {
    }

    public static class RecipeManager
    implements IBottlerManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int cyclesPerUnit, LiquidStack input, ur can, ur bottled) {
            recipes.add(new Recipe(cyclesPerUnit, input, can, bottled));
        }

        public static Recipe findMatchingRecipe(LiquidStack res, ur empty) {
            if (res == null || empty == null) {
                return null;
            }
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(res, empty)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isInput(LiquidStack res) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.hasInput(res)) continue;
                return true;
            }
            return false;
        }

        public static boolean hasCan(ur res) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.hasCan(res)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List getRecipes() {
            HashMap<ur[], ur[]> recipeList = new HashMap<ur[], ur[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new ur[]{recipe.input.asItemStack(), recipe.can}, new ur[]{recipe.bottled});
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int cyclesPerUnit;
        public final LiquidStack input;
        public final ur can;
        public final ur bottled;

        public Recipe(int cyclesPerUnit, LiquidStack input, ur can, ur bottled) {
            this.cyclesPerUnit = cyclesPerUnit;
            this.input = input;
            this.can = can;
            this.bottled = bottled;
        }

        public boolean matches(LiquidStack res, ur empty) {
            return this.input.isLiquidEqual(res) && res.amount >= this.input.amount && this.can.a(empty);
        }

        public boolean hasInput(LiquidStack res) {
            return this.input.isLiquidEqual(res);
        }

        public boolean hasCan(ur res) {
            return this.can.a(res);
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineBottler((TileMachine)tile);
        }
    }
}

