/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ICentrifugeManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public class MachineCentrifuge
extends Machine {
    private ur[] inventoryStacks = new ur[10];
    public Recipe currentRecipe;
    private int resourceSlot = 0;
    private int inventorySlot1 = 1;
    private Stack pendingProducts = new Stack();
    private int productionTime;
    private int timePerItem;

    public MachineCentrifuge(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("centrifuge"));
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.8");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.CentrifugeGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("ProductionTime", this.productionTime);
        nbttagcompound.a("TimePerItem", this.timePerItem);
        by nbttaglist = new by();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Items", (cd)nbttaglist);
        nbttaglist = new by();
        ur[] offspring = this.pendingProducts.toArray(new ur[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            offspring[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("PendingProducts", (cd)nbttaglist);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        bq nbttagcompound1;
        int i;
        super.readFromNBT(nbttagcompound);
        this.productionTime = nbttagcompound.e("ProductionTime");
        this.timePerItem = nbttagcompound.e("TimePerItem");
        by nbttaglist = nbttagcompound.m("Items");
        this.inventoryStacks = new ur[this.k_()];
        for (i = 0; i < nbttaglist.c(); ++i) {
            nbttagcompound1 = (bq)nbttaglist.b(i);
            byte byte0 = nbttagcompound1.c("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = ur.a((bq)nbttagcompound1);
        }
        nbttaglist = nbttagcompound.m("PendingProducts");
        for (i = 0; i < nbttaglist.c(); ++i) {
            nbttagcompound1 = (bq)nbttaglist.b(i);
            this.pendingProducts.add(ur.a((bq)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        if (this.tile.k.G() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean doWork() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.productionTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        --this.productionTime;
        if (this.productionTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        for (Map.Entry entry : this.currentRecipe.products.entrySet()) {
            if ((Integer)entry.getValue() >= 100) {
                this.pendingProducts.push(((ur)entry.getKey()).l());
                continue;
            }
            if (this.tile.k.t.nextInt(100) >= (Integer)entry.getValue()) continue;
            this.pendingProducts.push(((ur)entry.getKey()).l());
        }
        --this.inventoryStacks[this.resourceSlot].a;
        if (this.inventoryStacks[this.resourceSlot].a <= 0) {
            this.inventoryStacks[this.resourceSlot] = null;
        }
        this.checkRecipe();
        this.resetRecipe();
        this.tryAddPending();
        return true;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.inventoryStacks[this.resourceSlot]);
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.productionTime = 0;
            this.timePerItem = 0;
            return;
        }
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ur next = (ur)this.pendingProducts.peek();
        if (this.addProduct(next, true)) {
            this.pendingProducts.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private boolean addProduct(ur product, boolean all2) {
        for (int i = this.inventorySlot1; i < this.inventoryStacks.length; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                this.inventoryStacks[i] = product;
                return true;
            }
            if (!this.inventoryStacks[i].a(product) || (space = this.inventoryStacks[i].d() - this.inventoryStacks[i].a) <= 0) continue;
            if (space >= product.a) {
                this.inventoryStacks[i].a += product.a;
                product.a = 0;
                return true;
            }
            if (all2) continue;
            this.inventoryStacks[i].a = this.inventoryStacks[i].d();
            product.a -= space;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe != null;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventoryStacks[this.resourceSlot] == null) {
            return false;
        }
        return (float)this.inventoryStacks[this.resourceSlot].a / (float)this.inventoryStacks[this.resourceSlot].d() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return i;
        }
        return this.productionTime * i / this.timePerItem;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.productionTime = j;
                break;
            }
            case 1: {
                this.timePerItem = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.productionTime);
        iCrafting.a(container, 1, this.timePerItem);
    }

    @Override
    public int k_() {
        return this.inventoryStacks.length;
    }

    @Override
    public ur a(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public ur a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            ur product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        ur product = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.c()) {
            itemstack.a = this.c();
        }
    }

    @Override
    public ur a_(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ur toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0 || side == 1) {
            return this.resourceSlot;
        }
        return this.inventorySlot1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 1;
        }
        return 9;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ur product = null;
        for (int i = this.inventorySlot1; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            product = new ur(this.inventoryStacks[i].c, 1, this.inventoryStacks[i].j());
            if (!doRemove) break;
            this.a(i, 1);
            break;
        }
        if (product != null) {
            return new ur[]{product};
        }
        return new ur[0];
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (this.inventoryStacks[this.resourceSlot] == null) {
            if (doAdd) {
                this.inventoryStacks[this.resourceSlot] = stack.l();
            }
            return stack.a;
        }
        if (!this.inventoryStacks[this.resourceSlot].a(stack)) {
            return 0;
        }
        int space = this.inventoryStacks[this.resourceSlot].d() - this.inventoryStacks[this.resourceSlot].a;
        if (space <= 0) {
            return 0;
        }
        if (doAdd) {
            this.inventoryStacks[this.resourceSlot].a = stack.a <= space ? (this.inventoryStacks[this.resourceSlot].a += stack.a) : (this.inventoryStacks[this.resourceSlot].a += space);
        }
        return Math.min(stack.a, space);
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class RecipeManager
    implements ICentrifugeManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerItem, ur resource, HashMap products) {
            recipes.add(new Recipe(timePerItem, resource, products));
        }

        @Override
        public void addRecipe(int timePerItem, ur resource, ur[] produce, int[] chances) {
            HashMap<ur, Integer> products = new HashMap<ur, Integer>();
            int i = 0;
            for (ur prod : produce) {
                products.put(prod, chances[i]);
                ++i;
            }
            this.addRecipe(timePerItem, resource, products);
        }

        @Override
        public void addRecipe(int timePerItem, ur resource, ur primary, ur secondary, int chance) {
            HashMap<ur, Integer> products = new HashMap<ur, Integer>();
            products.put(primary, 100);
            if (secondary != null) {
                products.put(secondary, chance);
            }
            this.addRecipe(timePerItem, resource, products);
        }

        @Override
        public void addRecipe(int timePerItem, ur resource, ur primary) {
            HashMap<ur, Integer> products = new HashMap<ur, Integer>();
            products.put(primary, 100);
            this.addRecipe(timePerItem, resource, products);
        }

        public static Recipe findMatchingRecipe(ur item) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public List getRecipes() {
            HashMap<ur[], ur[]> recipeList = new HashMap<ur[], ur[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new ur[]{recipe.resource}, recipe.products.keySet().toArray(new ur[0]));
            }
            return (List)((Object)recipeList);
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final ur resource;
        public final HashMap products;

        public Recipe(int timePerItem, ur resource, HashMap products) {
            this.timePerItem = timePerItem;
            this.resource = resource;
            this.products = products;
        }

        public boolean matches(ur res) {
            if (res == null && this.resource == null) {
                return true;
            }
            if (res == null && this.resource != null) {
                return false;
            }
            if (res != null && this.resource == null) {
                return false;
            }
            return this.resource.a(res);
        }
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineCentrifuge((TileMachine)tile);
        }
    }
}

