/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.api.core.ITileStructure;
import forestry.api.farming.IFarmComponent;
import forestry.core.gadgets.BlockStructure;
import forestry.core.gadgets.StructureLogic;
import forestry.core.utils.Schemata;
import forestry.farming.gadgets.TileFarm;

public class StructureLogicFarm
extends StructureLogic {
    public static final String UID_FARM = "farm";
    public static final Schemata SCHEMATA_FARM_3x3 = new Schemata(5, 6, 5, "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBMBF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FCCCF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF").setOffsets(-2, -3, -2);
    public static final Schemata SCHEMATA_FARM_4x3 = new Schemata(6, 6, 5, "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBMBF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBABF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FCCCF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF").setOffsets(-2, -3, -3);
    public static final Schemata SCHEMATA_FARM_5x3 = new Schemata(7, 6, 5, "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBABF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBMBF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBABF", "FCCCF", "FFFFF", "FFFFF", "FAAAF", "FAAAF", "FBBBF", "FCCCF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF").setOffsets(-2, -3, -3);

    public StructureLogicFarm(ITileStructure structure) {
        super(UID_FARM, structure);
        this.schematas = new Schemata[]{SCHEMATA_FARM_3x3, SCHEMATA_FARM_4x3, SCHEMATA_FARM_5x3};
        this.metaOnValid.put(Schemata.EnumStructureBlock.BLOCK_B, 1);
    }

    @Override
    protected BlockStructure.EnumStructureState determineMasterState(Schemata schemata, boolean rotate) {
        int maxW = schemata.getWidth();
        int maxD = schemata.getDepth();
        int offsetX = schemata.getxOffset();
        int offsetZ = schemata.getzOffset();
        if (this.rotated) {
            maxW = schemata.getDepth();
            maxD = schemata.getWidth();
            offsetX = schemata.getzOffset();
            offsetZ = schemata.getxOffset();
        }
        for (int i = 0; i < maxW; ++i) {
            for (int j = 0; j < schemata.getHeight(); ++j) {
                block9: for (int k = 0; k < maxD; ++k) {
                    int z2;
                    int x2 = this.structureTile.l + i + offsetX;
                    int y2 = this.structureTile.m + j + schemata.getyOffset();
                    if (!this.structureTile.k.f(x2, y2, z2 = this.structureTile.n + k + offsetZ)) {
                        return BlockStructure.EnumStructureState.INDETERMINATE;
                    }
                    Schemata.EnumStructureBlock required = schemata.getAt(i, j, k, rotate);
                    if (required == Schemata.EnumStructureBlock.ANY) continue;
                    any tile = this.structureTile.k.q(x2, y2, z2);
                    int blockid = this.structureTile.k.a(x2, y2, z2);
                    switch (required) {
                        case AIR: {
                            if (blockid == 0) continue block9;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_A: {
                            if (tile == null || !(tile instanceof IFarmComponent)) {
                                return BlockStructure.EnumStructureState.INVALID;
                            }
                            if (((ITileStructure)tile).getTypeUID().equals(UID_FARM)) continue block9;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_B: 
                        case MASTER: {
                            if (tile == null || !(tile instanceof TileFarm)) {
                                return BlockStructure.EnumStructureState.INVALID;
                            }
                            if (!((TileFarm)tile).hasFunction()) continue block9;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case BLOCK_C: {
                            if (blockid == amq.ao.cm) continue block9;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        case FOREIGN: {
                            if (!(tile instanceof ITileStructure)) continue block9;
                            return BlockStructure.EnumStructureState.INVALID;
                        }
                        default: {
                            return BlockStructure.EnumStructureState.INDETERMINATE;
                        }
                    }
                }
            }
        }
        return BlockStructure.EnumStructureState.VALID;
    }
}

