/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.api.farming.IFarmComponent;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.TileForestry;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TileInventoryAdapter;
import forestry.farming.gadgets.StructureLogicFarm;

public abstract class TileFarm
extends TileForestry
implements IFarmComponent {
    private int buildingBlockId;
    private int buildingBlockMeta;
    protected TileInventoryAdapter inventory;
    IStructureLogic structureLogic;
    private boolean isMaster;
    private int masterX;
    private int masterZ;
    private int masterY;

    public TileFarm() {
        this.buildingBlockId = amq.ao.cm;
        this.buildingBlockMeta = 0;
        this.masterY = -99;
        this.structureLogic = new StructureLogicFarm(this);
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.isMaster = nbttagcompound.n("IsMaster");
        this.masterX = nbttagcompound.e("MasterX");
        this.masterY = nbttagcompound.e("MasterY");
        this.masterZ = nbttagcompound.e("MasterZ");
        this.buildingBlockId = nbttagcompound.e("BuildBlockId");
        this.buildingBlockMeta = nbttagcompound.e("BuildBlockMeta");
        if (this.isMaster) {
            this.makeMaster();
        }
        if (this.inventory != null) {
            this.inventory.readFromNBT(nbttagcompound);
        }
        this.structureLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsMaster", this.isMaster);
        nbttagcompound.a("MasterX", this.masterX);
        nbttagcompound.a("MasterY", this.masterY);
        nbttagcompound.a("MasterZ", this.masterZ);
        nbttagcompound.a("BuildBlockId", this.buildingBlockId);
        nbttagcompound.a("BuildBlockMeta", this.buildingBlockMeta);
        if (this.inventory != null) {
            this.inventory.writeToNBT(nbttagcompound);
        }
        this.structureLogic.writeToNBT(nbttagcompound);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void g() {
        if (!Proxies.common.isSimulating(this.k)) {
            this.updateClientSide();
        } else {
            if (!this.isInited) {
                this.initialize();
                this.isInited = true;
            }
            if (this.k.G() % 100L == 0L && (!this.isIntegratedIntoStructure() || this.isMaster())) {
                this.validateStructure();
            }
            this.updateServerSide();
        }
    }

    protected void updateServerSide() {
        if (!this.isMaster()) {
            return;
        }
    }

    protected void updateClientSide() {
    }

    public int getBlockTexture(int side, int meta) {
        if (amq.p[this.buildingBlockId] == null) {
            return amq.ao.a(side, 0);
        }
        if (meta == 1) {
            return amq.A.a(side, meta);
        }
        return amq.p[this.buildingBlockId].a(side, this.buildingBlockMeta);
    }

    protected abstract void createInventory();

    private void clearInventory() {
        if (this.inventory == null) {
            return;
        }
        for (int i = 0; i < this.inventory.k_(); ++i) {
            if (this.inventory.a(i) == null) continue;
            StackUtils.dropItemStackAsEntity(this.inventory.a(i), this.k, this.l + 2, this.m + 2, this.n);
            this.inventory.a(i, null);
        }
        this.inventory = null;
    }

    @Override
    public Gadget getMachine() {
        return null;
    }

    @Override
    public PacketPayload getPacketPayload() {
        return null;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
    }

    @Override
    public String getTypeUID() {
        return this.structureLogic.getTypeUID();
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    @Override
    public void validateStructure() {
        this.structureLogic.validateStructure();
    }

    @Override
    public void makeMaster() {
        this.isMaster = true;
        if (this.inventory == null) {
            this.createInventory();
        }
    }

    @Override
    public void onStructureReset() {
        this.setCentralTE(null);
        this.k.d(this.l, this.m, this.n, 0);
        this.k.i(this.l, this.m, this.n);
        this.isMaster = false;
        this.clearInventory();
    }

    @Override
    public ITileStructure getCentralTE() {
        if (!this.isIntegratedIntoStructure()) {
            return null;
        }
        if (!this.isMaster) {
            any tile = this.k.q(this.masterX, this.masterY, this.masterZ);
            if (tile instanceof ITileStructure) {
                return (ITileStructure)this.k.q(this.masterX, this.masterY, this.masterZ);
            }
            return null;
        }
        return this;
    }

    @Override
    public void setCentralTE(any tile) {
        if (tile == null || tile == this) {
            this.masterZ = 0;
            this.masterX = 0;
            this.masterY = -99;
            return;
        }
        this.masterX = tile.l;
        this.masterY = tile.m;
        this.masterZ = tile.n;
    }

    protected boolean hasMaster() {
        return this.masterY >= 0;
    }

    @Override
    public la getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isIntegratedIntoStructure() {
        return this.isMaster || this.masterY >= 0;
    }

    @Override
    public boolean hasFunction() {
        return false;
    }

    public int k_() {
        if (this.inventory != null) {
            return this.inventory.k_();
        }
        if (this.hasMaster()) {
            return this.getCentralTE().getInventory().k_();
        }
        return 0;
    }

    public ur a(int slotIndex) {
        if (this.inventory != null) {
            return this.inventory.a(slotIndex);
        }
        if (this.hasMaster()) {
            return this.getCentralTE().getInventory().a(slotIndex);
        }
        return null;
    }

    public ur a(int slotIndex, int amount) {
        if (this.inventory != null) {
            return this.inventory.a(slotIndex, amount);
        }
        if (this.hasMaster()) {
            return this.getCentralTE().getInventory().a(slotIndex, amount);
        }
        return null;
    }

    public ur a_(int slotIndex) {
        if (this.inventory != null) {
            return this.inventory.a_(slotIndex);
        }
        if (this.hasMaster()) {
            return this.getCentralTE().getInventory().a_(slotIndex);
        }
        return null;
    }

    public void a(int slotIndex, ur itemstack) {
        if (this.inventory == null && !Proxies.common.isSimulating(this.k)) {
            this.createInventory();
        }
        if (this.inventory != null) {
            this.inventory.a(slotIndex, itemstack);
        } else if (this.hasMaster()) {
            this.getCentralTE().getInventory().a(slotIndex, itemstack);
        }
    }

    public int c() {
        if (this.inventory != null) {
            return this.inventory.c();
        }
        if (this.hasMaster()) {
            return this.getCentralTE().getInventory().c();
        }
        return 0;
    }

    public String b() {
        return this.inventory.b();
    }

    @Override
    public boolean hasHints() {
        return false;
    }

    @Override
    public String[] getHints() {
        return null;
    }
}

