/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import forestry.api.farming.IFarmComponent;
import forestry.core.utils.TileInventoryAdapter;
import forestry.core.utils.Vect;
import forestry.farming.gadgets.FarmLogic;
import forestry.farming.gadgets.IFarmHousing;
import forestry.farming.gadgets.TileFarm;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.common.ForgeDirection;

public class TileFarmPlain
extends TileFarm
implements IFarmHousing,
IPowerReceptor {
    FarmLogic[] farmLogics;
    TreeMap targets;

    private void createTargets() {
        this.targets = new TreeMap();
        int groundY = this.m - 1;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            any tile;
            any tile2;
            if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) continue;
            System.out.println(String.format("Master at %s/%s/%s:%s", this.l, this.m, this.n, groundY));
            ArrayList<Vect> potential = new ArrayList<Vect>();
            int xOffset = 0;
            int zOffset = 0;
            Vect candidate = new Vect(this.l, this.m, this.n);
            while (true) {
                System.out.println(String.format("New offset for %s: x:%s z:%s", direction, xOffset += direction.offsetX, zOffset += direction.offsetZ));
                System.out.println(String.format("Validating for %s: x:%s y:%s z:%s", direction, this.l + xOffset, groundY, this.n + zOffset));
                any tile3 = this.k.q(this.l + xOffset, groundY, this.n + zOffset);
                if (tile3 == null) {
                    System.out.println("NUll TE");
                    break;
                }
                if (!(tile3 instanceof IFarmComponent)) {
                    System.out.println("Not instaceof of farm component");
                    break;
                }
                candidate = new Vect(this.l + xOffset, groundY, this.n + zOffset);
            }
            System.out.println(String.format("Determined distance for %s at %s.", direction, candidate));
            ForgeDirection search = direction.offsetX != 0 ? ForgeDirection.SOUTH : ForgeDirection.EAST;
            xOffset = 0;
            zOffset = 0;
            Vect start = candidate;
            while ((tile2 = this.k.q(candidate.x + (xOffset += search.offsetX), candidate.y, candidate.z + (zOffset += search.offsetZ))) != null && tile2 instanceof IFarmComponent) {
                start = new Vect(candidate.x + xOffset, candidate.y, candidate.z + zOffset);
            }
            ForgeDirection reverse = search.getOpposite();
            Vect last = start;
            do {
                potential.add(new Vect(last.x + direction.offsetX, last.y, last.z + direction.offsetZ));
                last = new Vect(last.x + reverse.offsetX, last.y, last.z + reverse.offsetZ);
            } while ((tile = this.k.q(candidate.x + xOffset, candidate.y, candidate.z + zOffset)) != null && tile instanceof IFarmComponent);
            System.out.println(String.format("Adding %s to %s", potential.size(), direction));
            this.targets.put(direction, potential.toArray(new Vect[0]));
        }
        System.out.println(this.targets);
    }

    @Override
    protected void createInventory() {
        this.inventory = new TileInventoryAdapter(this, 27, "Items");
    }

    @Override
    protected void updateServerSide() {
        if (!this.isMaster()) {
            return;
        }
        if (this.k.G() % 20L != 0L) {
            return;
        }
        this.doWork();
    }

    @Override
    public void doWork() {
        if (this.targets == null) {
            this.createTargets();
        }
        for (Map.Entry entry : this.targets.entrySet()) {
            if (this.farmLogics.length <= ((ForgeDirection)entry.getKey()).ordinal() - 2 || this.farmLogics[((ForgeDirection)entry.getKey()).ordinal() - 2] == null) continue;
            boolean didCultivate = false;
            for (int i = 0; i < ((Vect[])entry.getValue()).length; ++i) {
                Vect target = ((Vect[])entry.getValue())[i];
                if (!this.farmLogics[((ForgeDirection)entry.getKey()).ordinal() - 2].cultivate(target.x, target.y, target.z, (ForgeDirection)entry.getKey())) continue;
                didCultivate = true;
                break;
            }
            if (!didCultivate) continue;
            break;
        }
    }

    @Override
    public void makeMaster() {
        super.makeMaster();
        if (this.farmLogics == null) {
            this.farmLogics = new FarmLogic[]{new FarmLogic(this)};
            System.out.println("Created new farm logic.");
        }
    }

    @Override
    public void onStructureReset() {
        super.onStructureReset();
        this.farmLogics = null;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return null;
    }

    @Override
    public int powerRequest() {
        return 0;
    }

    @Override
    public yc getWorld() {
        return this.k;
    }
}

