/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.core.config.ForestryItem;
import forestry.mail.EnumAddressee;
import forestry.mail.EnumDeliveryState;
import forestry.mail.EnumPostage;
import forestry.mail.ILetter;
import forestry.mail.IPostOffice;
import forestry.mail.IPostalState;
import forestry.mail.IStamps;
import forestry.mail.MailAddress;
import forestry.mail.POBox;
import forestry.mail.TradeStation;
import forestry.mail.items.ItemLetter;
import forestry.plugins.PluginForestryMail;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;

public class PostOffice
extends ahq
implements IPostOffice {
    public static final String SAVE_NAME = "ForestryMail";
    public static PostOffice cachedPostOffice;
    public static HashMap cachedPOBoxes;
    public static HashMap cachedTradeStations;
    private int[] collectedPostage = new int[EnumPostage.values().length];
    private LinkedList activeTradeStations = new LinkedList();

    public static boolean isValidPOBox(yc world, String username) {
        return username.matches("^[a-zA-Z0-9]+$");
    }

    public static POBox getPOBox(yc world, String username) {
        if (cachedPOBoxes.containsKey(username)) {
            return (POBox)((Object)cachedPOBoxes.get(username));
        }
        POBox pobox = (POBox)world.a(POBox.class, "POBox_" + username);
        if (pobox != null) {
            cachedPOBoxes.put(username, pobox);
        }
        return pobox;
    }

    public static POBox getOrCreatePOBox(yc world, String username) {
        POBox pobox = PostOffice.getPOBox(world, username);
        if (pobox == null) {
            pobox = new POBox(username, true);
            world.a("POBox_" + username, (ahq)pobox);
            pobox.c();
            cachedPOBoxes.put(username, pobox);
            PluginForestryMail.proxy.setPOBoxInfo(world, username, pobox.getPOBoxInfo());
        }
        return pobox;
    }

    public static boolean isValidTradeMoniker(yc world, String moniker) {
        return moniker.matches("^[a-zA-Z0-9]+$");
    }

    public static boolean isAvailableTradeMoniker(yc world, String moniker) {
        return PostOffice.getTradeStation(world, moniker) == null;
    }

    public static TradeStation getTradeStation(yc world, String moniker) {
        if (cachedTradeStations.containsKey(moniker)) {
            return (TradeStation)cachedTradeStations.get(moniker);
        }
        TradeStation trade = (TradeStation)world.a(TradeStation.class, "TradePO_" + moniker);
        if (trade != null && trade.isValid()) {
            cachedTradeStations.put(moniker, trade);
            PostOffice.getPostOffice(world).registerTradeStation(moniker);
            return trade;
        }
        return null;
    }

    public static TradeStation getOrCreateTradeStation(yc world, String owner, String moniker) {
        TradeStation trade = PostOffice.getTradeStation(world, moniker);
        if (trade == null) {
            trade = new TradeStation(owner, moniker, true);
            world.a("TradePO_" + moniker, (ahq)trade);
            trade.c();
            cachedTradeStations.put(moniker, trade);
            PostOffice.getPostOffice(world).registerTradeStation(moniker);
        }
        return trade;
    }

    public static void deleteTradeStation(yc world, String moniker) {
        TradeStation trade = PostOffice.getTradeStation(world, moniker);
        if (trade == null) {
            return;
        }
        trade.invalidate();
        cachedTradeStations.remove(moniker);
        PostOffice.getPostOffice(world).deregisterTradeStation(moniker);
        File file = world.J().b(trade.h);
        file.delete();
    }

    public static IPostOffice getPostOffice(yc world) {
        if (cachedPostOffice != null) {
            return cachedPostOffice;
        }
        PostOffice office = (PostOffice)world.a(PostOffice.class, SAVE_NAME);
        if (office == null) {
            office = new PostOffice();
            world.a(SAVE_NAME, (ahq)office);
        }
        cachedPostOffice = office;
        return office;
    }

    public PostOffice(String s2) {
        super(s2);
    }

    public PostOffice() {
        super(SAVE_NAME);
    }

    public void a(bq nbttagcompound) {
        for (int i = 0; i < this.collectedPostage.length; ++i) {
            if (!nbttagcompound.b("CPS" + i)) continue;
            this.collectedPostage[i] = nbttagcompound.e("CPS" + i);
        }
        int tradeStationCount = nbttagcompound.e("TSC");
        for (int i = 0; i < tradeStationCount; ++i) {
            if (!nbttagcompound.b("TS" + i)) continue;
            this.activeTradeStations.add(nbttagcompound.i("TS" + i));
        }
    }

    public void b(bq nbttagcompound) {
        int i;
        for (i = 0; i < this.collectedPostage.length; ++i) {
            nbttagcompound.a("CPS" + i, this.collectedPostage[i]);
        }
        nbttagcompound.a("TSC", this.activeTradeStations.size());
        for (i = 0; i < this.activeTradeStations.size(); ++i) {
            nbttagcompound.a("TS" + i, (String)this.activeTradeStations.get(i));
        }
    }

    @Override
    public LinkedList getActiveTradeStations() {
        return this.activeTradeStations;
    }

    @Override
    public void registerTradeStation(String moniker) {
        if (!this.activeTradeStations.contains(moniker)) {
            this.activeTradeStations.add(moniker);
        }
    }

    @Override
    public void deregisterTradeStation(String moniker) {
        this.activeTradeStations.removeFirstOccurrence(moniker);
    }

    @Override
    public ur getAnyStamp(int max) {
        return this.getAnyStamp(EnumPostage.values(), max);
    }

    @Override
    public ur getAnyStamp(EnumPostage postage, int max) {
        return this.getAnyStamp(new EnumPostage[]{postage}, max);
    }

    @Override
    public ur getAnyStamp(EnumPostage[] postages, int max) {
        for (EnumPostage postage : postages) {
            int collected = 0;
            if (this.collectedPostage[postage.ordinal()] <= 0) continue;
            if (max >= this.collectedPostage[postage.ordinal()]) {
                collected = this.collectedPostage[postage.ordinal()];
                this.collectedPostage[postage.ordinal()] = 0;
            } else {
                collected = max;
                int n = postage.ordinal();
                this.collectedPostage[n] = this.collectedPostage[n] - max;
            }
            if (collected <= 0) continue;
            return new ur(ForestryItem.stamps, collected, postage.ordinal() - 1);
        }
        return null;
    }

    @Override
    public IPostalState lodgeLetter(yc world, ur itemstack, boolean doLodge) {
        ILetter letter = ItemLetter.getLetter(itemstack);
        if (letter.isProcessed()) {
            return EnumDeliveryState.ALREADY_MAILED;
        }
        if (!letter.isPostPaid()) {
            return EnumDeliveryState.NOT_POSTPAID;
        }
        if (!letter.isMailable()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        IPostalState state = EnumDeliveryState.NOT_MAILABLE;
        for (MailAddress address : letter.getRecipients()) {
            if (address.isPlayer()) {
                state = this.storeInPOBox(world, address, itemstack, doLodge);
                continue;
            }
            if (address.getType() != EnumAddressee.TRADER) continue;
            state = this.handleTradeLetter(world, address, itemstack, doLodge);
        }
        if (!state.isOk()) {
            return state;
        }
        this.collectPostage(letter.getPostage());
        this.c();
        return EnumDeliveryState.OK;
    }

    private IPostalState handleTradeLetter(yc world, MailAddress address, ur letterstack, boolean doLodge) {
        IPostalState state = EnumDeliveryState.NOT_MAILABLE;
        TradeStation trade = PostOffice.getTradeStation(world, address.getIdentifier());
        if (trade == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        state = trade.handleLetter(world, address, letterstack, doLodge);
        return state;
    }

    private EnumDeliveryState storeInPOBox(yc world, MailAddress address, ur letterstack, boolean doLodge) {
        if (!address.isPlayer()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        POBox pobox = PostOffice.getPOBox(world, address.getIdentifier());
        if (pobox == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        if (!pobox.storeLetter(letterstack.l())) {
            return EnumDeliveryState.MAILBOX_FULL;
        }
        PluginForestryMail.proxy.setPOBoxInfo(world, address.getIdentifier(), pobox.getPOBoxInfo());
        return EnumDeliveryState.OK;
    }

    @Override
    public void collectPostage(ur[] stamps) {
        for (ur stamp : stamps) {
            if (stamp == null || !(stamp.b() instanceof IStamps)) continue;
            EnumPostage postage = ((IStamps)stamp.b()).getPostage(stamp);
            int n = postage.ordinal();
            this.collectedPostage[n] = this.collectedPostage[n] + stamp.a;
        }
    }

    static {
        cachedPOBoxes = new HashMap();
        cachedTradeStations = new HashMap();
    }
}

