/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.core.config.ForestryItem;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.StackUtils;
import forestry.mail.EnumAddressee;
import forestry.mail.EnumDeliveryState;
import forestry.mail.EnumPostage;
import forestry.mail.EnumStationState;
import forestry.mail.ILetter;
import forestry.mail.ILetterHandler;
import forestry.mail.IPostalState;
import forestry.mail.IStamps;
import forestry.mail.Letter;
import forestry.mail.MailAddress;
import forestry.mail.PostOffice;
import forestry.mail.TradeStationInfo;
import forestry.mail.items.ItemLetter;
import java.util.ArrayList;

public class TradeStation
extends ahq
implements ILetterHandler,
la {
    public static final String SAVE_NAME = "TradePO_";
    public static final short SLOT_SIZE = 39;
    public static final short SLOT_TRADEGOOD = 0;
    public static final short SLOT_EXCHANGE_1 = 1;
    public static final short SLOT_EXCHANGE_COUNT = 4;
    public static final short SLOT_LETTERS_1 = 5;
    public static final short SLOT_LETTERS_COUNT = 6;
    public static final short SLOT_STAMPS_1 = 11;
    public static final short SLOT_STAMPS_COUNT = 4;
    public static final short SLOT_INPUTBUF_1 = 15;
    public static final short SLOT_OUTPUTBUF_1 = 27;
    public static final short SLOT_BUFFER_COUNT = 12;
    private String owner;
    private String moniker;
    private boolean isInvalid = false;
    private GenericInventoryAdapter inventory = new GenericInventoryAdapter(39, "INV");

    public TradeStation(String owner, String moniker, boolean isMoniker) {
        super(SAVE_NAME + moniker);
        this.owner = owner;
        this.moniker = moniker;
    }

    public TradeStation(String savename) {
        super(savename);
    }

    public void a(bq nbttagcompound) {
        this.owner = nbttagcompound.i("OWN");
        this.moniker = nbttagcompound.i("MNK");
        this.isInvalid = nbttagcompound.n("IVL");
        this.inventory.readFromNBT(nbttagcompound);
    }

    public void b(bq nbttagcompound) {
        if (this.owner != null && !this.owner.isEmpty()) {
            nbttagcompound.a("OWN", this.owner);
        }
        nbttagcompound.a("MNK", this.moniker);
        nbttagcompound.a("IVL", this.isInvalid);
        this.inventory.writeToNBT(nbttagcompound);
    }

    public boolean isValid() {
        return !this.isInvalid;
    }

    public void invalidate() {
        this.isInvalid = true;
    }

    public TradeStationInfo getTradeInfo() {
        ur[] condensedRequired = StackUtils.condenseStacks(this.inventory.getStacks(1, 4));
        EnumStationState state = EnumStationState.OK;
        if (!this.hasPaper()) {
            state = EnumStationState.INSUFFICIENT_PAPER;
        }
        if (!this.canPayPostage(2)) {
            state = EnumStationState.INSUFFICIENT_STAMPS;
        }
        if (this.countFillableOrders(1, this.inventory.a(0)) <= 0) {
            state = EnumStationState.INSUFFICIENT_TRADE_GOOD;
        }
        return new TradeStationInfo(this.moniker, this.inventory.a(0), condensedRequired, state);
    }

    @Override
    public IPostalState handleLetter(yc world, MailAddress address, ur letterstack, boolean doLodge) {
        int storable;
        ILetter letter = ItemLetter.getLetter(letterstack);
        if (!this.hasPaper()) {
            return EnumStationState.INSUFFICIENT_PAPER;
        }
        int ordersToFill = StackUtils.containsSets(this.inventory.getStacks(1, 4), letter.getAttachments());
        if (ordersToFill <= 0) {
            return EnumStationState.INSUFFICIENT_OFFER;
        }
        int fillable = this.countFillableOrders(ordersToFill, this.inventory.a(0));
        if (fillable <= 0) {
            return EnumStationState.INSUFFICIENT_TRADE_GOOD;
        }
        if (fillable < ordersToFill) {
            ordersToFill = fillable;
        }
        if ((storable = this.countStorablePayment(ordersToFill, this.inventory.getStacks(1, 4))) <= 0) {
            return EnumStationState.INSUFFICIENT_BUFFER;
        }
        if (storable < ordersToFill) {
            ordersToFill = storable;
        }
        Letter mail = new Letter(new MailAddress(this.moniker, EnumAddressee.TRADER), letter.getSender());
        mail.setText("Please find your order attached.");
        for (int i = 0; i < ordersToFill; ++i) {
            mail.addAttachment(this.inventory.a(0).l());
        }
        mail.addAttachments(this.getSurplusAttachments(ordersToFill, letter.getAttachments()));
        int requiredPostage = mail.requiredPostage();
        if (!this.canPayPostage(requiredPostage)) {
            return EnumStationState.INSUFFICIENT_STAMPS;
        }
        int[] stampCount = this.getPostage(requiredPostage);
        for (int i = 0; i < stampCount.length; ++i) {
            if (stampCount[i] <= 0) continue;
            mail.addStamps(new ur(ForestryItem.stamps, stampCount[i], EnumPostage.values()[i].ordinal()));
        }
        bq nbttagcompound = new bq();
        mail.writeToNBT(nbttagcompound);
        ur mailstack = new ur(ForestryItem.letters, 1, ItemLetter.encodeMeta(1, ItemLetter.getType(mail)));
        mailstack.d(nbttagcompound);
        IPostalState responseState = PostOffice.getPostOffice(world).lodgeLetter(world, mailstack, doLodge);
        if (!responseState.isOk()) {
            return EnumDeliveryState.NOT_MAILABLE;
        }
        for (int i = 0; i < ordersToFill; ++i) {
            for (ur stack : this.inventory.getStacks(1, 4)) {
                if (stack == null) continue;
                this.inventory.tryAddStack(stack.l(), 27, 12, false);
            }
        }
        this.removePaper();
        this.removeStamps(stampCount);
        this.removeTradegood(ordersToFill);
        this.c();
        if (doLodge && this.owner != null && !this.owner.isEmpty()) {
            Letter confirm = new Letter(new MailAddress(this.moniker, EnumAddressee.TRADER), new MailAddress(this.owner));
            confirm.setText(ordersToFill + " order(s) from " + letter.getSender().getIdentifier() + " were filled.");
            confirm.addStamps(new ur(ForestryItem.stamps, 1, EnumPostage.P_1.ordinal()));
            nbttagcompound = new bq();
            confirm.writeToNBT(nbttagcompound);
            ur confirmstack = new ur(ForestryItem.letters, 1, ItemLetter.encodeMeta(1, ItemLetter.getType(confirm)));
            confirmstack.d(nbttagcompound);
            PostOffice.getPostOffice(world).lodgeLetter(world, confirmstack, doLodge);
        }
        return EnumDeliveryState.OK;
    }

    private int countFillableOrders(int max, ur tradegood) {
        if (tradegood == null) {
            return 0;
        }
        int itemCount = 0;
        for (ur stack : this.inventory.getStacks(15, 12)) {
            if (stack == null || !stack.a(tradegood)) continue;
            itemCount += stack.a;
        }
        return (int)Math.floor(itemCount / tradegood.a);
    }

    private int countStorablePayment(int max, ur[] exchange) {
        GenericInventoryAdapter test = this.inventory.copy();
        int count = 0;
        for (int i = 0; i < max && test.tryAddStacksCopy(exchange, true); ++i) {
            ++count;
        }
        return count;
    }

    private void removeTradegood(int filled) {
        block0: for (int j = 0; j < filled; ++j) {
            int toRemove = this.inventory.a((int)0).a;
            for (int i = 15; i < 27; ++i) {
                ur buffer = this.inventory.a(i);
                if (buffer == null || !buffer.a(this.inventory.a(0))) continue;
                ur decrease = this.inventory.a(i, toRemove);
                if ((toRemove -= decrease.a) <= 0) continue block0;
            }
        }
    }

    private boolean hasPaper() {
        for (ur stack : this.inventory.getStacks(5, 6)) {
            if (stack == null || stack.a <= 0) continue;
            return true;
        }
        return false;
    }

    private void removePaper() {
        for (int i = 5; i < 11; ++i) {
            ur stack = this.inventory.a(i);
            if (stack == null || stack.c != up.aK.cj || stack.a <= 0) continue;
            this.inventory.a(i, 1);
            break;
        }
    }

    private boolean canPayPostage(int postage) {
        int posted = 0;
        for (ur stamp : this.inventory.getStacks(11, 4)) {
            if (stamp == null || !(stamp.b() instanceof IStamps) || (posted += ((IStamps)stamp.b()).getPostage(stamp).getValue() * stamp.a) < postage) continue;
            return true;
        }
        return false;
    }

    private int[] getPostage(int postage) {
        int[] stamps = new int[EnumPostage.values().length];
        for (int i = EnumPostage.values().length - 1; i > 0 && postage > 0; --i) {
            EnumPostage postValue = EnumPostage.values()[i];
            if (postValue.getValue() > postage) continue;
            int num = this.getNumStamps(postValue);
            int max = (int)Math.floor(postage / postValue.getValue());
            if (max < num) {
                num = max;
            }
            stamps[i] = num;
            postage -= num * postValue.getValue();
        }
        return stamps;
    }

    private int getNumStamps(EnumPostage postage) {
        int count = 0;
        for (ur stamp : this.inventory.getStacks(11, 4)) {
            if (stamp == null || !(stamp.b() instanceof IStamps) || ((IStamps)stamp.b()).getPostage(stamp) != postage) continue;
            count += stamp.a;
        }
        return count;
    }

    private void removeStamps(int[] stampCount) {
        for (int i = 1; i < stampCount.length; ++i) {
            if (stampCount[i] <= 0) continue;
            for (int j = 11; j < 15; ++j) {
                ur stamp;
                if (stampCount[i] <= 0 || (stamp = this.inventory.a(j)) == null || !(stamp.b() instanceof IStamps) || ((IStamps)stamp.b()).getPostage(stamp) != EnumPostage.values()[i]) continue;
                ur decrease = this.inventory.a(j, stampCount[i]);
                int n = i;
                stampCount[n] = stampCount[n] - decrease.a;
            }
        }
    }

    private ur[] getSurplusAttachments(int filled, ur[] attachments) {
        int i;
        ArrayList<ur> surplus = new ArrayList<ur>();
        ur[] pool = new ur[attachments.length];
        for (i = 0; i < attachments.length; ++i) {
            if (attachments[i] == null) continue;
            pool[i] = attachments[i].l();
        }
        for (i = 0; i < filled; ++i) {
            ur[] condensedRequired;
            for (ur req : condensedRequired = StackUtils.condenseStacks(this.inventory.getStacks(1, 4))) {
                for (int j = 0; j < pool.length; ++j) {
                    ur pol = pool[j];
                    if (pol == null || !pol.a(req)) continue;
                    if (req.a >= pol.a) {
                        req.a -= pol.a;
                        pool[j] = null;
                        continue;
                    }
                    pol.a -= req.a;
                    req.a = 0;
                }
            }
        }
        for (ur stack : pool) {
            if (stack == null) continue;
            surplus.add(stack);
        }
        return surplus.toArray(new ur[0]);
    }

    public void d() {
        this.c();
        this.inventory.d();
    }

    public void a(int var1, ur var2) {
        this.c();
        this.inventory.a(var1, var2);
    }

    public int k_() {
        return this.inventory.k_();
    }

    public ur a(int var1) {
        return this.inventory.a(var1);
    }

    public ur a(int var1, int var2) {
        return this.inventory.a(var1, var2);
    }

    public ur a_(int var1) {
        return this.inventory.a_(var1);
    }

    public String b() {
        return this.inventory.b();
    }

    public int c() {
        return this.inventory.c();
    }

    public boolean a_(qx var1) {
        return this.inventory.a_(var1);
    }

    public void l_() {
    }

    public void f() {
    }
}

