/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.triggers;

import buildcraft.api.gates.ITriggerParameter;
import forestry.core.gadgets.TileMachine;
import forestry.core.triggers.Trigger;
import forestry.core.utils.StringUtil;
import forestry.mail.gadgets.MachineTrader;

public class TriggerLowInput
extends Trigger {
    float threshold;

    public TriggerLowInput(int id, float threshold) {
        super(id);
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("trigger.input") + " < " + this.threshold * 100.0f + "%";
    }

    @Override
    public boolean isTriggerActive(any tile, ITriggerParameter parameter) {
        if (!(tile instanceof TileMachine)) {
            return false;
        }
        TileMachine machine = (TileMachine)tile;
        if (!(machine.machine instanceof MachineTrader)) {
            return false;
        }
        return !((MachineTrader)machine.machine).hasInputBufMin(this.threshold);
    }
}

