/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes;

import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.core.network.GuiId;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketNBT;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.pipes.EnumFilterType;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;

public class PipeLogicPropolis
extends PipeLogic {
    private EnumFilterType[] typeFilter = new EnumFilterType[6];
    private IAllele[][][] genomeFilter = new IAllele[6][3][2];

    public PipeLogicPropolis() {
        for (int i = 0; i < this.typeFilter.length; ++i) {
            this.typeFilter[i] = EnumFilterType.CLOSED;
        }
    }

    public void readFromNBT(bq nbttagcompound) {
        int i;
        super.readFromNBT(nbttagcompound);
        for (i = 0; i < this.typeFilter.length; ++i) {
            this.typeFilter[i] = EnumFilterType.values()[nbttagcompound.c("TypeFilter" + i)];
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (nbttagcompound.b("GenomeFilterS" + i + "-" + j + "-" + 0)) {
                    this.genomeFilter[i][j][0] = AlleleManager.alleleRegistry.getAllele(nbttagcompound.i("GenomeFilterS" + i + "-" + j + "-" + 0));
                }
                if (!nbttagcompound.b("GenomeFilterS" + i + "-" + j + "-" + 1)) continue;
                this.genomeFilter[i][j][1] = AlleleManager.alleleRegistry.getAllele(nbttagcompound.i("GenomeFilterS" + i + "-" + j + "-" + 1));
            }
        }
    }

    public void writeToNBT(bq nbttagcompound) {
        int i;
        super.writeToNBT(nbttagcompound);
        for (i = 0; i < this.typeFilter.length; ++i) {
            nbttagcompound.a("TypeFilter" + i, (byte)this.typeFilter[i].ordinal());
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.genomeFilter[i][j][0] != null) {
                    nbttagcompound.a("GenomeFilterS" + i + "-" + j + "-" + 0, this.genomeFilter[i][j][0].getUID());
                }
                if (this.genomeFilter[i][j][1] == null) continue;
                nbttagcompound.a("GenomeFilterS" + i + "-" + j + "-" + 1, this.genomeFilter[i][j][1].getUID());
            }
        }
    }

    public boolean blockActivated(qx player) {
        if (!Proxies.common.isSimulating(this.worldObj)) {
            return true;
        }
        if (player.bS() != null && player.bS().c < amq.p.length && amq.p[player.bS().c] instanceof BlockGenericPipe) {
            return false;
        }
        player.openGui(ForestryAPI.instance, GuiId.PropolisPipeGUI.ordinal(), player.p, this.container.l, this.container.m, this.container.n);
        return true;
    }

    public boolean isClosed(ForgeDirection orientation) {
        return this.typeFilter[orientation.ordinal()] == EnumFilterType.CLOSED;
    }

    public boolean isIndiscriminate(ForgeDirection orientation) {
        return this.typeFilter[orientation.ordinal()] == EnumFilterType.ANYTHING;
    }

    public boolean matchType(ForgeDirection orientation, EnumFilterType type, IBee bee) {
        EnumFilterType filter = this.typeFilter[orientation.ordinal()];
        if (filter == EnumFilterType.BEE) {
            return type != EnumFilterType.ITEM && type != EnumFilterType.CLOSED && type != EnumFilterType.CLOSED;
        }
        if (bee != null) {
            if (filter == EnumFilterType.PURE_BREED) {
                return bee.isPureBred(EnumBeeChromosome.SPECIES);
            }
            if (filter == EnumFilterType.NOCTURNAL) {
                return bee.getGenome().getNocturnal();
            }
            if (filter == EnumFilterType.PURE_NOCTURNAL) {
                return bee.getGenome().getNocturnal() && bee.isPureBred(EnumBeeChromosome.NOCTURNAL);
            }
            if (filter == EnumFilterType.FLYER) {
                return bee.getGenome().getTolerantFlyer();
            }
            if (filter == EnumFilterType.PURE_FLYER) {
                return bee.getGenome().getTolerantFlyer() && bee.isPureBred(EnumBeeChromosome.TOLERANT_FLYER);
            }
            if (filter == EnumFilterType.CAVE) {
                return bee.getGenome().getCaveDwelling();
            }
            if (filter == EnumFilterType.PURE_CAVE) {
                return bee.getGenome().getCaveDwelling() && bee.isPureBred(EnumBeeChromosome.CAVE_DWELLING);
            }
        }
        return filter == type;
    }

    public boolean matchAllele(IAllele filter, String ident) {
        if (filter == null) {
            return true;
        }
        return filter.getUID().equals(ident);
    }

    public ArrayList getGenomeFilters(ForgeDirection orientation) {
        ArrayList<IAllele[]> filters = new ArrayList<IAllele[]>();
        for (int i = 0; i < 3; ++i) {
            if (this.genomeFilter[orientation.ordinal()][i] == null || this.genomeFilter[orientation.ordinal()][i][0] == null && this.genomeFilter[orientation.ordinal()][i][1] == null) continue;
            filters.add(this.genomeFilter[orientation.ordinal()][i]);
        }
        return filters;
    }

    public EnumFilterType getTypeFilter(ForgeDirection orientation) {
        return this.typeFilter[orientation.ordinal()];
    }

    public void setTypeFilter(ForgeDirection orientation, EnumFilterType type) {
        this.typeFilter[orientation.ordinal()] = type;
        if (!Proxies.common.isSimulating(this.container.k)) {
            this.sendTypeFilterChange(orientation, type);
        }
    }

    public IAlleleSpecies getSpeciesFilter(ForgeDirection orientation, int pattern, int allele) {
        if (this.genomeFilter[orientation.ordinal()] == null) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()].length <= pattern) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()][pattern] == null) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()][pattern].length <= allele) {
            return null;
        }
        return (IAlleleSpecies)this.genomeFilter[orientation.ordinal()][pattern][allele];
    }

    public void setSpeciesFilter(ForgeDirection orientation, int pattern, int allele, IAllele species) {
        this.genomeFilter[orientation.ordinal()][pattern][allele] = species;
        if (!Proxies.common.isSimulating(this.container.k)) {
            this.sendGenomeFilterChange(orientation, pattern, allele, species);
        }
    }

    public void sendFilterSet(qx player) {
        bq nbttagcompound = new bq();
        this.writeToNBT(nbttagcompound);
        Proxies.net.sendToPlayer(new PacketNBT(100, nbttagcompound), player);
    }

    public void handleTypeFilterChange(PacketPayload payload) {
        this.typeFilter[payload.intPayload[0]] = EnumFilterType.values()[payload.intPayload[1]];
    }

    public void handleGenomeFilterChange(PacketPayload payload) {
        this.genomeFilter[payload.intPayload[0]][payload.intPayload[1]][payload.intPayload[2]] = !payload.stringPayload[0].equals("NULL") ? AlleleManager.alleleRegistry.getAllele(payload.stringPayload[0]) : null;
    }

    public void requestFilterSet() {
        Proxies.net.sendToServer(new PacketCoordinates(101, this.container.l, this.container.m, this.container.n));
    }

    public void sendTypeFilterChange(ForgeDirection orientation, EnumFilterType filter) {
        PacketPayload payload = new PacketPayload(2, 0, 0);
        payload.intPayload[0] = orientation.ordinal();
        payload.intPayload[1] = filter.ordinal();
        Proxies.net.sendToServer(new PacketUpdate(103, this.container.l, this.container.m, this.container.n, payload));
    }

    public void sendGenomeFilterChange(ForgeDirection orientation, int pattern, int allele, IAllele species) {
        PacketPayload payload = new PacketPayload(3, 0, 1);
        payload.intPayload[0] = orientation.ordinal();
        payload.intPayload[1] = pattern;
        payload.intPayload[2] = allele;
        payload.stringPayload[0] = species != null ? species.getUID() : "NULL";
        Proxies.net.sendToServer(new PacketUpdate(102, this.container.l, this.container.m, this.container.n, payload));
    }

    public void handleFilterSet(PacketNBT packet) {
        this.readFromNBT(packet.getTagCompound());
    }
}

