/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.IPacketHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.api.genetics.AlleleManager;
import forestry.api.recipes.RecipeManagers;
import forestry.apiculture.CommandBeekeepingMode;
import forestry.apiculture.CommandGiveBee;
import forestry.apiculture.FlowerProviderCacti;
import forestry.apiculture.FlowerProviderEnd;
import forestry.apiculture.FlowerProviderJungle;
import forestry.apiculture.FlowerProviderMushroom;
import forestry.apiculture.FlowerProviderNetherwart;
import forestry.apiculture.FlowerProviderVanilla;
import forestry.apiculture.FlowerProviderWheat;
import forestry.apiculture.GuiHandlerApiculture;
import forestry.apiculture.PackagesApiculture;
import forestry.apiculture.PacketHandlerApiculture;
import forestry.apiculture.SaveEventHandlerApiculture;
import forestry.apiculture.VillageHandlerApiculture;
import forestry.apiculture.gadgets.BlockAlveary;
import forestry.apiculture.gadgets.BlockAlvearyComponent;
import forestry.apiculture.gadgets.BlockBeehives;
import forestry.apiculture.gadgets.BlockCandle;
import forestry.apiculture.gadgets.BlockStump;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.gadgets.TileAlvearyFan;
import forestry.apiculture.gadgets.TileAlvearyHeater;
import forestry.apiculture.gadgets.TileAlvearySwarmer;
import forestry.apiculture.gadgets.TileSwarm;
import forestry.apiculture.genetics.AlleleBeeSpecies;
import forestry.apiculture.genetics.AlleleEffectAggressive;
import forestry.apiculture.genetics.AlleleEffectBeatific;
import forestry.apiculture.genetics.AlleleEffectCreeper;
import forestry.apiculture.genetics.AlleleEffectDrunkard;
import forestry.apiculture.genetics.AlleleEffectExploration;
import forestry.apiculture.genetics.AlleleEffectGlacial;
import forestry.apiculture.genetics.AlleleEffectHeroic;
import forestry.apiculture.genetics.AlleleEffectIgnition;
import forestry.apiculture.genetics.AlleleEffectMiasmic;
import forestry.apiculture.genetics.AlleleEffectMisanthrope;
import forestry.apiculture.genetics.AlleleEffectNone;
import forestry.apiculture.genetics.AlleleEffectRadioactive;
import forestry.apiculture.genetics.AlleleEffectSnowing;
import forestry.apiculture.genetics.AlleleFlowers;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeHelper;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.genetics.BeekeepingMode;
import forestry.apiculture.genetics.BranchBees;
import forestry.apiculture.genetics.BreedingManager;
import forestry.apiculture.genetics.HiveDrop;
import forestry.apiculture.genetics.JubilanceNone;
import forestry.apiculture.genetics.Mutation;
import forestry.apiculture.genetics.MutationTimeLimited;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.items.ItemBeealyzer;
import forestry.apiculture.items.ItemHabitatLocator;
import forestry.apiculture.items.ItemHiveFrame;
import forestry.apiculture.items.ItemHoneycomb;
import forestry.apiculture.items.ItemImprinter;
import forestry.apiculture.items.ItemScoop;
import forestry.apiculture.items.ItemWaxCast;
import forestry.apiculture.proxy.ProxyApiculture;
import forestry.apiculture.trigger.TriggerNoFrames;
import forestry.apiculture.worldgen.WorldGenHiveEnd;
import forestry.apiculture.worldgen.WorldGenHiveForest;
import forestry.apiculture.worldgen.WorldGenHiveJungle;
import forestry.apiculture.worldgen.WorldGenHiveMeadows;
import forestry.apiculture.worldgen.WorldGenHiveParched;
import forestry.apiculture.worldgen.WorldGenHiveSnow;
import forestry.apiculture.worldgen.WorldGenHiveSwamp;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.gadgets.GadgetManager;
import forestry.core.genetics.Allele;
import forestry.core.items.ItemCrated;
import forestry.core.items.ItemForestry;
import forestry.core.items.ItemForestryBlock;
import forestry.core.items.ItemOverlay;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.Trigger;
import forestry.plugins.NativePlugin;
import java.util.ArrayList;
import java.util.Random;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;

@PluginInfo(pluginID="Apiculture", name="Apiculture", author="SirSengir", url="http://forestry.sengir.net/", description="Adds bees, beekeeping and bee products. Affects world generation.")
public class PluginForestryApiculture
extends NativePlugin {
    @SidedProxy(clientSide="forestry.apiculture.proxy.ClientProxyApiculture", serverSide="forestry.apiculture.proxy.ProxyApiculture")
    public static ProxyApiculture proxy;
    private static final String CONFIG_CATEGORY = "apiculture";
    private Configuration apicultureConfig;
    public static String beekeepingMode;
    public static int beeCycleTicks;
    public static boolean apiarySideSensitive;
    public static Trigger triggerNoFrames;
    private ArrayList forestDrops;
    private ArrayList meadowsDrops;
    private ArrayList desertDrops;
    private ArrayList jungleDrops;
    private ArrayList endDrops;
    private ArrayList snowDrops;
    private ArrayList swampDrops;
    private ArrayList swarmDrops;

    @Override
    public boolean isAvailable() {
        return !Config.disableApiculture;
    }

    @Override
    public String getDescription() {
        return "Apiculture";
    }

    @Override
    public void preInit() {
        super.preInit();
        this.createHiveDropArrays();
        ForestryBlock.beehives = new BlockBeehives(Config.getOrCreateBlockIdProperty("beehives", 199)).b("oreCopper");
        up.e[ForestryBlock.beehives.cm] = null;
        up.e[ForestryBlock.beehives.cm] = new ItemForestryBlock(ForestryBlock.beehives.cm - 256, "oreCopper");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.beehives, (int)0, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.beehives, (int)1, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.beehives, (int)2, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.beehives, (int)3, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.beehives, (int)4, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.beehives, (int)5, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.beehives, (int)6, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.beehives, (int)7, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.beehives, (int)8, (String)"scoop", (int)0);
        BeeManager.beeInterface = new BeeHelper();
        BeeManager.villageBees = new ArrayList[]{new ArrayList(), new ArrayList()};
        ForestryBlock.stump = new BlockStump(Config.getOrCreateBlockIdProperty("stump", 1379), 40).b("stump");
        up.e[ForestryBlock.stump.cm] = null;
        up.e[ForestryBlock.stump.cm] = new ItemForestryBlock(ForestryBlock.stump.cm - 256, "stump");
        ForestryBlock.candle = new BlockCandle(Config.getOrCreateBlockIdProperty("candle", 1378), 39).b("candle");
        up.e[ForestryBlock.candle.cm] = null;
        up.e[ForestryBlock.candle.cm] = new ItemForestryBlock(ForestryBlock.candle.cm - 256, "candle");
        ForestryBlock.alveary = new BlockAlveary(Config.getOrCreateBlockIdProperty("alveary", 1382)).b("alveary");
        up.e[ForestryBlock.alveary.cm] = null;
        up.e[ForestryBlock.alveary.cm] = new ItemForestryBlock(ForestryBlock.alveary.cm - 256, "alveary");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.alveary, (String)"axe", (int)0);
        ForestryBlock.swarmer = new BlockAlvearyComponent(Config.getOrCreateBlockIdProperty("swarmer", 1383), BlockAlvearyComponent.AlvearyComponent.SWARMER).b("swarmer");
        up.e[ForestryBlock.swarmer.cm] = null;
        up.e[ForestryBlock.swarmer.cm] = new ItemForestryBlock(ForestryBlock.swarmer.cm - 256, "swarmer");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.swarmer, (String)"axe", (int)0);
        ForestryBlock.heater = new BlockAlvearyComponent(Config.getOrCreateBlockIdProperty("heater", 1384), BlockAlvearyComponent.AlvearyComponent.HEATER).b("alvearyHeater");
        up.e[ForestryBlock.heater.cm] = null;
        up.e[ForestryBlock.heater.cm] = new ItemForestryBlock(ForestryBlock.heater.cm - 256, "alvearyHeater");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.heater, (String)"axe", (int)0);
        ForestryBlock.fan = new BlockAlvearyComponent(Config.getOrCreateBlockIdProperty("fan", 1385), BlockAlvearyComponent.AlvearyComponent.FAN).b("alvearyFan");
        up.e[ForestryBlock.fan.cm] = null;
        up.e[ForestryBlock.fan.cm] = new ItemForestryBlock(ForestryBlock.fan.cm - 256, "alvearyFan");
        MinecraftForge.setBlockHarvestLevel((amq)ForestryBlock.fan, (String)"axe", (int)0);
        triggerNoFrames = new TriggerNoFrames(620);
    }

    @Override
    public void doInit() {
        super.doInit();
        this.createAlleles();
        this.createMutations();
        this.registerBeehiveDrops();
        BeeManager.breedingManager = new BreedingManager();
        BeeManager.breedingManager.registerBeekeepingMode(BeekeepingMode.easy);
        BeeManager.breedingManager.registerBeekeepingMode(BeekeepingMode.normal);
        BeeManager.breedingManager.registerBeekeepingMode(BeekeepingMode.hard);
        BeeManager.breedingManager.registerBeekeepingMode(BeekeepingMode.hardcore);
        BeeManager.breedingManager.registerBeekeepingMode(BeekeepingMode.insane);
        BeeManager.inducers.put(new ur(ForestryItem.royalJelly), 10);
        this.registerTemplates();
        GameRegistry.registerTileEntity(TileAlveary.class, (String)"forestry.Alveary");
        GameRegistry.registerTileEntity(TileSwarm.class, (String)"forestry.Swarm");
        GameRegistry.registerTileEntity(TileAlvearySwarmer.class, (String)"forestry.AlvearySwarmer");
        GameRegistry.registerTileEntity(TileAlvearyHeater.class, (String)"forestry.AlvearyHeater");
        GameRegistry.registerTileEntity(TileAlvearyFan.class, (String)"forestry.AlvearyFan");
        BeeManager.villageBees[0].add(BeeManager.beeInterface.templateAsGenome(BeeTemplates.getForestTemplate()));
        BeeManager.villageBees[0].add(BeeManager.beeInterface.templateAsGenome(BeeTemplates.getMeadowsTemplate()));
        BeeManager.villageBees[0].add(BeeManager.beeInterface.templateAsGenome(BeeTemplates.getModestTemplate()));
        BeeManager.villageBees[0].add(BeeManager.beeInterface.templateAsGenome(BeeTemplates.getMarshyTemplate()));
        BeeManager.villageBees[0].add(BeeManager.beeInterface.templateAsGenome(BeeTemplates.getWintryTemplate()));
        BeeManager.villageBees[0].add(BeeManager.beeInterface.templateAsGenome(BeeTemplates.getTropicalTemplate()));
        BeeManager.villageBees[1].add(BeeManager.beeInterface.templateAsGenome(BeeTemplates.getForestRainResistTemplate()));
        BeeManager.villageBees[1].add(BeeManager.beeInterface.templateAsGenome(BeeTemplates.getCommonTemplate()));
        BeeManager.villageBees[1].add(BeeManager.beeInterface.templateAsGenome(BeeTemplates.getValiantTemplate()));
        VillageHandlerApiculture villageHandler = new VillageHandlerApiculture();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageHandler);
        VillagerRegistry.instance().registerVillagerType(80, "/gfx/forestry/entities/beekeeper.png");
        VillagerRegistry.instance().registerVillageTradeHandler(80, (VillagerRegistry.IVillageTradeHandler)villageHandler);
    }

    @Override
    public void postInit() {
        super.postInit();
        this.registerDungeonLoot();
        this.apicultureConfig = new Configuration();
        Property apiarySideSense = this.apicultureConfig.get("apiary.sidesensitive", CONFIG_CATEGORY, false);
        apiarySideSense.Comment = "set to false if apiaries should output all items regardless of side a pipe is attached to";
        apiarySideSensitive = Boolean.parseBoolean(apiarySideSense.Value);
        Property breedingMode = this.apicultureConfig.get("beekeeping.mode", CONFIG_CATEGORY, "NORMAL");
        breedingMode.Comment = "change beekeeping modes here. possible values EASY, NORMAL, HARD, HARDCORE, INSANE. mods may add additional modes.";
        beekeepingMode = breedingMode.Value;
        FMLLog.finer((String)("Beekeeping mode read from config: " + beekeepingMode), (Object[])new Object[0]);
        Property additionalFlowers = this.apicultureConfig.get("beekeeping.flowers.custom", CONFIG_CATEGORY, "");
        additionalFlowers.Comment = "add additional flower blocks for apiaries here in the format id:meta. separate blocks using ';'. will be treated like vanilla flowers. not recommended for flowers implemented as tile entities.";
        this.parseAdditionalFlowers(additionalFlowers.Value, FlowerManager.plainFlowers);
        Property beeBlacklist = this.apicultureConfig.get("species.blacklist", CONFIG_CATEGORY, "");
        beeBlacklist.Comment = "add species to blacklist identified by their uid and seperated with ';'.";
        this.parseBeeBlacklist(beeBlacklist.Value);
        this.apicultureConfig.save();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerApiculture();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerApiculture();
    }

    @Override
    protected void registerPackages() {
        GadgetManager.registerMachinePackage(7, PackagesApiculture.getApiaryPackage());
        GadgetManager.registerMillPackage(3, PackagesApiculture.getApiaristChestPackage());
        GadgetManager.registerMillPackage(4, PackagesApiculture.getAnalyzerPackage());
    }

    @Override
    protected void registerItems() {
        ForestryItem.beeQueenGE = new ItemBeeGE(Config.getOrCreateItemIdProperty("beeQueenGE", 13083), EnumBeeType.QUEEN).b("beeQueenGE");
        ForestryItem.beeDroneGE = new ItemBeeGE(Config.getOrCreateItemIdProperty("beeDroneGE", 13084), EnumBeeType.DRONE).b("beeDroneGE");
        ForestryItem.beePrincessGE = new ItemBeeGE(Config.getOrCreateItemIdProperty("beePrincessGE", 13085), EnumBeeType.PRINCESS).b("beePrincessGE");
        ForestryItem.beealyzer = new ItemBeealyzer(Config.getOrCreateItemIdProperty("beealyzer", 13086)).b("beealyzer").c(83);
        ForestryItem.biomeFinder = new ItemHabitatLocator(Config.getOrCreateItemIdProperty("biomeFinder", 13105)).b("biomeFinder").b(9, 6);
        ForestryItem.imprinter = new ItemImprinter(Config.getOrCreateItemIdProperty("imprinter", 13110)).b("imprinter").c(82);
        ForestryItem.frameUntreated = new ItemHiveFrame(Config.getOrCreateItemIdProperty("frameUntreated", 13125), 80).b("frameUntreated").c(64);
        ForestryItem.frameImpregnated = new ItemHiveFrame(Config.getOrCreateItemIdProperty("frameImpregnated", 13126), 240).b("frameImpregnated").c(65);
        ForestryItem.frameProven = new ItemHiveFrame(Config.getOrCreateItemIdProperty("frameProven", 13127), 720).b("frameProven").c(66);
        ForestryItem.scoop = new ItemScoop(Config.getOrCreateItemIdProperty("scoop", 13028)).b("scoop").c(43).d(1);
        MinecraftForge.setToolClass((up)ForestryItem.scoop, (String)"scoop", (int)3);
        ForestryItem.honeyDrop = new ItemOverlay(Config.getOrCreateItemIdProperty("honeyDrop", 13027), tj.l, new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("honey", 15512621, 15255572), new ItemOverlay.OverlayInfo("charged", 0x800505, 10225415).setIsSecret(), new ItemOverlay.OverlayInfo("omega", 0x191919, 4885671).setIsSecret()}).setIcons(109, 110).b("honeyDrop");
        OreDictionary.registerOre((String)"dropHoney", (ur)new ur(ForestryItem.honeyDrop, 1, 0));
        ForestryItem.pollen = new ItemOverlay(Config.getOrCreateItemIdProperty("pollen", 13030), tj.l, new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("normal", 10652197, 10652197), new ItemOverlay.OverlayInfo("crystalline", 0xFFFFFF, 12975871)}).setIcons(46, 45).b("pollen");
        OreDictionary.registerOre((String)"itemPollen", (ur)new ur(ForestryItem.pollen));
        ForestryItem.propolis = new ItemOverlay(Config.getOrCreateItemIdProperty("propolis", 13031), tj.l, new ItemOverlay.OverlayInfo[]{new ItemOverlay.OverlayInfo("normal", 12956238), new ItemOverlay.OverlayInfo("sticky", 13012567), new ItemOverlay.OverlayInfo("pulsating", 2936241).setIsSecret(), new ItemOverlay.OverlayInfo("silky", 0xDDFF00)}).setIcons(98, 1).b("propolis");
        ForestryItem.honeydew = new ItemForestry(Config.getOrCreateItemIdProperty("honeydew", 13033)).b("honeydew").c(47).a(tj.l);
        OreDictionary.registerOre((String)"dropHoneydew", (ur)new ur(ForestryItem.honeydew));
        ForestryItem.royalJelly = new ItemForestry(Config.getOrCreateItemIdProperty("royalJelly", 13032)).b("royalJelly").c(48).a(tj.l);
        OreDictionary.registerOre((String)"dropRoyalJelly", (ur)new ur(ForestryItem.royalJelly));
        ForestryItem.waxCast = new ItemWaxCast(Config.getOrCreateItemIdProperty("waxCast", 13123)).b("waxCast").c(60).a(tj.l);
        ForestryItem.beeComb = new ItemHoneycomb(Config.getOrCreateItemIdProperty("beeCombs", 13104)).b("beeCombs");
        ForestryItem.apiaristHat = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristHelmet", 13100), 0).b("apiaristHelmet").c(101);
        ForestryItem.apiaristChest = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristChest", 13101), 1).b("apiaristChest").c(102);
        ForestryItem.apiaristLegs = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristLegs", 13102), 2).b("apiaristLegs").c(103);
        ForestryItem.apiaristBoots = new ItemArmorApiarist(Config.getOrCreateItemIdProperty("apiaristBoots", 13103), 3).b("apiaristBoots").c(104);
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
        ForestryItem.cratedBeeswax = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedBeeswax", 13528), new ur(ForestryItem.beeswax)).b("cratedBeeswax").c(30);
        ForestryItem.cratedPollen = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedPollen", 13529), new ur(ForestryItem.pollen)).b("cratedPollen").c(31);
        ForestryItem.cratedPropolis = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedPropolis", 13530), new ur(ForestryItem.propolis)).b("cratedPropolis").c(32);
        ForestryItem.cratedHoneydew = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedHoneydew", 13531), new ur(ForestryItem.honeydew)).b("cratedHoneydew").c(33);
        ForestryItem.cratedRoyalJelly = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedRoyalJelly", 13532), new ur(ForestryItem.royalJelly)).b("cratedRoyalJelly").c(34);
        ForestryItem.cratedHoneycombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedHoneycombs", 13527), new ur(ForestryItem.beeComb, 1, 0)).b("cratedHoneycombs").c(29);
        ForestryItem.cratedCocoaComb = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedCocoaComb", 13533), new ur(ForestryItem.beeComb, 1, 1)).b("cratedCocoaComb").c(35);
        ForestryItem.cratedSimmeringCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedSimmeringCombs", 13545), new ur(ForestryItem.beeComb, 1, 2)).b("cratedSimmeringCombs").c(47);
        ForestryItem.cratedStringyCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedStringyCombs", 13546), new ur(ForestryItem.beeComb, 1, 3)).b("cratedStringyCombs").c(48);
        ForestryItem.cratedFrozenCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedFrozenCombs", 13547), new ur(ForestryItem.beeComb, 1, 4)).b("cratedFrozenCombs").c(49);
        ForestryItem.cratedDrippingCombs = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedDrippingCombs", 13548), new ur(ForestryItem.beeComb, 1, 5)).b("cratedDrippingCombs").c(50);
        ForestryItem.cratedRefractoryWax = (ItemCrated)new ItemCrated(Config.getOrCreateItemIdProperty("cratedRefractoryWax", 13549), new ur(ForestryItem.refractoryWax)).b("cratedRefractoryWax").c(51);
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addRecipe(new ur(ForestryItem.apiaristHat), new Object[]{"###", "# #", Character.valueOf('#'), new ur(ForestryItem.craftingMaterial, 1, 3)});
        Proxies.common.addRecipe(new ur(ForestryItem.apiaristChest), new Object[]{"# #", "###", "###", Character.valueOf('#'), new ur(ForestryItem.craftingMaterial, 1, 3)});
        Proxies.common.addRecipe(new ur(ForestryItem.apiaristLegs), new Object[]{"###", "# #", "# #", Character.valueOf('#'), new ur(ForestryItem.craftingMaterial, 1, 3)});
        Proxies.common.addRecipe(new ur(ForestryItem.apiaristBoots), new Object[]{"# #", "# #", Character.valueOf('#'), new ur(ForestryItem.craftingMaterial, 1, 3)});
        Proxies.common.addRecipe(new ur(ForestryItem.biomeFinder), new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), up.aC, Character.valueOf('X'), "ingotBronze"});
        Proxies.common.addRecipe(new ur(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.waxCapsule, Character.valueOf('X'), up.aX, Character.valueOf('Y'), ForestryItem.pollen});
        Proxies.common.addRecipe(new ur(ForestryItem.vialCatalyst, 3), new Object[]{"###", "YXY", Character.valueOf('#'), ForestryItem.canEmpty, Character.valueOf('X'), up.aX, Character.valueOf('Y'), ForestryItem.pollen});
        Proxies.common.addRecipe(new ur(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.fertilizerCompound, Character.valueOf('X'), ForestryItem.waxCapsule});
        Proxies.common.addRecipe(new ur(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.fertilizerCompound, Character.valueOf('X'), ForestryItem.canEmpty});
        Proxies.common.addRecipe(new ur(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.pollen, Character.valueOf('X'), ForestryItem.waxCapsule});
        Proxies.common.addRecipe(new ur(ForestryItem.vialCatalyst), new Object[]{"###", "YXY", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('Y'), ForestryItem.pollen, Character.valueOf('X'), ForestryItem.canEmpty});
        Proxies.common.addRecipe(new ur(ForestryItem.scoop, 1), new Object[]{"#X#", "###", " # ", Character.valueOf('#'), "stickWood", Character.valueOf('X'), amq.ae});
        Proxies.common.addRecipe(new ur(up.aM), new Object[]{"#X#", "#X#", "#X#", Character.valueOf('#'), ForestryItem.propolis, Character.valueOf('X'), ForestryItem.pollen});
        Proxies.common.addRecipe(new ur(up.bB), new Object[]{"#X#", "#Y#", "#X#", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), ForestryItem.honeydew, Character.valueOf('Y'), up.bf});
        Proxies.common.addRecipe(new ur(ForestryItem.frameUntreated), new Object[]{"###", "#S#", "###", Character.valueOf('#'), "stickWood", Character.valueOf('S'), up.K});
        Proxies.common.addRecipe(new ur(ForestryItem.frameImpregnated), new Object[]{"###", "#S#", "###", Character.valueOf('#'), ForestryItem.stickImpregnated, Character.valueOf('S'), up.K});
        if (ForestryItem.honeyedSlice != null) {
            Proxies.common.addRecipe(new ur(ForestryItem.honeyedSlice, 4), new Object[]{"###", "#X#", "###", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), up.U});
        }
        if (ForestryItem.honeyPot != null) {
            Proxies.common.addRecipe(new ur(ForestryItem.honeyPot, 1), new Object[]{"# #", " X ", "# #", Character.valueOf('#'), ForestryItem.honeyDrop, Character.valueOf('X'), ForestryItem.waxCapsule});
        }
        if (ForestryItem.ambrosia != null) {
            Proxies.common.addRecipe(new ur(ForestryItem.ambrosia), new Object[]{"#Y#", "XXX", "###", Character.valueOf('#'), ForestryItem.honeydew, Character.valueOf('X'), ForestryItem.royalJelly, Character.valueOf('Y'), ForestryItem.waxCapsule});
        }
        Proxies.common.addRecipe(GameMode.getGameMode().getRecipeCapsuleOutput(), new Object[]{"###", Character.valueOf('#'), ForestryItem.beeswax});
        Proxies.common.addRecipe(GameMode.getGameMode().getRecipeRefractoryOutput(), new Object[]{"###", Character.valueOf('#'), ForestryItem.refractoryWax});
        Proxies.common.addRecipe(new ur(ForestryItem.bituminousPeat), new Object[]{" # ", "XYX", " # ", Character.valueOf('#'), "dustAsh", Character.valueOf('X'), ForestryItem.peat, Character.valueOf('Y'), ForestryItem.propolis});
        Proxies.common.addRecipe(new ur(amq.at, 3), new Object[]{" # ", " # ", " Y ", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('Y'), "stickWood"});
        Proxies.common.addRecipe(new ur(ForestryItem.craftingMaterial, 1, 1), new Object[]{"# #", " # ", "# #", Character.valueOf('#'), new ur(ForestryItem.propolis, 1, 2)});
        RecipeManagers.carpenterManager.addRecipe(30, new LiquidStack(amq.E, 600), null, new ur(ForestryBlock.candle, 24), new Object[]{" X ", "###", "###", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('X'), up.K});
        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(amq.E, 200), null, new ur(ForestryBlock.candle, 6), new Object[]{"#X#", Character.valueOf('#'), ForestryItem.beeswax, Character.valueOf('X'), new ur(ForestryItem.craftingMaterial, 1, 2)});
        Proxies.common.addRecipe(new ur(ForestryItem.waxCast), new Object[]{"###", "# #", "###", Character.valueOf('#'), ForestryItem.beeswax});
        Proxies.common.addRecipe(new ur(ForestryBlock.alveary), new Object[]{"###", "#X#", "###", Character.valueOf('X'), ForestryItem.impregnatedCasing, Character.valueOf('#'), new ur(ForestryItem.craftingMaterial, 1, 6)});
        Proxies.common.addRecipe(new ur(ForestryBlock.swarmer), new Object[]{"#G#", " X ", "#G#", Character.valueOf('#'), new ur(ForestryItem.tubes, 1, 5), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('G'), up.p});
        Proxies.common.addRecipe(new ur(ForestryBlock.heater), new Object[]{"#I#", " X ", "YYY", Character.valueOf('#'), new ur(ForestryItem.tubes, 1, 4), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), up.o, Character.valueOf('Y'), amq.w});
        Proxies.common.addRecipe(new ur(ForestryBlock.fan), new Object[]{"I I", " X ", "I#I", Character.valueOf('#'), new ur(ForestryItem.tubes, 1, 4), Character.valueOf('X'), ForestryBlock.alveary, Character.valueOf('I'), up.o});
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(ForestryItem.honeyDrop)}, new LiquidStack(ForestryItem.liquidHoney, 100), new ur(ForestryItem.propolis), 5);
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(ForestryItem.honeydew)}, new LiquidStack(ForestryItem.liquidHoney, 100));
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(ForestryItem.phosphor, 2), new ur(amq.H)}, new LiquidStack(amq.G, 2000));
        RecipeManagers.squeezerManager.addRecipe(10, new ur[]{new ur(ForestryItem.phosphor, 2), new ur(amq.y)}, new LiquidStack(amq.G, 1600));
        RecipeManagers.carpenterManager.addRecipe(100, new LiquidStack(amq.E.cm, 2000), null, new ur(ForestryItem.beealyzer), new Object[]{"X#X", "X#X", "RDR", Character.valueOf('#'), amq.bt, Character.valueOf('X'), "ingotTin", Character.valueOf('R'), up.aC, Character.valueOf('D'), up.n});
        RecipeManagers.carpenterManager.addRecipe(50, new LiquidStack(ForestryItem.liquidHoney, 500), null, new ur(ForestryItem.craftingMaterial, 1, 6), new Object[]{" J ", "###", "WPW", Character.valueOf('#'), "plankWood", Character.valueOf('J'), ForestryItem.royalJelly, Character.valueOf('W'), ForestryItem.beeswax, Character.valueOf('P'), ForestryItem.pollen});
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 0), new ur(ForestryItem.beeswax), new ur(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 1), new ur(ForestryItem.beeswax), new ur(up.aW, 1, 3), 50);
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 2), new ur(ForestryItem.refractoryWax), new ur(ForestryItem.phosphor, 2), 70);
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 3), new ur(ForestryItem.propolis), new ur(ForestryItem.honeyDrop), 40);
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 5), new ur(ForestryItem.honeydew), new ur(ForestryItem.honeyDrop), 40);
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 4), new ur[]{new ur(ForestryItem.beeswax), new ur(ForestryItem.honeyDrop), new ur(up.aD), new ur(ForestryItem.pollen, 1, 1)}, new int[]{80, 70, 40, 20});
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 6), new ur(ForestryItem.honeyDrop), new ur(ForestryItem.propolis, 1, 3), 80);
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 7), new ur(ForestryItem.beeswax), new ur(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 8), new ur[]{new ur(ForestryItem.honeyDrop), new ur(ForestryItem.propolis, 1, 2)}, new int[]{40, 100});
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 9), new ur[0], new int[0]);
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 10), new ur[]{new ur(ForestryItem.honeyDrop), new ur(ForestryItem.beeswax), new ur(up.M)}, new int[]{20, 20, 90});
        RecipeManagers.centrifugeManager.addRecipe(80, new ur(ForestryItem.beeComb, 1, 11), new ur[]{new ur(ForestryItem.honeyDrop, 2, 1)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(80, new ur(ForestryItem.beeComb, 1, 12), new ur[]{new ur(ForestryItem.honeyDrop, 1, 1)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(400, new ur(ForestryItem.beeComb, 1, 13), new ur[]{new ur(ForestryItem.honeyDrop, 1, 2)}, new int[]{100});
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 14), new ur[]{new ur(ForestryItem.honeyDrop), new ur(ForestryItem.beeswax), new ur(up.T)}, new int[]{20, 20, 80});
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.beeComb, 1, 15), new ur(ForestryItem.beeswax), new ur(ForestryItem.honeyDrop), 90);
        RecipeManagers.centrifugeManager.addRecipe(5, new ur(ForestryItem.propolis, 1, 3), new ur[]{new ur(ForestryItem.craftingMaterial, 1, 2), new ur(ForestryItem.propolis)}, new int[]{60, 10});
        RecipeManagers.fermenterManager.addRecipe(new ur(ForestryItem.honeydew), 500, 1.0f, new LiquidStack(ForestryItem.liquidMead.cj, 1), new LiquidStack(ForestryItem.liquidHoney.cj, 1));
    }

    @Override
    public void generateSurface(yc world, Random rand, int chunkX, int chunkZ) {
        if (Config.generateBeehives) {
            int randPosZ;
            int randPosY;
            int randPosX;
            int i;
            for (i = 0; i < 3; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveForest().a(world, rand, randPosX, randPosY = rand.nextInt(50) + 42, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
            for (i = 0; i < 3; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveJungle().a(world, rand, randPosX, randPosY = rand.nextInt(50) + 62, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
            for (i = 0; i < 1; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveMeadows().a(world, rand, randPosX, randPosY = rand.nextInt(50) + 42, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveParched().a(world, rand, randPosX, randPosY = rand.nextInt(50) + 42, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                randPosY = rand.nextInt(50) + 42;
                randPosZ = chunkZ + rand.nextInt(16);
                new WorldGenHiveEnd().a(world, rand, randPosX, randPosY, randPosZ);
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveSnow().a(world, rand, randPosX, randPosY = rand.nextInt(50) + 42, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
            for (i = 0; i < 2; ++i) {
                randPosX = chunkX + rand.nextInt(16);
                if (!new WorldGenHiveSwamp().a(world, rand, randPosX, randPosY = rand.nextInt(50) + 42, randPosZ = chunkZ + rand.nextInt(16))) continue;
                return;
            }
        }
    }

    private void registerBeehiveDrops() {
        this.forestDrops.add(new HiveDrop(BeeTemplates.getForestTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 0)}, 80));
        this.forestDrops.add(new HiveDrop(BeeTemplates.getForestRainResistTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 0)}, 8));
        this.forestDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 0)}, 3));
        this.meadowsDrops.add(new HiveDrop(BeeTemplates.getMeadowsTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 0)}, 80));
        this.meadowsDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 0)}, 3));
        this.desertDrops.add(new HiveDrop(BeeTemplates.getModestTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 7)}, 80));
        this.desertDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 7)}, 3));
        this.jungleDrops.add(new HiveDrop(BeeTemplates.getTropicalTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 6)}, 80));
        this.jungleDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 6)}, 3));
        this.endDrops.add(new HiveDrop(BeeTemplates.getEnderTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 8)}, 90));
        this.snowDrops.add(new HiveDrop(BeeTemplates.getWintryTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 4)}, 80));
        this.snowDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 4)}, 3));
        this.swampDrops.add(new HiveDrop(BeeTemplates.getMarshyTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 15)}, 80));
        this.swampDrops.add(new HiveDrop(BeeTemplates.getValiantTemplate(), new ur[]{new ur(ForestryItem.beeComb, 1, 15)}, 3));
    }

    private void registerDungeonLoot() {
        int rarity = Config.dungeonLootRare ? 5 : 10;
        Bee bee = new Bee(BeeManager.beeInterface.templateAsGenome(BeeTemplates.getSteadfastTemplate()));
        ur beeItem = new ur(ForestryItem.beeDroneGE, 1, AlleleManager.alleleRegistry.getFromUIDMap("forestry.steadfast"));
        bq nbttagcompound = new bq();
        bee.writeToNBT(nbttagcompound);
        beeItem.d(nbttagcompound);
        DungeonHooks.addDungeonLoot((ur)beeItem, (int)rarity);
    }

    private void createHiveDropArrays() {
        BeeManager.hiveDrops = new ArrayList[8];
        this.forestDrops = new ArrayList();
        BeeManager.hiveDrops[0] = this.forestDrops;
        this.meadowsDrops = new ArrayList();
        BeeManager.hiveDrops[1] = this.meadowsDrops;
        this.desertDrops = new ArrayList();
        BeeManager.hiveDrops[2] = this.desertDrops;
        this.jungleDrops = new ArrayList();
        BeeManager.hiveDrops[3] = this.jungleDrops;
        this.endDrops = new ArrayList();
        BeeManager.hiveDrops[4] = this.endDrops;
        this.snowDrops = new ArrayList();
        BeeManager.hiveDrops[5] = this.snowDrops;
        this.swampDrops = new ArrayList();
        BeeManager.hiveDrops[6] = this.swampDrops;
        this.swarmDrops = new ArrayList();
        BeeManager.hiveDrops[7] = this.swarmDrops;
    }

    private void createAlleles() {
        BranchBees common = new BranchBees("common", "Vulgapis");
        BranchBees noble = new BranchBees("noble", "Probapis");
        BranchBees industrious = new BranchBees("industrious", "Industrapis");
        BranchBees heroic = new BranchBees("heroic", "Herapis");
        BranchBees infernal = new BranchBees("infernal", "Diapis");
        BranchBees austere = new BranchBees("austere", "Modapis");
        BranchBees end = new BranchBees("end", "Finapis");
        BranchBees vengeful = new BranchBees("vengeful", "Punapis");
        BranchBees tropical = new BranchBees("tropical", "Caldapis");
        BranchBees frozen = new BranchBees("frozen", "Coagapis");
        BranchBees reddened = new BranchBees("reddened", "Rubapis");
        BranchBees festive = new BranchBees("festive", "Festapis");
        BranchBees agrarian = new BranchBees("agrarian", "Rustapis");
        BranchBees boggy = new BranchBees("boggy", "Paludapis");
        Allele.speciesForest = new AlleleBeeSpecies("speciesForest", true, "bees.species.forest", common, "nigrocincta", 1691884, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 0), 30);
        Allele.speciesMeadows = new AlleleBeeSpecies("speciesMeadows", true, "bees.species.meadows", common, "florea", 15667998, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 0), 30);
        Allele.speciesCommon = new AlleleBeeSpecies("speciesCommon", true, "bees.species.common", common, "cerana", 0xB2B2B2, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 0), 35).setIsSecret();
        Allele.speciesCultivated = new AlleleBeeSpecies("speciesCultivated", true, "bees.species.cultivated", common, "mellifera", 5715180, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 0), 40).setIsSecret();
        Allele.speciesNoble = new AlleleBeeSpecies("speciesNoble", false, "bees.species.noble", noble, "nobilis", 15505945, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 5), 20).setIsSecret();
        Allele.speciesMajestic = new AlleleBeeSpecies("speciesMajestic", true, "bees.species.majestic", noble, "regalis", 0x7F0000, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 5), 30).setIsSecret();
        Allele.speciesImperial = new AlleleBeeSpecies("speciesImperial", false, "bees.species.imperial", noble, "imperatorius", 10739759, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 5), 20).addProduct(new ur(ForestryItem.royalJelly), 15).setHasEffect().setIsSecret();
        Allele.speciesDiligent = new AlleleBeeSpecies("speciesDiligent", false, "bees.species.diligent", industrious, "sedulus", 12720620, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 3), 20).setIsSecret();
        Allele.speciesUnweary = new AlleleBeeSpecies("speciesUnweary", true, "bees.species.unweary", industrious, "assiduus", 1698906, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 3), 30).setIsSecret();
        Allele.speciesIndustrious = new AlleleBeeSpecies("speciesIndustrious", false, "bees.species.industrious", industrious, "industria", 0xFFFFFF, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 3), 20).addProduct(new ur(ForestryItem.pollen), 15).setHasEffect().setIsSecret();
        Allele.speciesSteadfast = new AlleleBeeSpecies("speciesSteadfast", false, "bees.species.steadfast", heroic, "legio", 5057301, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 1), 20).setIsSecret().setHasEffect();
        Allele.speciesValiant = new AlleleBeeSpecies("speciesValiant", true, "bees.species.valiant", heroic, "centurio", 6450141, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 1), 30).addSpecialty(new ur(up.aY), 15).setIsSecret();
        Allele.speciesHeroic = new AlleleBeeSpecies("speciesHeroic", false, "bees.species.heroic", heroic, "kraphti", 11785700, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 1), 40).setIsSecret().setHasEffect();
        Allele.speciesSinister = new AlleleBeeSpecies("speciesSinister", false, "bees.species.sinister", infernal, "caecus", 11785700, 10101539).addProduct(new ur(ForestryItem.beeComb, 1, 2), 45).setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesFiendish = new AlleleBeeSpecies("speciesFiendish", true, "bees.species.fiendish", infernal, "diabolus", 14139109, 10101539).addProduct(new ur(ForestryItem.beeComb, 1, 2), 55).addProduct(new ur(ForestryItem.ash), 15).setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesDemonic = new AlleleBeeSpecies("speciesDemonic", false, "bees.species.demonic", infernal, "draco", 16049152, 10101539).addProduct(new ur(ForestryItem.beeComb, 1, 2), 45).addProduct(new ur(up.aT), 15).setHasEffect().setIsSecret().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        Allele.speciesModest = new AlleleBeeSpecies("speciesModest", false, "bees.species.modest", austere, "modicus", 12959366, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 7), 20).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesFrugal = new AlleleBeeSpecies("speciesFrugal", true, "bees.species.frugal", austere, "permodestus", 15260849, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 7), 30).setIsSecret().setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesAustere = new AlleleBeeSpecies("speciesAustere", false, "bees.species.austere", austere, "correpere", 16775874, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 7), 20).addSpecialty(new ur(ForestryItem.beeComb, 1, 10), 50).setHasEffect().setIsSecret().setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        Allele.speciesTropical = new AlleleBeeSpecies("speciesTropical", false, "bees.species.tropical", tropical, "mendelia", 3637280, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 6), 20).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesExotic = new AlleleBeeSpecies("speciesExotic", true, "bees.species.exotic", tropical, "darwini", 3164419, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 6), 30).setIsSecret().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesEdenic = new AlleleBeeSpecies("speciesEdenic", false, "bees.species.edenic", tropical, "humboldti", 3751181, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 6), 20).setHasEffect().setIsSecret().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        Allele.speciesEnded = new AlleleBeeSpecies("speciesEnded", false, "bees.species.ender", end, "notchi", 3211834, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 8), 30).setHasEffect().setIsSecret().setTemperature(EnumTemperature.COLD);
        Allele.speciesWintry = new AlleleBeeSpecies("speciesWintry", false, "bees.species.wintry", frozen, "brumalis", 10551240, 14349811).addProduct(new ur(ForestryItem.beeComb, 1, 4), 30).setTemperature(EnumTemperature.ICY);
        Allele.speciesIcy = new AlleleBeeSpecies("speciesIcy", true, "bees.species.icy", frozen, "coagulis", 0xA0FFFF, 14349811).addProduct(new ur(ForestryItem.beeComb, 1, 4), 20).addProduct(new ur(ForestryItem.craftingMaterial, 1, 5), 20).setTemperature(EnumTemperature.ICY).setIsSecret();
        Allele.speciesGlacial = new AlleleBeeSpecies("speciesGlacial", false, "bees.species.glacial", frozen, "glacialis", 0xEFFFFF, 14349811).addProduct(new ur(ForestryItem.beeComb, 1, 4), 20).addProduct(new ur(ForestryItem.craftingMaterial, 1, 5), 40).setTemperature(EnumTemperature.ICY).setHasEffect().setIsSecret();
        Allele.speciesVindictive = new AlleleBeeSpecies("speciesVindictive", false, "bees.species.vindictive", vengeful, "ultio", 15400947, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 9), 25).setIsSecret().setIsNotCounted();
        Allele.speciesVengeful = new AlleleBeeSpecies("speciesVengeful", false, "bees.species.vengeful", vengeful, "punire", 12770816, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 9), 40).setIsSecret().setIsNotCounted();
        Allele.speciesAvenging = new AlleleBeeSpecies("speciesAvenging", false, "bees.species.avenging", vengeful, "hostimentum", 0xDDFF00, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 9), 40).setIsSecret().setHasEffect().setIsNotCounted();
        Allele.speciesDarkened = new AlleleBeeSpecies("speciesDarkened", false, "bees.species.darkened", reddened, "pahimas", 14139109, 2494249).addProduct(new ur(ForestryItem.beeComb, 1, 0), 100).addSpecialty(new ur(ForestryItem.beeComb, 1, 12), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        Allele.speciesReddened = new AlleleBeeSpecies("speciesReddened", false, "bees.species.reddened", reddened, "xenophos", 16302529, 2494249).addProduct(new ur(ForestryItem.beeComb, 1, 0), 100).addSpecialty(new ur(ForestryItem.beeComb, 1, 11), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        Allele.speciesOmega = new AlleleBeeSpecies("speciesOmega", false, "bees.species.omega", reddened, "slopokis", 0xFEFF8F, 2494249).addProduct(new ur(ForestryItem.beeComb, 1, 0), 100).addSpecialty(new ur(ForestryItem.beeComb, 1, 13), 100).setJubilanceProvider(new JubilanceNone()).setIsSecret().setIsNotCounted();
        Allele.speciesLeporine = new AlleleBeeSpecies("speciesLeporine", false, "bees.species.leporine", festive, "lepus", 0xFEFF8F, 3987287).addProduct(new ur(ForestryItem.beeComb, 1, 6), 30).addProduct(new ur(up.aP), 10).setIsSecret().setIsNotCounted().setHasEffect();
        Allele.speciesMerry = new AlleleBeeSpecies("speciesMerry", false, "bees.species.merry", festive, "feliciter", 0xFFFFFF, 0xD40000).addProduct(new ur(ForestryItem.beeComb, 1, 4), 30).addProduct(new ur(ForestryItem.craftingMaterial, 1, 5), 20).setTemperature(EnumTemperature.ICY).setIsSecret().setIsNotCounted().setHasEffect().setBodyType(2);
        Allele.speciesTipsy = new AlleleBeeSpecies("speciesTipsy", false, "bees.species.tipsy", festive, "ebrius", 0xFFFFFF, 12720620).addProduct(new ur(ForestryItem.beeComb, 1, 4), 30).addProduct(new ur(ForestryItem.craftingMaterial, 1, 5), 20).setTemperature(EnumTemperature.ICY).setIsSecret().setIsNotCounted().setHasEffect();
        Allele.speciesRural = new AlleleBeeSpecies("speciesRural", false, "bees.species.rural", agrarian, "rustico", 0xFEFF8F, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 14), 20).setIsSecret();
        Allele.speciesMarshy = new AlleleBeeSpecies("speciesMarshy", true, "bees.species.marshy", boggy, "adorasti", 5531174, 16768022).addProduct(new ur(ForestryItem.beeComb, 1, 15), 30).setHumidity(EnumHumidity.DAMP);
        Allele.flowersVanilla = new AlleleFlowers("flowersVanilla", new FlowerProviderVanilla(), true);
        Allele.flowersNether = new AlleleFlowers("flowersNether", new FlowerProviderNetherwart());
        Allele.flowersCacti = new AlleleFlowers("flowersCacti", new FlowerProviderCacti());
        Allele.flowersMushrooms = new AlleleFlowers("flowersMushrooms", new FlowerProviderMushroom());
        Allele.flowersEnd = new AlleleFlowers("flowersEnd", new FlowerProviderEnd());
        Allele.flowersJungle = new AlleleFlowers("flowersJungle", new FlowerProviderJungle());
        Allele.flowersSnow = new AlleleFlowers("flowersSnow", new FlowerProviderVanilla(), true);
        Allele.flowersWheat = new AlleleFlowers("flowersWheat", new FlowerProviderWheat(), true);
        Allele.effectNone = new AlleleEffectNone("effectNone");
        Allele.effectAggressive = new AlleleEffectAggressive("effectAggressive");
        Allele.effectHeroic = new AlleleEffectHeroic("effectHeroic");
        Allele.effectBeatific = new AlleleEffectBeatific("effectBeatific");
        Allele.effectMiasmic = new AlleleEffectMiasmic("effectMiasmic");
        Allele.effectMisanthrope = new AlleleEffectMisanthrope("effectMisanthrope");
        Allele.effectGlacial = new AlleleEffectGlacial("effectGlacial");
        Allele.effectRadioactive = new AlleleEffectRadioactive("effectRadioactive");
        Allele.effectCreeper = new AlleleEffectCreeper("effectCreeper");
        Allele.effectIgnition = new AlleleEffectIgnition("effectIgnition");
        Allele.effectExploration = new AlleleEffectExploration("effectExploration");
        Allele.effectFestiveEaster = new AlleleEffectNone("effectFestiveEaster");
        Allele.effectSnowing = new AlleleEffectSnowing("effectSnowing");
        Allele.effectDrunkard = new AlleleEffectDrunkard("effectDrunkard");
    }

    private void createMutations() {
        BeeTemplates.commonA = new Mutation(Allele.speciesForest, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonB = new Mutation(Allele.speciesModest, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonC = new Mutation(Allele.speciesModest, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonD = new Mutation(Allele.speciesWintry, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonE = new Mutation(Allele.speciesWintry, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonF = new Mutation(Allele.speciesWintry, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonG = new Mutation(Allele.speciesTropical, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonH = new Mutation(Allele.speciesTropical, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonI = new Mutation(Allele.speciesTropical, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonJ = new Mutation(Allele.speciesTropical, Allele.speciesWintry, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonK = new Mutation(Allele.speciesMarshy, Allele.speciesForest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonL = new Mutation(Allele.speciesMarshy, Allele.speciesMeadows, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonM = new Mutation(Allele.speciesMarshy, Allele.speciesModest, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonN = new Mutation(Allele.speciesMarshy, Allele.speciesWintry, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.commonO = new Mutation(Allele.speciesMarshy, Allele.speciesTropical, BeeTemplates.getCommonTemplate(), 15);
        BeeTemplates.cultivatedA = new Mutation(Allele.speciesCommon, Allele.speciesForest, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedB = new Mutation(Allele.speciesCommon, Allele.speciesMeadows, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedC = new Mutation(Allele.speciesCommon, Allele.speciesModest, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedD = new Mutation(Allele.speciesCommon, Allele.speciesWintry, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedE = new Mutation(Allele.speciesCommon, Allele.speciesTropical, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.cultivatedF = new Mutation(Allele.speciesCommon, Allele.speciesMarshy, BeeTemplates.getCultivatedTemplate(), 12);
        BeeTemplates.nobleA = new Mutation(Allele.speciesCommon, Allele.speciesCultivated, BeeTemplates.getNobleTemplate(), 10);
        BeeTemplates.majesticA = new Mutation(Allele.speciesNoble, Allele.speciesCultivated, BeeTemplates.getMajesticTemplate(), 8);
        BeeTemplates.imperialA = new Mutation(Allele.speciesNoble, Allele.speciesMajestic, BeeTemplates.getImperialTemplate(), 8);
        BeeTemplates.diligentA = new Mutation(Allele.speciesCommon, Allele.speciesCultivated, BeeTemplates.getDiligentTemplate(), 10);
        BeeTemplates.unwearyA = new Mutation(Allele.speciesDiligent, Allele.speciesCultivated, BeeTemplates.getUnwearyTemplate(), 8);
        BeeTemplates.industriousA = new Mutation(Allele.speciesDiligent, Allele.speciesUnweary, BeeTemplates.getIndustriousTemplate(), 8);
        BeeTemplates.heroicA = new Mutation(Allele.speciesSteadfast, Allele.speciesValiant, BeeTemplates.getHeroicTemplate(), 6).restrictBiome(yy.f.N).restrictBiome(yy.t.N);
        BeeTemplates.sinisterA = new Mutation(Allele.speciesModest, Allele.speciesCultivated, BeeTemplates.getSinisterTemplate(), 60).restrictBiome(yy.j.N);
        BeeTemplates.sinisterB = new Mutation(Allele.speciesTropical, Allele.speciesCultivated, BeeTemplates.getSinisterTemplate(), 60).restrictBiome(yy.j.N);
        BeeTemplates.fiendishA = new Mutation(Allele.speciesSinister, Allele.speciesCultivated, BeeTemplates.getFiendishTemplate(), 40).restrictBiome(yy.j.N);
        BeeTemplates.fiendishB = new Mutation(Allele.speciesSinister, Allele.speciesModest, BeeTemplates.getFiendishTemplate(), 40).restrictBiome(yy.j.N);
        BeeTemplates.fiendishC = new Mutation(Allele.speciesSinister, Allele.speciesTropical, BeeTemplates.getFiendishTemplate(), 40).restrictBiome(yy.j.N);
        BeeTemplates.demonicA = new Mutation(Allele.speciesSinister, Allele.speciesFiendish, BeeTemplates.getDemonicTemplate(), 25).restrictBiome(yy.j.N);
        BeeTemplates.frugalA = new Mutation(Allele.speciesModest, Allele.speciesSinister, BeeTemplates.getFrugalTemplate(), 16).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
        BeeTemplates.frugalB = new Mutation(Allele.speciesModest, Allele.speciesFiendish, BeeTemplates.getFrugalTemplate(), 10).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
        BeeTemplates.austereA = new Mutation(Allele.speciesModest, Allele.speciesFrugal, BeeTemplates.getAustereTemplate(), 8).setTemperatureRainfall(1.9f, 2.0f, 0.0f, 0.1f);
        BeeTemplates.exoticA = new Mutation(Allele.speciesAustere, Allele.speciesTropical, BeeTemplates.getExoticTemplate(), 12);
        BeeTemplates.edenicA = new Mutation(Allele.speciesExotic, Allele.speciesTropical, BeeTemplates.getEdenicTemplate(), 8);
        BeeTemplates.icyA = new Mutation(Allele.speciesIndustrious, Allele.speciesWintry, BeeTemplates.getIcyTemplate(), 12);
        BeeTemplates.glacialA = new Mutation(Allele.speciesIcy, Allele.speciesWintry, BeeTemplates.getGlacialTemplate(), 8);
        BeeTemplates.leporineA = new MutationTimeLimited(Allele.speciesMeadows, Allele.speciesForest, BeeTemplates.getLeporineTemplate(), 10, new MutationTimeLimited.DayMonth(6, 4), new MutationTimeLimited.DayMonth(15, 4)).setIsSecret();
        BeeTemplates.merryA = new MutationTimeLimited(Allele.speciesWintry, Allele.speciesForest, BeeTemplates.getMerryTemplate(), 10, new MutationTimeLimited.DayMonth(21, 12), new MutationTimeLimited.DayMonth(27, 12)).setIsSecret();
        BeeTemplates.tipsyA = new MutationTimeLimited(Allele.speciesWintry, Allele.speciesMeadows, BeeTemplates.getTipsyTemplate(), 10, new MutationTimeLimited.DayMonth(27, 12), new MutationTimeLimited.DayMonth(2, 1)).setIsSecret();
        BeeTemplates.ruralA = new Mutation(Allele.speciesMeadows, Allele.speciesDiligent, BeeTemplates.getRuralTemplate(), 12).restrictBiome(yy.c.N);
        BeeTemplates.vengefulA = new Mutation(Allele.speciesCommon, Allele.speciesVindictive, BeeTemplates.getVengefulTemplate(), 8).setIsSecret();
        BeeTemplates.avengingA = new Mutation(Allele.speciesVengeful, Allele.speciesVindictive, BeeTemplates.getAvengingTemplate(), 4);
        if (!BeeTemplates.hasGoodBreeder()) {
            BeeTemplates.vindictiveA = new Mutation(Allele.speciesCommon, Allele.speciesForest, BeeTemplates.getVindictiveTemplate(), 99).setIsSecret();
            BeeTemplates.vindictiveB = new Mutation(Allele.speciesCommon, Allele.speciesMeadows, BeeTemplates.getVindictiveTemplate(), 99).setIsSecret();
            BeeTemplates.vindictiveC = new Mutation(Allele.speciesCommon, Allele.speciesModest, BeeTemplates.getVindictiveTemplate(), 99).setIsSecret();
            BeeTemplates.vindictiveD = new Mutation(Allele.speciesCommon, Allele.speciesWintry, BeeTemplates.getVindictiveTemplate(), 99).setIsSecret();
            BeeTemplates.vindictiveE = new Mutation(Allele.speciesCommon, Allele.speciesTropical, BeeTemplates.getVindictiveTemplate(), 99).setIsSecret();
        }
    }

    private void registerTemplates() {
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getForestTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getMeadowsTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getCommonTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getCultivatedTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getNobleTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getMajesticTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getImperialTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getDiligentTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getUnwearyTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getIndustriousTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getSteadfastTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getValiantTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getHeroicTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getSinisterTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getFiendishTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getDemonicTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getModestTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getFrugalTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getAustereTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getTropicalTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getExoticTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getEdenicTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getEnderTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getWintryTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getIcyTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getGlacialTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getVindictiveTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getVengefulTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getAvengingTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getDarkenedTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getReddenedTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getOmegaTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getRuralTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getLeporineTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getMerryTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getTipsyTemplate());
        BeeManager.breedingManager.registerBeeTemplate(BeeTemplates.getMarshyTemplate());
    }

    private void parseAdditionalFlowers(String list, ArrayList target) {
        String[] items;
        for (String item : items = list.split("[;]+")) {
            if (item.isEmpty()) continue;
            String[] ident = item.split("[:]+");
            int id = 0;
            int meta = 0;
            if (ident.length > 1) {
                id = Integer.parseInt(ident[0]);
                meta = Integer.parseInt(ident[1]);
            } else {
                id = Integer.parseInt(ident[0]);
            }
            if (id <= 0) continue;
            if (id < amq.p.length && amq.p[id] != null || up.e[id] != null) {
                FMLLog.finer((String)("Adding flower of (" + id + ":" + meta + ") to vanilla flower provider."), (Object[])new Object[0]);
                target.add(new ur(id, 1, meta));
                continue;
            }
            FMLLog.warning((String)("Failed to add flower of (" + id + ":" + meta + ") to vanilla flower provider since it was null."), (Object[])new Object[0]);
        }
    }

    private void parseBeeBlacklist(String list) {
        String[] items;
        for (String item : items = list.split("[;]+")) {
            if (item.isEmpty()) continue;
            FMLCommonHandler.instance().getFMLLogger().finer("Blacklisting bee species identified by " + item);
            BeeManager.breedingManager.blacklistBeeSpecies(item);
        }
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerApiculture();
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public y[] getConsoleCommands() {
        return new y[]{new CommandBeekeepingMode(), new CommandGiveBee(EnumBeeType.DRONE), new CommandGiveBee(EnumBeeType.PRINCESS), new CommandGiveBee(EnumBeeType.QUEEN)};
    }

    static {
        beekeepingMode = "NORMAL";
        beeCycleTicks = 550;
        apiarySideSensitive = false;
    }
}

