/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.api.recipes.RecipeManagers;
import forestry.arboriculture.CommandSpawnForest;
import forestry.arboriculture.CommandSpawnTree;
import forestry.arboriculture.EventHandlerArboriculture;
import forestry.arboriculture.FruitProviderApple;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.GuiHandlerArboriculture;
import forestry.arboriculture.gadgets.BlockArbFence;
import forestry.arboriculture.gadgets.BlockLeaves;
import forestry.arboriculture.gadgets.BlockLog;
import forestry.arboriculture.gadgets.BlockPlanks;
import forestry.arboriculture.gadgets.BlockSapling;
import forestry.arboriculture.gadgets.BlockSlab;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.genetics.AlleleFruit;
import forestry.arboriculture.genetics.AlleleGrowth;
import forestry.arboriculture.genetics.AlleleLeafEffectNone;
import forestry.arboriculture.genetics.AlleleTreeSpecies;
import forestry.arboriculture.genetics.BranchTrees;
import forestry.arboriculture.genetics.BreedingManager;
import forestry.arboriculture.genetics.GrowthProvider;
import forestry.arboriculture.genetics.TreeHelper;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.items.ItemTreealyzer;
import forestry.arboriculture.items.ItemWoodBlock;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.arboriculture.worldgen.WorldGenAcacia;
import forestry.arboriculture.worldgen.WorldGenBalsa;
import forestry.arboriculture.worldgen.WorldGenBirch;
import forestry.arboriculture.worldgen.WorldGenCherry;
import forestry.arboriculture.worldgen.WorldGenChestnut;
import forestry.arboriculture.worldgen.WorldGenLarch;
import forestry.arboriculture.worldgen.WorldGenLime;
import forestry.arboriculture.worldgen.WorldGenOak;
import forestry.arboriculture.worldgen.WorldGenSequoia;
import forestry.arboriculture.worldgen.WorldGenTeak;
import forestry.arboriculture.worldgen.WorldGenWalnut;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Allele;
import forestry.core.items.ItemForestryBlock;
import forestry.core.proxy.Proxies;
import forestry.plugins.NativePlugin;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;

@PluginInfo(pluginID="Arboriculture", name="Arboriculture", author="Binnie & SirSengir", url="http://forestry.sengir.net/", description="Adds additional tree species and products.")
public class PluginForestryArboriculture
extends NativePlugin {
    @SidedProxy(clientSide="forestry.arboriculture.proxy.ClientProxyArboriculture", serverSide="forestry.arboriculture.proxy.ProxyArboriculture")
    public static ProxyArboriculture proxy;
    public static int modelIdSaplings;
    public static int modelIdLeaves;
    public static int modelIdFences;

    @Override
    public boolean isAvailable() {
        return !Config.disableArboriculture;
    }

    @Override
    public String getDescription() {
        return "Arboriculture";
    }

    @Override
    public void preInit() {
        super.preInit();
        ForestryBlock.log1 = new BlockLog(Config.getOrCreateBlockIdProperty("log1", 1388), BlockLog.LogCat.CAT0).b("for.log1");
        up.e[ForestryBlock.log1.cm] = null;
        up.e[ForestryBlock.log1.cm] = new ItemWoodBlock(ForestryBlock.log1.cm - 256, "for.log1");
        ForestryBlock.log2 = new BlockLog(Config.getOrCreateBlockIdProperty("log2", 1389), BlockLog.LogCat.CAT1).b("for.log2");
        up.e[ForestryBlock.log2.cm] = null;
        up.e[ForestryBlock.log2.cm] = new ItemWoodBlock(ForestryBlock.log2.cm - 256, "for.log2");
        ForestryBlock.log3 = new BlockLog(Config.getOrCreateBlockIdProperty("log3", 1390), BlockLog.LogCat.CAT2).b("for.log3");
        up.e[ForestryBlock.log3.cm] = null;
        up.e[ForestryBlock.log3.cm] = new ItemWoodBlock(ForestryBlock.log3.cm - 256, "for.log3");
        ForestryBlock.log4 = new BlockLog(Config.getOrCreateBlockIdProperty("log4", 1391), BlockLog.LogCat.CAT3).b("for.log4");
        up.e[ForestryBlock.log4.cm] = null;
        up.e[ForestryBlock.log4.cm] = new ItemWoodBlock(ForestryBlock.log4.cm - 256, "for.log4");
        OreDictionary.registerOre((String)"logWood", (ur)new ur(ForestryBlock.log1, 1, -1));
        OreDictionary.registerOre((String)"logWood", (ur)new ur(ForestryBlock.log2, 1, -1));
        OreDictionary.registerOre((String)"logWood", (ur)new ur(ForestryBlock.log3, 1, -1));
        OreDictionary.registerOre((String)"logWood", (ur)new ur(ForestryBlock.log4, 1, -1));
        ForestryBlock.planks = new BlockPlanks(Config.getOrCreateBlockIdProperty("planks", 1380)).b("for.planks");
        up.e[ForestryBlock.planks.cm] = null;
        up.e[ForestryBlock.planks.cm] = new ItemWoodBlock(ForestryBlock.planks.cm - 256, "for.planks");
        OreDictionary.registerOre((String)"plankWood", (ur)new ur(ForestryBlock.planks, 1, -1));
        ForestryBlock.slabs1 = new BlockSlab(Config.getOrCreateBlockIdProperty("slabs1", 1386), BlockSlab.SlabCat.CAT_0).b("for.slabs1");
        up.e[ForestryBlock.slabs1.cm] = null;
        up.e[ForestryBlock.slabs1.cm] = new ItemWoodBlock(ForestryBlock.slabs1.cm - 256, "for.slabs1");
        ForestryBlock.slabs2 = new BlockSlab(Config.getOrCreateBlockIdProperty("slabs2", 1387), BlockSlab.SlabCat.CAT_1).b("for.slabs2");
        up.e[ForestryBlock.slabs2.cm] = null;
        up.e[ForestryBlock.slabs2.cm] = new ItemWoodBlock(ForestryBlock.slabs2.cm - 256, "for.slabs2");
        OreDictionary.registerOre((String)"slabWood", (ur)new ur(ForestryBlock.slabs1, 1, -1));
        OreDictionary.registerOre((String)"slabWood", (ur)new ur(ForestryBlock.slabs2, 1, -1));
        ForestryBlock.fences = new BlockArbFence(Config.getOrCreateBlockIdProperty("fences", 1394)).b("for.fences");
        up.e[ForestryBlock.fences.cm] = null;
        up.e[ForestryBlock.fences.cm] = new ItemWoodBlock(ForestryBlock.fences.cm - 256, "for.fences");
        ForestryBlock.saplingGE = new BlockSapling(Config.getOrCreateBlockIdProperty("saplingGE", 1392)).b("saplingGE");
        up.e[ForestryBlock.saplingGE.cm] = null;
        up.e[ForestryBlock.saplingGE.cm] = new ItemForestryBlock(ForestryBlock.saplingGE.cm - 256, "saplingGE");
        ForestryBlock.leaves = new BlockLeaves(Config.getOrCreateBlockIdProperty("leaves", 1393)).b("leaves");
        up.e[ForestryBlock.leaves.cm] = null;
        up.e[ForestryBlock.leaves.cm] = new ItemForestryBlock(ForestryBlock.leaves.cm - 256, "leaves");
        GameRegistry.registerTileEntity(TileSapling.class, (String)"forestry.Sapling");
        GameRegistry.registerTileEntity(TileLeaves.class, (String)"forestry.Leaves");
        TreeManager.treeInterface = new TreeHelper();
        TreeManager.breedingManager = new BreedingManager();
        proxy.initializeRendering();
    }

    @Override
    public void doInit() {
        super.doInit();
        this.createAlleles();
        this.registerTemplates();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerArboriculture());
    }

    @Override
    protected void registerPackages() {
    }

    @Override
    protected void registerItems() {
        ForestryItem.sapling = new ItemGermlingGE(Config.getOrCreateItemIdProperty("sapling", 13128), EnumGermlingType.SAPLING);
        ForestryItem.treealyzer = new ItemTreealyzer(Config.getOrCreateItemIdProperty("treealyzer", 13129)).b("treealyzer").c(81);
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
        int i;
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ur(ForestryBlock.planks, 4, i), new Object[]{new ur(ForestryBlock.log1, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ur(ForestryBlock.planks, 4, 4 + i), new Object[]{new ur(ForestryBlock.log2, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ur(ForestryBlock.planks, 4, 8 + i), new Object[]{new ur(ForestryBlock.log3, 1, i)});
        }
        for (i = 0; i < 4; ++i) {
            Proxies.common.addShapelessRecipe(new ur(ForestryBlock.planks, 4, 12 + i), new Object[]{new ur(ForestryBlock.log4, 1, i)});
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addRecipe(new ur(ForestryBlock.slabs1, 6, i), new Object[]{"###", Character.valueOf('#'), new ur(ForestryBlock.planks, 1, i)});
        }
        for (i = 0; i < 8; ++i) {
            Proxies.common.addRecipe(new ur(ForestryBlock.slabs2, 6, i), new Object[]{"###", Character.valueOf('#'), new ur(ForestryBlock.planks, 1, 8 + i)});
        }
        for (i = 0; i < 16; ++i) {
            Proxies.common.addRecipe(new ur(ForestryBlock.fences, 4, i), new Object[]{"###", "# #", Character.valueOf('#'), new ur(ForestryBlock.planks, 1, i)});
        }
        RecipeManagers.carpenterManager.addRecipe(100, new LiquidStack(amq.E.cm, 2000), null, new ur(ForestryItem.beealyzer), new Object[]{"X#X", "X#X", "RDR", Character.valueOf('#'), amq.bt, Character.valueOf('X'), "ingotCopper", Character.valueOf('R'), up.aC, Character.valueOf('D'), up.n});
    }

    private void createAlleles() {
        BranchTrees conifer = new BranchTrees("Conifer", "");
        BranchTrees decidious = new BranchTrees("Decidious", "");
        BranchTrees jungle = new BranchTrees("Jungle", "");
        BranchTrees african = new BranchTrees("African", "");
        Allele.treeSpruce = new AlleleTreeSpecies("treeSpruce", true, "Spruce", conifer, "Picea abies", 0xFEFF8F, 0xFFFFFF);
        Allele.treePine = new AlleleTreeSpecies("treePine", true, "Pine", conifer, "Pinus sylvestris", 0xFEFF8F, 0xFFFFFF);
        Allele.treeLarch = new AlleleTreeSpecies("treeLarch", true, "Larch", conifer, "Larix decidua", 0xFEFF8F, 0xFFFFFF, WorldGenLarch.class).setBodyType(16);
        Allele.treeOak = new AlleleTreeSpecies("treeOak", true, "Oak", decidious, "Quercus Robur", 0xFEFF8F, 0xFFFFFF, WorldGenOak.class).setIsSecret();
        Allele.treeBirch = new AlleleTreeSpecies("treeBirch", true, "Birch", decidious, "Betula pendula", 0xFEFF8F, 0xFEFF8F, WorldGenBirch.class).setIsSecret();
        Allele.treeJungle = new AlleleTreeSpecies("treeJungle", true, "Jungle", jungle, "tectona", 0xFEFF8F, 0xFFFFFF);
        Allele.treeKapok = new AlleleTreeSpecies("treeKapok", true, "Kapok", jungle, "Ceiba pentandra", 0xFEFF8F, 0xFFFFFF);
        Allele.treeAcacia = new AlleleTreeSpecies("treeAcacia", true, "Acacia", african, "Acacia Erioloba", 0x616101, 0xFFFFFF, WorldGenAcacia.class).setBodyType(23);
        Allele.treeWenge = new AlleleTreeSpecies("treeWenge", true, "Wenge", african, "Millettia laurentii", 0xFEFF8F, 0xFFFFFF);
        Allele.treeBaobab = new AlleleTreeSpecies("treeBaobab", true, "Baobab", african, "Adansonia digitata", 0xFEFF8F, 0xFFFFFF);
        Allele.treeBalsa = new AlleleTreeSpecies("treeBalsa", true, "Balsa", african, "Ochroma pyramidale", 0xFEFF8F, 0xFFFFFF, WorldGenBalsa.class).setBodyType(18);
        Allele.treeTeak = new AlleleTreeSpecies("treeTeak", true, "Teak", null, "Tectona grandis", 0xFEFF8F, 0xFFFFFF, WorldGenTeak.class).setBodyType(21);
        Allele.treeLime = new AlleleTreeSpecies("treeLime", true, "Lime", null, "Tilia tomentosa", 6201607, 0xFFFFFF, WorldGenLime.class).setBodyType(20);
        Allele.treeChestnut = new AlleleTreeSpecies("treeChestnut", true, "Chestnut", null, "Castanea sativa", 6201607, 0xFFFFFF, WorldGenChestnut.class).setGirth(2).setBodyType(22);
        Allele.treeSequioa = new AlleleTreeSpecies("treeSequioa", true, "Sequoia", null, "Sequoia sempervirens", 0xFEFF8F, 0xFFFFFF, WorldGenSequoia.class).setGirth(3).setBodyType(17);
        Allele.treeEbony = new AlleleTreeSpecies("treeEbony", true, "Ebony", null, "Diospyros ebenum", 0xFEFF8F, 0xFFFFFF);
        Allele.treeMahogony = new AlleleTreeSpecies("treeMahogony", true, "Mahogony", null, "Swietenia mahagoni", 0xFEFF8F, 0xFFFFFF);
        Allele.treePalm = new AlleleTreeSpecies("treePalm", true, "Palm", null, "Cocos nucifera", 0xFEFF8F, 0xFFFFFF);
        Allele.treeWalnut = new AlleleTreeSpecies("treeWalnut", true, "Walnut", null, "Juglans regia", 7965781, 0xFFFFFF, WorldGenWalnut.class).setGirth(2).setBodyType(24);
        Allele.treeBoojum = new AlleleTreeSpecies("treeBoojum", true, "Boojum", null, "Fouquieria columnaris", 0xFEFF8F, 0xFFFFFF);
        Allele.treeCherry = new AlleleTreeSpecies("treeCherry", true, "Cherry", null, "Prunus avium", 15110618, 0xFFFFFF, WorldGenCherry.class).setBodyType(19);
        Allele.fruitNone = new AlleleFruit("fruitNone", new FruitProviderNone());
        Allele.fruitApple = new AlleleFruit("fruitApple", new FruitProviderApple());
        Allele.fruitLarch = new AlleleFruit("fruitLarch", new FruitProviderNone());
        Allele.fruitTeak = new AlleleFruit("fruitTeak", new FruitProviderNone());
        Allele.fruitAcacia = new AlleleFruit("fruitAcacia", new FruitProviderNone());
        Allele.fruitLime = new AlleleFruit("fruitLime", new FruitProviderNone());
        Allele.fruitChestnut = new AlleleFruit("fruitChestnut", new FruitProviderNone());
        Allele.fruitWenge = new AlleleFruit("fruitWenge", new FruitProviderNone());
        Allele.fruitBaobab = new AlleleFruit("fruitBaobab", new FruitProviderNone());
        Allele.fruitSequoia = new AlleleFruit("fruitSequoia", new FruitProviderNone());
        Allele.fruitKapok = new AlleleFruit("fruitKapok", new FruitProviderNone());
        Allele.fruitEbony = new AlleleFruit("fruitEbony", new FruitProviderNone());
        Allele.fruitMahogany = new AlleleFruit("fruitMahogany", new FruitProviderNone());
        Allele.fruitBalsa = new AlleleFruit("fruitBalsa", new FruitProviderNone());
        Allele.fruitPalm = new AlleleFruit("fruitPalm", new FruitProviderNone());
        Allele.fruitWalnut = new AlleleFruit("fruitWalnut", new FruitProviderNone());
        Allele.fruitBoojum = new AlleleFruit("fruitBoojum", new FruitProviderNone());
        Allele.fruitCherry = new AlleleFruit("fruitCherry", new FruitProviderNone());
        Allele.growthLightlevel = new AlleleGrowth("growthLightlevel", new GrowthProvider());
        Allele.growthAcacia = new AlleleGrowth("growthAcacia", new GrowthProvider());
        Allele.leavesNone = new AlleleLeafEffectNone("leavesNone");
    }

    private void registerTemplates() {
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getBalsaTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getSequoiaTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getLarchTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getCherryTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getLimeTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getTeakTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getChestnutTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getAcaciaTemplate());
        TreeManager.breedingManager.registerTreeTemplate(TreeTemplates.getWalnutTemplate());
        int rarity = 20;
        if (Config.dungeonLootRare) {
            rarity = 5;
        }
        for (ITree tree : BreedingManager.treeTemplates) {
            DungeonHooks.addDungeonLoot((ur)TreeManager.treeInterface.getGermlingStack(tree, EnumGermlingType.SAPLING), (int)rarity);
        }
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerArboriculture();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public y[] getConsoleCommands() {
        return new y[]{new CommandSpawnTree(), new CommandSpawnForest()};
    }
}

