/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.circuits.ChipsetManager;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.api.fuels.GeneratorFuel;
import forestry.core.circuits.Circuit;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.GadgetManager;
import forestry.energy.GuiHandlerEnergy;
import forestry.energy.PackagesEnergy;
import forestry.energy.circuits.CircuitElectricBoost;
import forestry.energy.circuits.CircuitElectricChoke;
import forestry.energy.circuits.CircuitElectricEfficiency;
import forestry.energy.circuits.CircuitFireDampener;
import forestry.energy.gadgets.BlockEngine;
import forestry.energy.proxy.ProxyEnergy;
import forestry.plugins.NativePlugin;
import net.minecraftforge.liquids.LiquidStack;

@PluginInfo(pluginID="Energy", name="Energy", author="SirSengir", url="http://forestry.sengir.net/", description="Adds several engines compatible with BuildCraft 3 as well as a generator for IC2.")
public class PluginForestryEnergy
extends NativePlugin {
    @SidedProxy(clientSide="forestry.energy.proxy.ClientProxyEnergy", serverSide="forestry.energy.proxy.ProxyEnergy")
    public static ProxyEnergy proxy;

    @Override
    public boolean isAvailable() {
        return !Config.disableEnergy;
    }

    @Override
    public String getDescription() {
        return "Energy";
    }

    @Override
    public void preInit() {
        super.preInit();
        ForestryBlock.engine = new BlockEngine(Config.getOrCreateBlockIdProperty("engine", 204)).b("engine");
        ChipsetManager.circuitRegistry.registerLegacyMapping(1, "forestry.energyChoke1");
        ChipsetManager.circuitRegistry.registerLegacyMapping(2, "forestry.energyDampener1");
        ChipsetManager.circuitRegistry.registerLegacyMapping(3, "forestry.energyEfficiency1");
        ChipsetManager.circuitRegistry.registerLegacyMapping(4, "forestry.energyBoost1");
        ChipsetManager.circuitRegistry.registerLegacyMapping(5, "forestry.energyBoost2");
    }

    @Override
    public void doInit() {
        super.doInit();
        GeneratorFuel.fuels.put(ForestryItem.liquidBiofuel.cj, new GeneratorFuel(new LiquidStack(ForestryItem.liquidBiofuel, 1), 32, 2));
        GeneratorFuel.fuels.put(ForestryItem.liquidBiomass.cj, new GeneratorFuel(new LiquidStack(ForestryItem.liquidBiomass, 1), 8, 1));
        Circuit.energyElectricChoke1 = new CircuitElectricChoke("energyChoke1");
        Circuit.energyFireDampener1 = new CircuitFireDampener("energyDampener1");
        Circuit.energyElectricEfficiency1 = new CircuitElectricEfficiency("energyEfficiency1");
        Circuit.energyElectricBoost1 = new CircuitElectricBoost("energyBoost1", 2, 7, 2, "electric.boost.1", "engineTin", new String[]{"Increases output by 2 MJ/t", "Increases intake by 7 EU/t"});
        Circuit.energyElectricBoost2 = new CircuitElectricBoost("energyBoost2", 2, 15, 4, "electric.boost.2", "engineTin", new String[]{"Increases output by 4 MJ/t", "Increases intake by 15 EU/t"});
    }

    @Override
    protected void registerPackages() {
        GadgetManager.registerEnginePackage(0, PackagesEnergy.getEngineBronzePackage());
        GadgetManager.registerEnginePackage(1, PackagesEnergy.getEngineCopperPackage());
        GadgetManager.registerEnginePackage(2, PackagesEnergy.getEngineTinPackage());
        GadgetManager.registerMachinePackage(4, PackagesEnergy.getGeneratorPackage());
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
        ChipsetManager.solderManager.addRecipe(new ur(ForestryItem.tubes, 1, 0), Circuit.energyElectricChoke1);
        ChipsetManager.solderManager.addRecipe(new ur(ForestryItem.tubes, 1, 1), Circuit.energyElectricBoost1);
        ChipsetManager.solderManager.addRecipe(new ur(ForestryItem.tubes, 1, 2), Circuit.energyElectricBoost2);
        ChipsetManager.solderManager.addRecipe(new ur(ForestryItem.tubes, 1, 3), Circuit.energyElectricEfficiency1);
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerEnergy();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }
}

