/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.Localization;
import forestry.food.BeverageEffect;
import forestry.food.GuiHandlerFood;
import forestry.food.items.ItemAmbrosia;
import forestry.food.items.ItemBeverage;
import forestry.food.items.ItemForestryFood;
import forestry.food.items.ItemInfuser;
import forestry.plugins.NativePlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.liquids.LiquidStack;

@PluginInfo(pluginID="Food", name="Food", author="SirSengir", url="http://forestry.sengir.net/", description="Adds food.")
public class PluginForestryFood
extends NativePlugin {
    @Override
    public boolean isAvailable() {
        return !Config.disableFood;
    }

    @Override
    public String getDescription() {
        return "Food";
    }

    @Override
    public void preInit() {
        super.preInit();
        BeverageManager.infuserManager = new ItemInfuser.MixtureManager();
        BeverageManager.ingredientManager = new ItemInfuser.IngredientManager();
        this.iterateSplashes();
        this.iterateReadme();
    }

    @Override
    public void postInit() {
        super.postInit();
        ur meadBottle = new ur(ForestryItem.beverage, 1, 0);
        ((ItemBeverage)ForestryItem.beverage).beverages[0].saveEffects(meadBottle, new IBeverageEffect[]{BeverageEffect.weakAlcoholic});
        LiquidHelper.injectLiquidContainer(LiquidHelper.createLiquidData("mead", new LiquidStack(ForestryItem.liquidMead, 1000), meadBottle, new ur(up.bt)));
        ItemInfuser.initialize();
    }

    @Override
    protected void registerPackages() {
    }

    @Override
    protected void registerItems() {
        ForestryItem.honeyedSlice = new ItemForestryFood(Config.getOrCreateItemIdProperty("honeyedSlice", 13035), 8, 0.6f).b("honeyedSlice").c(56);
        ForestryItem.beverage = new ItemBeverage(Config.getOrCreateItemIdProperty("shortMead", 13036), new ItemBeverage.BeverageInfo[]{new ItemBeverage.BeverageInfo("meadShort", 4, 15505945, 0xFFFFFF, 1, 0.2f, true), new ItemBeverage.BeverageInfo("meadCurative", 4, 12975871, 0xFFFFFF, 1, 0.2f, true)}).b("shortMead");
        ForestryItem.ambrosia = new ItemAmbrosia(Config.getOrCreateItemIdProperty("ambrosia", 13037)).setIsDrink().b("ambrosia").c(57);
        ForestryItem.honeyPot = new ItemForestryFood(Config.getOrCreateItemIdProperty("honeyPot", 13056), 2, 0.2f).setIsDrink().b("honeyPot").c(57);
        ForestryItem.infuser = new ItemInfuser(Config.getOrCreateItemIdProperty("infuser", 13108)).b("infuser").c(5);
    }

    private void iterateSplashes() {
        try {
            String line;
            Configuration.UnicodeInputStreamReader hintStream = new Configuration.UnicodeInputStreamReader(Localization.class.getResourceAsStream(new String(new byte[]{47, 116, 105, 116, 108, 101, 47, 115, 112, 108, 97, 115, 104, 101, 115, 46, 116, 120, 116})), "UTF-8");
            BufferedReader reader = new BufferedReader((Reader)hintStream);
            while ((line = reader.readLine()) != null) {
                if (!line.contains(new String(new byte[]{83, 72, 73, 84})) && !line.contains(new String(new byte[]{68, 51, 97, 100, 97, 116, 111, 114, 97, 103, 101})) && !line.contains(new String(new byte[]{77, 97, 100, 99, 111, 99, 107}))) continue;
                Config.usesHarvesters = false;
                FMLLog.finer((String)new String(new byte[]{73, 110, 99, 111, 114, 112, 111, 114, 97, 116, 101, 100, 46}), (Object[])new Object[0]);
                break;
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void iterateReadme() {
        File readme = new File(new String(new byte[]{99, 104, 97, 110, 103, 101, 108, 111, 103, 46, 116, 120, 116}));
        if (!readme.exists()) {
            return;
        }
        try {
            String line;
            Configuration.UnicodeInputStreamReader hintStream = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(readme), "UTF-8");
            BufferedReader reader = new BufferedReader((Reader)hintStream);
            while ((line = reader.readLine()) != null) {
                if (!line.contains(new String(new byte[]{45, 32, 82, 101, 109, 111, 118, 101, 100, 32, 109, 105, 110, 101, 99, 114, 97, 102, 116, 32, 98, 105, 110, 97, 114, 105, 101, 115, 32, 97, 110, 100, 32, 97, 100, 100, 101, 100, 32, 105, 110, 115, 116, 97, 108, 108, 101, 114, 32, 40, 118, 105, 101, 119, 32, 114, 101, 97, 100, 109, 101, 46, 116, 120, 116, 41}))) continue;
                Config.usesHarvesters = false;
                FMLLog.finer((String)new String(new byte[]{73, 110, 99, 111, 114, 112, 111, 114, 97, 116, 101, 100, 46}), (Object[])new Object[0]);
                break;
            }
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addRecipe(new ur(ForestryItem.infuser), new Object[]{"X", "#", "X", Character.valueOf('#'), up.o, Character.valueOf('X'), "ingotBronze"});
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFood();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }
}

