/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.IPacketHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.GadgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.Trigger;
import forestry.mail.EnumPostage;
import forestry.mail.GuiHandlerMail;
import forestry.mail.PackagesMail;
import forestry.mail.PacketHandlerMail;
import forestry.mail.SaveEventHandlerMail;
import forestry.mail.TickHandlerMail;
import forestry.mail.items.ItemLetter;
import forestry.mail.items.ItemStamps;
import forestry.mail.proxy.ProxyMail;
import forestry.mail.triggers.TriggerBuffer;
import forestry.mail.triggers.TriggerHasMail;
import forestry.mail.triggers.TriggerLowInput;
import forestry.mail.triggers.TriggerLowPaper;
import forestry.mail.triggers.TriggerLowStamps;
import forestry.plugins.NativePlugin;

@PluginInfo(pluginID="Mail", name="Mail", author="SirSengir", url="http://forestry.sengir.net/", description="Adds Forestry's mail and trade system.")
public class PluginForestryMail
extends NativePlugin {
    @SidedProxy(clientSide="forestry.mail.proxy.ClientProxyMail", serverSide="forestry.mail.proxy.ProxyMail")
    public static ProxyMail proxy;
    public static Trigger triggerHasMail;
    public static Trigger lowPaper25;
    public static Trigger lowPaper10;
    public static Trigger lowPostage40;
    public static Trigger lowPostage20;
    public static Trigger lowInput25;
    public static Trigger lowInput10;
    public static Trigger highBuffer75;
    public static Trigger highBuffer90;

    @Override
    public boolean isAvailable() {
        return !Config.disableMail;
    }

    @Override
    public void preInit() {
        super.preInit();
        TickRegistry.registerTickHandler((ITickHandler)new TickHandlerMail(), (Side)Side.CLIENT);
        triggerHasMail = new TriggerHasMail(611);
        lowPaper25 = new TriggerLowPaper(612, 0.25f);
        lowPaper10 = new TriggerLowPaper(613, 0.1f);
        lowPostage40 = new TriggerLowStamps(614, 40);
        lowPostage20 = new TriggerLowStamps(615, 20);
        lowInput25 = new TriggerLowInput(616, 0.25f);
        lowInput10 = new TriggerLowInput(617, 0.1f);
        highBuffer75 = new TriggerBuffer(618, 0.75f);
        highBuffer90 = new TriggerBuffer(619, 0.9f);
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public String getDescription() {
        return "Mail";
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerMail();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerMail();
    }

    @Override
    protected void registerPackages() {
        GadgetManager.registerMillPackage(5, PackagesMail.getMailboxPackage());
        GadgetManager.registerMillPackage(6, PackagesMail.getTraderPackage());
        GadgetManager.registerMillPackage(7, PackagesMail.getPhilatelistPackage());
    }

    @Override
    protected void registerItems() {
        ForestryItem.stamps = new ItemStamps(Config.getOrCreateItemIdProperty("stamps", 13116), new ItemStamps.StampInfo[]{new ItemStamps.StampInfo("1p", EnumPostage.P_1, 4885671, 0xFFFFFF), new ItemStamps.StampInfo("2p", EnumPostage.P_2, 15255572, 0xFFFFFF), new ItemStamps.StampInfo("5p", EnumPostage.P_5, 10225415, 0xFFFFFF), new ItemStamps.StampInfo("10p", EnumPostage.P_10, 8114616, 0xFFFFFF)}).setIcons(51, 50).b("stamps");
        ForestryItem.letters = new ItemLetter(Config.getOrCreateItemIdProperty("letters", 13117)).b("letters");
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addShapelessRecipe(new ur(ForestryItem.letters, 1), new Object[]{up.aK, new ur(ForestryItem.propolis, 1, -1)});
        if (Config.craftingStampsEnabled) {
            Proxies.common.addRecipe(new ur(ForestryItem.stamps, 9, 0), new Object[]{"XXX", "###", "ZZZ", Character.valueOf('X'), ForestryItem.apatite, Character.valueOf('#'), up.aK, Character.valueOf('Z'), ForestryItem.honeyDrop});
            Proxies.common.addRecipe(new ur(ForestryItem.stamps, 9, 1), new Object[]{"XXX", "###", "ZZZ", Character.valueOf('X'), "ingotCopper", Character.valueOf('#'), up.aK, Character.valueOf('Z'), ForestryItem.honeyDrop});
            Proxies.common.addRecipe(new ur(ForestryItem.stamps, 9, 2), new Object[]{"XXX", "###", "ZZZ", Character.valueOf('X'), "ingotTin", Character.valueOf('#'), up.aK, Character.valueOf('Z'), ForestryItem.honeyDrop});
            Proxies.common.addRecipe(new ur(ForestryItem.stamps, 9, 3), new Object[]{" X ", "###", "ZZZ", Character.valueOf('X'), up.p, Character.valueOf('#'), up.aK, Character.valueOf('Z'), ForestryItem.honeyDrop});
        }
        Proxies.common.addRecipe(new ur(up.aK), new Object[]{"###", Character.valueOf('#'), new ur(ForestryItem.letters, 1, 3)});
        Proxies.common.addRecipe(new ur(up.aK), new Object[]{"###", Character.valueOf('#'), new ur(ForestryItem.letters, 1, 19)});
        Proxies.common.addRecipe(new ur(up.aK), new Object[]{"###", Character.valueOf('#'), new ur(ForestryItem.letters, 1, 35)});
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerMail();
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }
}

