/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.IPickupHandler;
import forestry.api.core.IResupplyHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.proxy.Proxies;
import forestry.plugins.NativePlugin;
import forestry.storage.GuiHandlerStorage;
import forestry.storage.PickupHandlerStorage;
import forestry.storage.ResupplyHandler;
import forestry.storage.items.ItemApiaristBackpack;
import forestry.storage.items.ItemBackpack;
import forestry.storage.items.ItemBackpackAdventurer;
import forestry.storage.items.ItemBackpackBuilder;
import forestry.storage.items.ItemBackpackDigger;
import forestry.storage.items.ItemBackpackForester;
import forestry.storage.items.ItemBackpackHunter;
import forestry.storage.items.ItemBackpackMiner;
import java.util.ArrayList;
import net.minecraftforge.liquids.LiquidStack;

@PluginInfo(pluginID="Storage", name="Storage", author="SirSengir", url="http://forestry.sengir.net/", description="Adds backpacks and crates.")
public class PluginForestryStorage
extends NativePlugin
implements IOreDictionaryHandler {
    private ArrayList minerItems;
    private ArrayList diggerItems;
    private ArrayList foresterItems;
    private ArrayList hunterItems;
    private ArrayList adventurerItems;
    private ArrayList builderItems;
    static String CONFIG_CATEGORY = "backpacks";
    Configuration config;

    @Override
    public boolean isAvailable() {
        return !Config.disableStorage;
    }

    @Override
    public String getDescription() {
        return "Storage";
    }

    @Override
    public void preInit() {
        super.preInit();
        this.createBackpackArrays();
    }

    @Override
    public void postInit() {
        super.postInit();
        this.config = new Configuration();
        Property backpackConf = this.config.get("backpacks.miner.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add additional blocks and items for the miner's backpack here in the format id:meta. separate blocks and items using ';'";
        PluginForestryStorage.parseBackpackItems("Miner's Backpack", backpackConf.Value, BackpackManager.backpackItems[0]);
        backpackConf = this.config.get("backpacks.digger.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add additional blocks and items for the digger's backpack here in the format id:meta. separate blocks and items using ';'";
        PluginForestryStorage.parseBackpackItems("Digger's Backpack", backpackConf.Value, BackpackManager.backpackItems[1]);
        backpackConf = this.config.get("backpacks.forester.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add additional blocks and items for the forester's backpack here in the format id:meta. separate blocks and items using ';'";
        PluginForestryStorage.parseBackpackItems("Forester's Backpack", backpackConf.Value, BackpackManager.backpackItems[2]);
        backpackConf = this.config.get("backpacks.hunter.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add additional blocks and items for the hunter's backpack here in the format id:meta. separate blocks and items using ';'";
        PluginForestryStorage.parseBackpackItems("Hunter's Backpack", backpackConf.Value, BackpackManager.backpackItems[3]);
        backpackConf = this.config.get("backpacks.adventurer.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add blocks and items for the adventurer's backpack here in the format id:meta. separate blocks and items using ';'";
        PluginForestryStorage.parseBackpackItems("Adventurer's Backpack", backpackConf.Value, BackpackManager.backpackItems[4]);
        backpackConf = this.config.get("backpacks.builder.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add blocks and items for the builder's backpack here in the format id:meta. separate blocks and items using ';'";
        PluginForestryStorage.parseBackpackItems("Builder's Backpack", backpackConf.Value, BackpackManager.backpackItems[5]);
        this.config.save();
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerStorage();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerStorage();
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return new ResupplyHandler();
    }

    @Override
    protected void registerPackages() {
    }

    @Override
    protected void registerItems() {
        ForestryItem.apiaristBackpack = new ItemApiaristBackpack(Config.getOrCreateItemIdProperty("apiaristBag", 13048)).b("apiaristBag");
        ForestryItem.minerBackpack = new ItemBackpackMiner(Config.getOrCreateItemIdProperty("minerBag", 13049), 1).b("minerBag");
        ForestryItem.diggerBackpack = new ItemBackpackDigger(Config.getOrCreateItemIdProperty("diggerBag", 13050), 1).b("diggerBag");
        ForestryItem.foresterBackpack = new ItemBackpackForester(Config.getOrCreateItemIdProperty("foresterBag", 13051), 1).b("foresterBag");
        ForestryItem.hunterBackpack = new ItemBackpackHunter(Config.getOrCreateItemIdProperty("hunterBag", 13052), 1).b("hunterBag");
        ForestryItem.adventurerBackpack = new ItemBackpackAdventurer(Config.getOrCreateItemIdProperty("adventurerBackpack", 13096), 1).b("adventurerBackpack");
        ForestryItem.builderBackpack = new ItemBackpackBuilder(Config.getOrCreateItemIdProperty("builderBackpack", 13106), 1).b("builderBackpack");
        ForestryItem.minerBackpackT2 = new ItemBackpackMiner(Config.getOrCreateItemIdProperty("minerBagT2", 13088), 2).b("minerBagT2");
        ForestryItem.diggerBackpackT2 = new ItemBackpackDigger(Config.getOrCreateItemIdProperty("diggerBagT2", 13089), 2).b("diggerBagT2");
        ForestryItem.foresterBackpackT2 = new ItemBackpackForester(Config.getOrCreateItemIdProperty("foresterBagT2", 13090), 2).b("foresterBagT2");
        ForestryItem.hunterBackpackT2 = new ItemBackpackHunter(Config.getOrCreateItemIdProperty("hunterBagT2", 13091), 2).b("hunterBagT2");
        ForestryItem.adventurerBackpackT2 = new ItemBackpackAdventurer(Config.getOrCreateItemIdProperty("adventurerBackpackT2", 13097), 2).b("adventurerBackpackT2");
        ForestryItem.builderBackpackT2 = new ItemBackpackBuilder(Config.getOrCreateItemIdProperty("builderBackpackT2", 13107), 2).b("builderBackpackT2");
        PickupHandlerStorage.backpacks = new ItemBackpack[]{(ItemBackpack)ForestryItem.apiaristBackpack, (ItemBackpack)ForestryItem.minerBackpack, (ItemBackpack)ForestryItem.diggerBackpack, (ItemBackpack)ForestryItem.foresterBackpack, (ItemBackpack)ForestryItem.hunterBackpack, (ItemBackpack)ForestryItem.adventurerBackpack, (ItemBackpack)ForestryItem.builderBackpack};
    }

    @Override
    protected void registerBackpackItems() {
        this.minerItems.add(new ur(amq.as));
        this.minerItems.add(new ur(amq.L));
        this.minerItems.add(new ur(up.m));
        this.minerItems.add(new ur(amq.az));
        this.minerItems.add(new ur(up.n));
        this.minerItems.add(new ur(amq.J));
        this.minerItems.add(new ur(up.p));
        this.minerItems.add(new ur(amq.K));
        this.minerItems.add(new ur(up.o));
        this.minerItems.add(new ur(amq.Q));
        this.minerItems.add(new ur(amq.aQ));
        this.minerItems.add(new ur(up.aC));
        this.minerItems.add(new ur(up.aW, 1, 4));
        this.minerItems.add(new ur(up.aT));
        this.minerItems.add(new ur(up.bH));
        this.minerItems.add(new ur(ForestryItem.bronzePickaxe));
        this.minerItems.add(new ur(ForestryItem.kitPickaxe));
        this.minerItems.add(new ur(ForestryItem.brokenBronzePickaxe));
        this.diggerItems.add(new ur(amq.y));
        this.diggerItems.add(new ur(amq.z));
        this.diggerItems.add(new ur(amq.H));
        this.diggerItems.add(new ur(amq.T));
        this.diggerItems.add(new ur(amq.I));
        this.diggerItems.add(new ur(up.ap));
        this.diggerItems.add(new ur(amq.be));
        this.diggerItems.add(new ur(up.aI));
        this.diggerItems.add(new ur(amq.bf));
        this.diggerItems.add(new ur(ForestryItem.bronzeShovel));
        this.diggerItems.add(new ur(ForestryItem.kitShovel));
        this.diggerItems.add(new ur(ForestryItem.brokenBronzeShovel));
        this.foresterItems.add(new ur(amq.B, 1, -1));
        this.foresterItems.add(new ur((amq)amq.aj));
        this.foresterItems.add(new ur((amq)amq.ai));
        this.foresterItems.add(new ur(amq.M, 1, -1));
        this.foresterItems.add(new ur(up.S));
        this.foresterItems.add(new ur((amq)amq.ah));
        this.foresterItems.add(new ur((amq)amq.ag));
        this.foresterItems.add(new ur((amq)amq.N, 1, -1));
        this.foresterItems.add(new ur(amq.aY));
        this.foresterItems.add(new ur((amq)amq.aa, 1, -1));
        this.foresterItems.add(new ur(amq.bx));
        this.foresterItems.add(new ur(up.j));
        this.foresterItems.add(new ur(up.at));
        this.foresterItems.add(new ur(up.br));
        this.foresterItems.add(new ur(up.bg));
        this.foresterItems.add(new ur(up.bh));
        this.hunterItems.add(new ur(up.L));
        this.hunterItems.add(new ur(up.M));
        this.hunterItems.add(new ur(up.bw));
        this.hunterItems.add(new ur(up.bo));
        this.hunterItems.add(new ur(up.aX));
        this.hunterItems.add(new ur(up.K));
        this.hunterItems.add(new ur(up.bm));
        this.hunterItems.add(new ur(up.bp));
        this.hunterItems.add(new ur(up.bq));
        this.hunterItems.add(new ur(up.l));
        this.hunterItems.add(new ur(up.aq));
        this.hunterItems.add(new ur(up.ar));
        this.hunterItems.add(new ur(up.bi));
        this.hunterItems.add(new ur(up.bj));
        this.hunterItems.add(new ur(up.bk));
        this.hunterItems.add(new ur(up.bl));
        this.hunterItems.add(new ur(up.aF));
        this.hunterItems.add(new ur(up.aP));
        this.hunterItems.add(new ur(up.bn));
        this.hunterItems.add(new ur(up.bu));
        this.hunterItems.add(new ur(up.bv));
        this.hunterItems.add(new ur(up.aM));
        this.hunterItems.add(new ur(up.aW, 1, 0));
        this.hunterItems.add(new ur(amq.ae));
        this.hunterItems.add(new ur(amq.ae, 1, -1));
        this.hunterItems.add(new ur(up.bA));
        this.hunterItems.add(new ur(up.bx));
        this.hunterItems.add(new ur(up.bB));
        this.hunterItems.add(new ur(up.aU));
        this.hunterItems.add(new ur(up.aV));
        this.builderItems.add(new ur(amq.at));
        this.builderItems.add(new ur(amq.bp, 1, -1));
        this.builderItems.add(new ur(amq.w));
        this.builderItems.add(new ur(amq.ao));
        this.builderItems.add(new ur(amq.A, 1, -1));
        this.builderItems.add(new ur(amq.bD));
        this.builderItems.add(new ur(amq.bE));
        this.builderItems.add(new ur(amq.aK));
        this.builderItems.add(new ur(amq.aw));
        this.builderItems.add(new ur(amq.bz));
        this.builderItems.add(new ur(amq.bF));
        this.builderItems.add(new ur(amq.bA));
        this.builderItems.add(new ur(amq.P));
        this.builderItems.add(new ur(amq.bt));
        this.builderItems.add(new ur(amq.bc));
        this.builderItems.add(new ur(amq.by));
        this.builderItems.add(new ur(amq.bs));
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addRecipe(new ur(ForestryItem.apiaristBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), amq.ae, Character.valueOf('X'), up.K, Character.valueOf('V'), "stickWood", Character.valueOf('Y'), new ur(ForestryBlock.mill, 1, 3)});
        Proxies.common.addRecipe(new ur(ForestryItem.minerBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), amq.ae, Character.valueOf('X'), up.K, Character.valueOf('V'), up.o, Character.valueOf('Y'), amq.ax});
        Proxies.common.addRecipe(new ur(ForestryItem.diggerBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), amq.ae, Character.valueOf('X'), up.K, Character.valueOf('V'), amq.w, Character.valueOf('Y'), amq.ax});
        Proxies.common.addRecipe(new ur(ForestryItem.foresterBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), amq.ae, Character.valueOf('X'), up.K, Character.valueOf('V'), "logWood", Character.valueOf('Y'), amq.ax});
        Proxies.common.addRecipe(new ur(ForestryItem.hunterBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), amq.ae, Character.valueOf('X'), up.K, Character.valueOf('V'), up.L, Character.valueOf('Y'), amq.ax});
        Proxies.common.addRecipe(new ur(ForestryItem.adventurerBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), amq.ae, Character.valueOf('X'), up.K, Character.valueOf('V'), up.aX, Character.valueOf('Y'), amq.ax});
        Proxies.common.addRecipe(new ur(ForestryItem.builderBackpack), new Object[]{"X#X", "VYV", "X#X", Character.valueOf('#'), amq.ae, Character.valueOf('X'), up.K, Character.valueOf('V'), up.aI, Character.valueOf('Y'), amq.ax});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.minerBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), up.n, Character.valueOf('W'), new ur(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.minerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.diggerBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), up.n, Character.valueOf('W'), new ur(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.diggerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.foresterBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), up.n, Character.valueOf('W'), new ur(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.foresterBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.hunterBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), up.n, Character.valueOf('W'), new ur(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.hunterBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.adventurerBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), up.n, Character.valueOf('W'), new ur(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.adventurerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, new LiquidStack(amq.E.cm, 1000), null, new ur(ForestryItem.builderBackpackT2), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), up.n, Character.valueOf('W'), new ur(ForestryItem.craftingMaterial, 1, 3), Character.valueOf('T'), ForestryItem.builderBackpack});
    }

    private void createBackpackArrays() {
        if (BackpackManager.backpackItems != null) {
            return;
        }
        BackpackManager.backpackItems = new ArrayList[6];
        this.minerItems = new ArrayList();
        BackpackManager.backpackItems[0] = this.minerItems;
        this.diggerItems = new ArrayList();
        BackpackManager.backpackItems[1] = this.diggerItems;
        this.foresterItems = new ArrayList();
        BackpackManager.backpackItems[2] = this.foresterItems;
        this.hunterItems = new ArrayList();
        BackpackManager.backpackItems[3] = this.hunterItems;
        this.adventurerItems = new ArrayList();
        BackpackManager.backpackItems[4] = this.adventurerItems;
        this.builderItems = new ArrayList();
        BackpackManager.backpackItems[5] = this.builderItems;
    }

    @Override
    protected void registerCrates() {
    }

    private static void parseBackpackItems(String backpackIdent, String list, ArrayList target) {
        String[] items;
        for (String item : items = list.split("[;]+")) {
            if (item.isEmpty()) continue;
            String[] ident = item.split("[:]+");
            int id = 0;
            int meta = 0;
            if (ident.length > 1) {
                id = Integer.parseInt(ident[0].trim());
                meta = Integer.parseInt(ident[1].trim());
            } else {
                id = Integer.parseInt(ident[0].trim());
            }
            if (id <= 0) continue;
            if (id < amq.p.length && amq.p[id] != null || up.e[id] != null) {
                FMLCommonHandler.instance().getFMLLogger().finer("Adding block/item of (" + id + ":" + meta + ") to " + backpackIdent);
                target.add(new ur(id, 1, meta));
                continue;
            }
            FMLCommonHandler.instance().getFMLLogger().warning("Failed to add block/item of (" + id + ":" + meta + ") to " + backpackIdent + " since it was null.");
        }
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return this;
    }

    @Override
    public void onOreRegistration(String name, ur ore) {
        this.createBackpackArrays();
        if (name.startsWith("ingot")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("ore")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("gem")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("dust")) {
            this.minerItems.add(ore);
        } else if (name.matches("dropUranium")) {
            this.minerItems.add(ore);
        } else if (name.equals("treeLeaves") || name.equals("treeSapling") || name.equals("logWood")) {
            this.foresterItems.add(ore);
        } else if (name.equals("stairWood") || name.equals("plankWood") || name.equals("slabWood")) {
            this.builderItems.add(ore);
        } else if (name.startsWith("wood")) {
            this.foresterItems.add(ore);
        }
    }
}

