/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.GlobalManager;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.IPacketHandler;
import forestry.api.core.IPickupHandler;
import forestry.api.core.IPlugin;
import forestry.api.core.IResupplyHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.api.core.PluginInfo;
import forestry.api.cultivation.CropProviders;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.core.GameMode;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.RecipeUtil;
import forestry.plugins.CropProviderRubber;
import ic2.api.Ic2Recipes;
import ic2.api.Items;
import java.util.Random;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

@PluginInfo(pluginID="IC2", name="IndustrialCraft2", author="SirSengir", url="http://forestry.sengir.net/", description="Compatibility plugin for IC2.")
public class PluginIC2
implements IPlugin {
    public static PluginIC2 instance;
    public static Configuration config;
    public static boolean ignore;
    public static ur plantBall;
    public static ur compressedPlantBall;
    public static ur wrench;
    public static ur treetap;
    public static ur resin;
    public static ur rubbersapling;
    public static ur rubberwood;
    public static ur rubberleaves;
    public static ur fuelcanFilled;
    public static ur fuelcanEmpty;
    public static ur emptyCell;
    public static ur lavaCell;
    public static ur waterCell;
    public static ur rubber;
    public static ur scrap;
    public static ur uum;
    public static int fuelcanMeta;

    public PluginIC2() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded("IC2");
    }

    @Override
    public void doInit() {
        config = Config.config;
        this.initLiquidContainers();
        this.initRubberChain();
        this.initFermentation();
        this.initCrates();
        ur personalSafe = Items.getItem("personalSafe");
        if (personalSafe != null) {
            GlobalManager.holyBlockIds.add(personalSafe.c);
        }
        ur reinforcedStone = Items.getItem("reinforcedStone");
        GlobalManager.holyBlockIds.add(reinforcedStone.c);
        ur reinforcedGlass = Items.getItem("reinforcedGlass");
        GlobalManager.holyBlockIds.add(reinforcedGlass.c);
        ur reinforcedDoorBlock = Items.getItem("reinforcedDoorBlock");
        GlobalManager.holyBlockIds.add(reinforcedDoorBlock.c);
        ur copperCableBlock = Items.getItem("copperCableBlock");
        GlobalManager.holyBlockIds.add(copperCableBlock.c);
        Ic2Recipes.addRecyclerBlacklistItem(ForestryItem.beeQueenGE);
        Ic2Recipes.addRecyclerBlacklistItem(ForestryItem.beePrincessGE);
        this.registerBackpackItems();
    }

    private void initFermentation() {
        plantBall = Items.getItem("plantBall");
        compressedPlantBall = Items.getItem("compressedPlantBall");
        if (plantBall == null || compressedPlantBall == null) {
            FMLLog.fine((String)"No IC2 plantballs found.", (Object[])new Object[0]);
            return;
        }
        RecipeUtil.injectLeveledRecipe(plantBall, GameMode.getGameMode().getFermentedPerWheat() * 4, new ur(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(compressedPlantBall, GameMode.getGameMode().getFermentedPerWheat() * 5, new ur(ForestryItem.liquidBiomass));
    }

    private void initLiquidContainers() {
        emptyCell = Items.getItem("cell");
        lavaCell = Items.getItem("lavaCell");
        waterCell = Items.getItem("waterCell");
        if (emptyCell == null || lavaCell == null || waterCell == null) {
            FMLLog.fine((String)"Any of the following IC2 items could not be found: empty cell, water cell, lava cell. Skipped adding IC2 liquid containers.", (Object[])new Object[0]);
            return;
        }
        LiquidHelper.injectTinContainer(new LiquidContainerData(new LiquidStack(amq.G, 1000), lavaCell, emptyCell));
        LiquidHelper.injectTinContainer(new LiquidContainerData(new LiquidStack(amq.E, 1000), waterCell, emptyCell));
        Proxies.common.addRecipe(new ur(ForestryBlock.soil, 8, 1), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), amq.y, Character.valueOf('X'), waterCell, Character.valueOf('Y'), amq.H});
        RecipeManagers.bottlerManager.addRecipe(5, new LiquidStack(amq.E, 1000), emptyCell, waterCell);
        RecipeManagers.bottlerManager.addRecipe(5, new LiquidStack(amq.G, 1000), emptyCell, lavaCell);
    }

    private void initRubberChain() {
        treetap = Items.getItem("treetap");
        resin = Items.getItem("resin");
        rubberwood = Items.getItem("rubberWood");
        rubbersapling = Items.getItem("rubberSapling");
        rubberleaves = Items.getItem("rubberLeaves");
        fuelcanFilled = Items.getItem("filledFuelCan");
        fuelcanEmpty = Items.getItem("fuelCan");
        if (treetap == null || resin == null || rubberwood == null || rubbersapling == null || rubberleaves == null || fuelcanFilled == null || fuelcanEmpty == null) {
            FMLLog.fine((String)"Any of the following IC2 blocks and items could not be found: resin, rubber wood, saplings or leaves, filled fuel cans, empty fuel cans. Skipped adding rubber chain.", (Object[])new Object[0]);
            return;
        }
        CropProviders.arborealCrops.add(new CropProviderRubber());
        RecipeManagers.centrifugeManager.addRecipe(20, new ur(ForestryItem.propolis), resin);
        ur fuelcanStack = new ur(PluginIC2.fuelcanFilled.c, 1, 0);
        bq compound = new bq();
        compound.a("value", 15288);
        fuelcanStack.d(compound);
        RecipeManagers.bottlerManager.addRecipe(20, new LiquidStack(ForestryItem.liquidBiofuel, 2000), fuelcanEmpty, fuelcanStack);
        RecipeUtil.injectLeveledRecipe(rubbersapling, GameMode.getGameMode().getFermentedPerSapling(), new ur(ForestryItem.liquidBiomass));
        BackpackManager.backpackItems[2].add(rubbersapling);
        BackpackManager.backpackItems[2].add(rubberleaves);
    }

    private void initCrates() {
        resin = Items.getItem("resin");
        rubber = Items.getItem("rubber");
        scrap = Items.getItem("scrap");
        uum = Items.getItem("matter");
        if (resin == null || rubber == null || scrap == null || uum == null) {
            FMLLog.fine((String)"Any of the following IC2 blocks and items could not be found: resin, rubber, scrap or uu matter. Skipped adding crates.", (Object[])new Object[0]);
            return;
        }
        ForestryItem.cratedResin.setContained(new ur((up)ForestryItem.cratedResin), resin);
        ForestryItem.cratedRubber.setContained(new ur((up)ForestryItem.cratedRubber), rubber);
        ForestryItem.cratedScrap.setContained(new ur((up)ForestryItem.cratedScrap), scrap);
        ForestryItem.cratedUUM.setContained(new ur((up)ForestryItem.cratedUUM), uum);
    }

    private void registerBackpackItems() {
        if (BackpackManager.backpackItems == null) {
            return;
        }
        if (resin != null) {
            BackpackManager.backpackItems[EnumBackpackType.FORESTER.ordinal()].add(resin);
        }
        if (rubber != null) {
            BackpackManager.backpackItems[EnumBackpackType.FORESTER.ordinal()].add(rubber);
        }
    }

    @Override
    public String getDescription() {
        return "IndustrialCraft2";
    }

    @Override
    public void preInit() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public void generateSurface(yc world, Random rand, int chunkX, int chunkZ) {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return null;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return null;
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return null;
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public y[] getConsoleCommands() {
        return null;
    }
}

