/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.IOreDictionaryHandler;
import forestry.api.core.IPacketHandler;
import forestry.api.core.IPickupHandler;
import forestry.api.core.IPlugin;
import forestry.api.core.IResupplyHandler;
import forestry.api.core.ISaveEventHandler;
import forestry.core.ForestryCore;
import forestry.core.proxy.Proxies;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PluginManager {
    public static ArrayList plugins = new ArrayList();
    public static ArrayList guiHandlers = new ArrayList();
    public static ArrayList packetHandlers = new ArrayList();
    public static ArrayList pickupHandlers = new ArrayList();
    public static ArrayList saveEventHandlers = new ArrayList();
    public static ArrayList resupplyHandlers = new ArrayList();
    public static ArrayList dictionaryHandlers = new ArrayList();

    public static void loadPlugins(File modLocation) {
        PluginManager.loadIncludedPlugins(modLocation);
        PluginManager.loadExternalPlugins(modLocation);
    }

    private static String getPluginPackageName() {
        Package pack = PluginManager.class.getPackage();
        if (pack != null) {
            return pack.getName();
        }
        return "forestry.plugins";
    }

    private static String getPluginPackagePath() {
        return PluginManager.getPluginPackageName().replace('.', File.separatorChar);
    }

    private static void loadIncludedPlugins(File modLocation) {
        block7: {
            File[] fileList;
            ClassLoader classLoader = ForestryCore.class.getClassLoader();
            if (modLocation.isFile() && (modLocation.getName().endsWith(".jar") || modLocation.getName().endsWith(".zip"))) {
                try {
                    ZipEntry entry = null;
                    FileInputStream fileIO = new FileInputStream(modLocation);
                    ZipInputStream zipIO = new ZipInputStream(fileIO);
                    while (true) {
                        if ((entry = zipIO.getNextEntry()) == null) {
                            fileIO.close();
                            break block7;
                        }
                        String entryName = entry.getName();
                        File entryFile = new File(entryName);
                        String pluginName = entryFile.getName();
                        if (entry.isDirectory() || !pluginName.startsWith("Plugin") || !pluginName.endsWith(".class")) continue;
                        PluginManager.addPlugin(classLoader, pluginName);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (modLocation.isDirectory() && (fileList = (modLocation = new File(modLocation, PluginManager.getPluginPackagePath())).listFiles()) != null) {
                for (int i = 0; i < fileList.length; ++i) {
                    String pluginName = fileList[i].getName();
                    if (!fileList[i].isFile() || !pluginName.startsWith("Plugin") || !pluginName.endsWith(".class")) continue;
                    PluginManager.addPlugin(classLoader, pluginName);
                }
            }
        }
    }

    private static void loadExternalPlugins(File modLocation) {
        try {
            File pluginDir = new File(Proxies.common.getForestryRoot() + "/mods");
            ClassLoader classLoader = ForestryCore.class.getClassLoader();
            if (!pluginDir.isDirectory()) {
                return;
            }
            File[] fileList = pluginDir.listFiles();
            if (fileList == null) {
                return;
            }
            block2: for (File file : fileList) {
                if (!file.isFile() || !file.getName().endsWith(".jar") && !file.getName().endsWith(".zip") || file.getName().equals(modLocation.getName())) continue;
                ZipEntry entry = null;
                FileInputStream fileIO = new FileInputStream(file);
                ZipInputStream zipIO = new ZipInputStream(fileIO);
                while (true) {
                    if ((entry = zipIO.getNextEntry()) == null) {
                        fileIO.close();
                        continue block2;
                    }
                    String entryName = entry.getName();
                    File entryFile = new File(entryName);
                    if (!entryFile.getPath().startsWith("forestry" + File.separatorChar + "plugins")) continue;
                    String pluginName = entryFile.getName();
                    if (entry.isDirectory() || !pluginName.startsWith("Plugin") || !pluginName.endsWith(".class")) continue;
                    PluginManager.addPlugin(classLoader, pluginName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addPlugin(ClassLoader classLoader, String pluginName) {
        if (pluginName.equals("PluginManager.class") || pluginName.equals("PluginInfo.class")) {
            return;
        }
        String pluginClassName = pluginName.split("\\.")[0];
        pluginClassName = PluginManager.getPluginPackageName() + "." + pluginClassName;
        try {
            Class<?> pluginClass = classLoader.loadClass(pluginClassName);
            if (pluginClass != null) {
                Object obj = pluginClass.newInstance();
                if (!(obj instanceof IPlugin)) {
                    return;
                }
                IPlugin plugin = (IPlugin)obj;
                if (plugin != null) {
                    IOreDictionaryHandler dictionaryHandler;
                    IResupplyHandler resupplyHandler;
                    ISaveEventHandler saveHandler;
                    IPickupHandler pickupHandler;
                    IPacketHandler packetHandler;
                    FMLLog.fine((String)("Found plugin for " + plugin.getDescription()), (Object[])new Object[0]);
                    plugins.add(plugin);
                    IGuiHandler guiHandler = plugin.getGuiHandler();
                    if (guiHandler != null) {
                        guiHandlers.add(guiHandler);
                    }
                    if ((packetHandler = plugin.getPacketHandler()) != null) {
                        packetHandlers.add(packetHandler);
                    }
                    if ((pickupHandler = plugin.getPickupHandler()) != null) {
                        pickupHandlers.add(pickupHandler);
                    }
                    if ((saveHandler = plugin.getSaveEventHandler()) != null) {
                        saveEventHandlers.add(saveHandler);
                    }
                    if ((resupplyHandler = plugin.getResupplyHandler()) != null) {
                        resupplyHandlers.add(resupplyHandler);
                    }
                    if ((dictionaryHandler = plugin.getDictionaryHandler()) != null) {
                        dictionaryHandlers.add(dictionaryHandler);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

