/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import forestry.api.core.ForestryAPI;
import forestry.apiculture.gadgets.MachineApiaristChest;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileMachine;
import forestry.core.interfaces.IInventoriedItem;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Utils;
import forestry.storage.BackpackMode;
import java.util.ArrayList;
import java.util.List;

public abstract class ItemBackpack
extends ItemForestry
implements IInventoriedItem {
    BackpackInfo info;

    public ItemBackpack(int i, BackpackInfo info) {
        super(i);
        this.info = info;
        this.ck = 1;
    }

    public boolean q() {
        return true;
    }

    public ur a(ur itemstack, yc world, qx entityplayer) {
        if (!Proxies.common.isSimulating(world)) {
            return itemstack;
        }
        if (entityplayer.ah()) {
            BackpackMode mode = this.getMode(itemstack);
            if (mode == BackpackMode.RESUPPLY) {
                itemstack.b(0);
            } else if (mode == BackpackMode.RECEIVE) {
                itemstack.b(3);
            } else if (mode == BackpackMode.LOCKED) {
                itemstack.b(2);
            } else {
                itemstack.b(1);
            }
        } else {
            this.openGui(entityplayer, itemstack);
        }
        return itemstack;
    }

    protected aoh getPlayerTarget(yc world, qx entityplayer, boolean flag) {
        float f = 1.0f;
        float f1 = entityplayer.C + (entityplayer.A - entityplayer.C) * f;
        float f2 = entityplayer.B + (entityplayer.z - entityplayer.B) * f;
        double d = entityplayer.q + (entityplayer.t - entityplayer.q) * (double)f;
        double d1 = entityplayer.r + (entityplayer.u - entityplayer.r) * (double)f + 1.62 - (double)entityplayer.M;
        double d2 = entityplayer.s + (entityplayer.v - entityplayer.s) * (double)f;
        aoj vec3d = aoj.a.a(d, d1, d2);
        float f3 = ke.b((float)(-f2 * 0.01745329f - 3.141593f));
        float f4 = ke.a((float)(-f2 * 0.01745329f - 3.141593f));
        float f5 = -ke.b((float)(-f1 * 0.01745329f));
        float f6 = ke.a((float)(-f1 * 0.01745329f));
        float f7 = f4 * f5;
        float f8 = f6;
        float f9 = f3 * f5;
        double d3 = Proxies.common.getBlockReachDistance(entityplayer);
        aoj vec3d1 = vec3d.c((double)f7 * d3, (double)f8 * d3, (double)f9 * d3);
        aoh movingobjectposition = world.a(vec3d, vec3d1, flag, !flag);
        return movingobjectposition;
    }

    public boolean onItemUseFirst(ur stack, qx player, yc world, int X, int Y, int Z, int side, float hitX, float hitY, float hitZ) {
        if (!Proxies.common.isSimulating(world)) {
            return false;
        }
        if (!player.ah()) {
            return false;
        }
        aoh movingobjectposition = this.getPlayerTarget(world, player, false);
        if (movingobjectposition != null && movingobjectposition.a == aoi.a) {
            la test;
            int i = movingobjectposition.b;
            int j = movingobjectposition.c;
            int k = movingobjectposition.d;
            any targeted = world.q(i, j, k);
            la inventory = null;
            if (targeted instanceof anm) {
                inventory = Utils.getChest((la)targeted);
            } else if (targeted instanceof TileMachine) {
                TileMachine machine = (TileMachine)targeted;
                if (machine.machine instanceof MachineApiaristChest && ((ItemBackpack)ForestryItem.apiaristBackpack).isBackpack(stack)) {
                    inventory = (la)targeted;
                }
            } else if (targeted instanceof la && (test = (la)targeted).k_() > 26) {
                inventory = test;
            }
            if (inventory != null) {
                if (inventory.k_() <= 0) {
                    return false;
                }
                ItemInventory backpackInventory = new ItemInventory(this.getBackpackSize(), stack);
                if (stack.j() == 2) {
                    this.tryChestReceive(player, backpackInventory, inventory);
                } else {
                    this.tryChestTransfer(backpackInventory, inventory);
                }
                backpackInventory.save();
                return true;
            }
        }
        return false;
    }

    private void tryChestTransfer(ItemInventory backpackInventory, la inventory) {
        block0: for (int l = 0; l < backpackInventory.k_(); ++l) {
            ur packstack = backpackInventory.a(l);
            if (packstack == null) continue;
            for (int m = 0; m < inventory.k_(); ++m) {
                int space;
                ur targetstack = inventory.a(m);
                if (targetstack == null) {
                    inventory.a(m, packstack.l());
                    backpackInventory.a(l, null);
                    continue block0;
                }
                if (!targetstack.a(packstack) || !ur.a((ur)targetstack, (ur)packstack) || (space = targetstack.d() - targetstack.a) <= 0) continue;
                if (space >= packstack.a) {
                    targetstack.a += packstack.a;
                    backpackInventory.a(l, packstack.a);
                    continue block0;
                }
                targetstack.a = targetstack.d();
                backpackInventory.a(l, space);
            }
        }
    }

    private void tryChestReceive(qx player, ItemInventory backpackInventory, la inventory) {
        block0: for (int i = 0; i < inventory.k_(); ++i) {
            ur inventoryStack = inventory.a(i);
            if (inventoryStack == null || !this.isValidItem(player, inventoryStack)) continue;
            for (int j = 0; j < backpackInventory.k_(); ++j) {
                int space;
                ur backpackStack = backpackInventory.a(j);
                if (backpackStack == null) {
                    backpackInventory.a(j, inventoryStack.l());
                    inventory.a(i, null);
                    continue block0;
                }
                if (!backpackStack.a(inventoryStack) || !ur.a((ur)inventoryStack, (ur)backpackStack) || (space = backpackStack.d() - backpackStack.a) <= 0) continue;
                if (space >= inventoryStack.a) {
                    backpackStack.a += inventoryStack.a;
                    inventory.a(i, inventoryStack.a);
                    continue block0;
                }
                backpackStack.a = backpackStack.d();
                inventory.a(i, space);
            }
        }
    }

    public void openGui(qx entityplayer, ur itemstack) {
        if (this.getBackpackSize() == 15) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.BackpackGUI.ordinal(), entityplayer.p, (int)entityplayer.t, (int)entityplayer.u, (int)entityplayer.v);
        } else if (this.getBackpackSize() == 45) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.BackpackT2GUI.ordinal(), entityplayer.p, (int)entityplayer.t, (int)entityplayer.u, (int)entityplayer.v);
        }
    }

    public abstract boolean isBackpack(ur var1);

    public abstract ArrayList getValidItems(qx var1);

    public boolean isValidItem(qx player, ur itemstack) {
        for (ur stack : this.getValidItems(player)) {
            if (!(stack.j() < 0 ? stack.c == itemstack.c : stack.a(itemstack))) continue;
            return true;
        }
        return false;
    }

    public int getBackpackSize() {
        return this.info.slots;
    }

    public BackpackMode getMode(ur backpack) {
        int meta = backpack.j();
        if (meta >= 3) {
            return BackpackMode.RESUPPLY;
        }
        if (meta >= 2) {
            return BackpackMode.RECEIVE;
        }
        if (meta >= 1) {
            return BackpackMode.LOCKED;
        }
        return BackpackMode.NORMAL;
    }

    public void a(ur itemstack, qx player, List list, boolean flag) {
        ItemInventory inventory = new ItemInventory(this.getBackpackSize(), itemstack);
        int occupied = 0;
        for (int i = 0; i < inventory.k_(); ++i) {
            if (inventory.a(i) == null || inventory.a((int)i).a <= 0) continue;
            ++occupied;
        }
        BackpackMode mode = this.getMode(itemstack);
        if (mode == BackpackMode.LOCKED) {
            list.add("(LOCKED)");
        } else if (mode == BackpackMode.RECEIVE) {
            list.add("(RECEIVING)");
        } else if (mode == BackpackMode.RESUPPLY) {
            list.add("(RESUPPLY)");
        }
        list.add(occupied + "/" + this.getBackpackSize() + " " + StringUtil.localize("gui.slots"));
    }

    public ur[] getBackpacksInInventory(qx player) {
        ArrayList<ur> bags = new ArrayList<ur>();
        for (ur stack : player.bJ.a) {
            if (!this.isBackpack(stack)) continue;
            bags.add(stack);
        }
        return bags.toArray(new ur[0]);
    }

    public ur tryStowing(ur backpack, ur itemstack) {
        ItemInventory inventory = new ItemInventory(((ItemBackpack)backpack.b()).getBackpackSize(), backpack);
        if (backpack.j() == 1) {
            return itemstack;
        }
        int freeSlots = 0;
        int slot = -1;
        for (int i = 0; i < inventory.k_(); ++i) {
            int space;
            ur slotStack = inventory.a(i);
            if (slotStack == null) {
                ++freeSlots;
                if (slot >= 0) continue;
                slot = i;
                continue;
            }
            if (!slotStack.a(itemstack) || !ur.a((ur)slotStack, (ur)itemstack) || (space = slotStack.d() - slotStack.a) <= 0) continue;
            if (space < itemstack.a) {
                slotStack.a = slotStack.d();
                itemstack.a -= space;
                continue;
            }
            slotStack.a += itemstack.a;
            itemstack.a = 0;
            inventory.save();
            return null;
        }
        if (freeSlots <= 0) {
            inventory.save();
            return itemstack;
        }
        inventory.a(slot, itemstack.l());
        itemstack.a = 0;
        inventory.save();
        return null;
    }

    public boolean b() {
        return true;
    }

    @Override
    public String l(ur itemstack) {
        if (this.info.iconType > 1) {
            return StringUtil.localize("storage.backpack.t2adj") + " " + StringUtil.localize("storage.backpack." + this.info.name);
        }
        return StringUtil.localize("storage.backpack." + this.info.name);
    }

    public int a(ur itemstack, int j) {
        if (j == 0) {
            return this.info.primaryColor;
        }
        return this.info.secondaryColor;
    }

    public int a(int i, int j) {
        int iconIndex = 0;
        iconIndex = j == 0 ? 112 : 113 + this.info.iconType;
        if (i > 2) {
            return iconIndex + 48;
        }
        if (i > 1) {
            return iconIndex + 32;
        }
        if (i > 0) {
            return iconIndex + 16;
        }
        return iconIndex;
    }

    public static int getSlotsForType(int type) {
        switch (type) {
            case 0: {
                return 125;
            }
            case 2: {
                return 45;
            }
        }
        return 15;
    }

    public static class BackpackInfo {
        public final String name;
        public final int slots;
        public final int iconType;
        public final int primaryColor;
        public final int secondaryColor;

        public BackpackInfo(String name, int slots, int iconType, int primaryColor) {
            this(name, slots, iconType, primaryColor, 0xFFFFFF);
        }

        public BackpackInfo(String name, int slots, int iconType, int primaryColor, int secondaryColor) {
            this.name = name;
            this.slots = slots;
            this.iconType = iconType;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }
    }
}

