/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.CommonUtils;
import codechicken.core.IStringMatcher;
import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.relauncher.RelaunchLibraryManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ClassDiscoverer {
    public IStringMatcher matcher;
    public Class[] superclasses;
    public ArrayList classes;
    public ModClassLoader modClassLoader;

    public ClassDiscoverer(IStringMatcher matcher, Class ... superclasses) {
        this.matcher = matcher;
        this.superclasses = superclasses;
        this.classes = new ArrayList();
        this.modClassLoader = (ModClassLoader)Loader.instance().getModClassLoader();
    }

    public ArrayList findClasses() {
        try {
            this.findClasspathMods();
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Code Chicken Core", true);
        }
        return this.classes;
    }

    private void addClass(String resource) {
        try {
            String classname = resource.replace(".class", "").replace("\\", ".").replace("/", ".");
            Class<?> class1 = Class.forName(classname, true, (ClassLoader)this.modClassLoader);
            Class[] classArray = this.superclasses;
            int n = this.superclasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class superclass = classArray[n2];
                if (!superclass.isAssignableFrom(class1)) {
                    return;
                }
                ++n2;
            }
            this.classes.add(class1);
        }
        catch (Exception cnfe) {
            System.err.println("Unable to load class: " + resource);
            cnfe.printStackTrace();
        }
    }

    private void findClasspathMods() throws FileNotFoundException, IOException {
        ImmutableList knownLibraries = ImmutableList.builder().addAll((Iterable)this.modClassLoader.getDefaultLibraries()).addAll((Iterable)RelaunchLibraryManager.getLibraries()).build();
        File[] minecraftSources = this.modClassLoader.getParentSources();
        HashSet<String> searchedSources = new HashSet<String>();
        File[] fileArray = minecraftSources;
        int n = minecraftSources.length;
        int n2 = 0;
        while (n2 < n) {
            File minecraftSource = fileArray[n2];
            if (!searchedSources.contains(minecraftSource.getAbsolutePath())) {
                searchedSources.add(minecraftSource.getAbsolutePath());
                if (minecraftSource.isFile()) {
                    if (!knownLibraries.contains(minecraftSource.getName())) {
                        FMLLog.fine((String)"Found a minecraft related file at %s, examining for codechicken classes", (Object[])new Object[]{minecraftSource.getAbsolutePath()});
                        this.readFromZipFile(minecraftSource);
                    }
                } else if (minecraftSource.isDirectory()) {
                    FMLLog.fine((String)"Found a minecraft related directory at %s, examining for codechicken classes", (Object[])new Object[]{minecraftSource.getAbsolutePath()});
                    this.readFromDirectory(minecraftSource, minecraftSource);
                }
            }
            ++n2;
        }
    }

    private void readFromZipFile(File file) throws IOException {
        ZipEntry zipentry;
        FileInputStream fileinputstream = new FileInputStream(file);
        ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
        while ((zipentry = zipinputstream.getNextEntry()) != null) {
            String name;
            String fullname = zipentry.getName().replace('\\', '/');
            int pos = fullname.lastIndexOf(47);
            String string = name = pos == -1 ? fullname : fullname.substring(pos + 1);
            if (zipentry.isDirectory() || !this.matcher.matches(name)) continue;
            this.addClass(fullname);
        }
        fileinputstream.close();
    }

    private void readFromDirectory(File directory, File basedirectory) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                this.readFromDirectory(child, basedirectory);
            } else if (child.isFile() && this.matcher.matches(child.getName())) {
                String fullname = CommonUtils.getRelativePath(basedirectory, child);
                this.addClass(fullname);
            }
            ++n2;
        }
    }
}

