/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class ColourRGBA {
    public int r;
    public int g;
    public int b;
    public int a;

    public ColourRGBA(int colour) {
        this(colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
    }

    public ColourRGBA(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public ColourRGBA(double r, double g, double b, double a) {
        this((int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b), (int)(255.0 * a));
    }

    public ColourRGBA(ColourRGBA colour) {
        this.r = colour.r;
        this.g = colour.g;
        this.b = colour.b;
        this.a = colour.a;
    }

    @SideOnly(value=Side.CLIENT)
    public void glColour() {
        GL11.glColor4ub((byte)((byte)this.r), (byte)((byte)this.g), (byte)((byte)this.b), (byte)((byte)this.a));
    }

    public void glColour(byte alpha) {
        GL11.glColor4ub((byte)((byte)this.r), (byte)((byte)this.g), (byte)((byte)this.b), (byte)alpha);
    }

    public int getRGBA() {
        return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.a;
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.getRGBA()).toUpperCase();
    }

    public ColourRGBA multiply(ColourRGBA colour) {
        return new ColourRGBA(Math.min(this.r * colour.r / 255, 255), Math.min(this.g * colour.g / 255, 255), Math.min(this.b * colour.b / 255, 255), Math.min(this.a * colour.a / 255, 255));
    }

    public ColourRGBA multiply(double d) {
        return this.multiply(new ColourRGBA(d, d, d, 1.0));
    }

    public ColourRGBA interpolate(ColourRGBA end, double d) {
        return new ColourRGBA((int)((double)this.r + (double)(end.r - this.r) * d), (int)((double)this.g + (double)(end.g - this.g) * d), (int)((double)this.b + (double)(end.b - this.b) * d), (int)((double)this.a + (double)(end.a - this.a) * d));
    }
}

