/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.ConfigTag;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class ConfigFile {
    public File file;
    public TreeMap maintags;
    public String comment;
    public int newlinemode = 2;
    public int sortMode = 0;
    public static boolean loading;
    public static final byte[] lineend;

    static {
        lineend = new byte[]{13, 10};
    }

    public ConfigFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                FMLCommonHandler.instance().raiseException((Throwable)e, "Code Chicken Core", true);
            }
        }
        this.file = file;
        this.maintags = new TreeMap();
        this.loadConfig();
    }

    private void loadConfig() {
        BufferedReader reader;
        loading = true;
        try {
            reader = new BufferedReader(new FileReader(this.file));
        }
        catch (FileNotFoundException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Code Chicken Core", true);
            return;
        }
        String comment = "";
        String bracequalifier = "";
        boolean readingheader = true;
        try {
            while (true) {
                boolean headerline = false;
                String line = ConfigFile.readLine(reader);
                if (line == null) break;
                if (line.startsWith("#")) {
                    if (readingheader) {
                        this.comment = comment == null || comment.equals("") ? line.substring(1) : String.valueOf(this.comment) + ":" + line.substring(1);
                        headerline = true;
                    } else {
                        comment = comment == null || comment.equals("") ? line.substring(1) : String.valueOf(comment) + ":" + line.substring(1);
                    }
                } else if (line.contains("=")) {
                    String qualifiedname = line.substring(0, line.indexOf("="));
                    this.getTag(qualifiedname).setComment(comment).setValue(line.substring(line.indexOf("=") + 1));
                    comment = "";
                    bracequalifier = qualifiedname;
                } else if (line.equals("{")) {
                    this.getTag(bracequalifier).setComment(comment).useBraces().loadChildren(reader);
                    comment = "";
                    bracequalifier = "";
                } else if (line.equals("")) {
                    comment = "";
                    bracequalifier = "";
                } else {
                    bracequalifier = line;
                }
                if (headerline) continue;
                readingheader = false;
            }
            reader.close();
        }
        catch (IOException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Code Chicken Core", true);
        }
        loading = false;
    }

    public static String readLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            return line.replace("\t", "");
        }
        return line;
    }

    public static String formatLine(String line) {
        if ((line = line.replace("\t", "")).startsWith("#")) {
            return line;
        }
        if (line.contains("=")) {
            line = String.valueOf(line.substring(0, line.indexOf("=")).replace(" ", "")) + line.substring(line.indexOf("="));
            return line;
        }
        line = line.replace(" ", "");
        return line;
    }

    public static void writeLine(PrintWriter writer, String line, int tabs) {
        int i = 0;
        while (i < tabs) {
            writer.print('\t');
            ++i;
        }
        writer.println(line);
    }

    public ConfigTag getTag(String tagname, boolean createnew) {
        int dotpos = (tagname = tagname.replace('_', ' ')).indexOf(".");
        String basetagname = dotpos == -1 ? tagname : tagname.substring(0, dotpos);
        ConfigTag basetag = (ConfigTag)this.maintags.get(basetagname);
        if (basetag == null) {
            if (!createnew) {
                return null;
            }
            basetag = this.getNewTag(basetagname);
            this.saveConfig();
        }
        if (dotpos == -1) {
            return basetag;
        }
        return basetag.getTag(tagname.substring(dotpos + 1), createnew);
    }

    public ConfigTag getTag(String tagname) {
        return this.getTag(tagname, true);
    }

    public boolean containsTag(String tagname) {
        return this.getTag(tagname, false) != null;
    }

    public boolean removeTag(String tagname) {
        String lastpart;
        ConfigTag tag = this.getTag(tagname, false);
        if (tag == null) {
            return false;
        }
        int dotpos = tagname.lastIndexOf(".");
        String string = lastpart = dotpos == -1 ? tagname : tagname.substring(dotpos + 1, tagname.length());
        if (tag.parenttag != null) {
            return tag.parenttag.childtags.remove(lastpart) != null;
        }
        if (tag.parentfile != null) {
            return tag.parentfile.maintags.remove(lastpart) != null;
        }
        return false;
    }

    public ConfigTag getNewTag(String tagname) {
        return new ConfigTag(this, tagname);
    }

    public void saveConfig() {
        PrintWriter writer;
        if (loading) {
            return;
        }
        try {
            writer = new PrintWriter(this.file);
        }
        catch (FileNotFoundException e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Code Chicken Core", true);
            return;
        }
        if (this.comment != null && !this.comment.equals("")) {
            String doubledelimcomment = this.comment.replace("::", "~|~");
            String[] comments = doubledelimcomment.split(":");
            int i = 0;
            while (i < comments.length) {
                comments[i] = comments[i].replace("~|~", ":");
                ConfigFile.writeLine(writer, "#" + comments[i], 0);
                ++i;
            }
        }
        ConfigFile.writeLine(writer, "", 0);
        ConfigFile.saveTagTree(writer, this.maintags, 0, "", this.sortMode);
        writer.flush();
        writer.close();
    }

    public ConfigFile setComment(String header) {
        this.comment = header;
        this.saveConfig();
        return this;
    }

    public static void saveTagTree(PrintWriter writer, TreeMap tagtree, int braces, String bracequalifier, int sortMode) {
        ArrayList<ConfigTag> taglist = new ArrayList<ConfigTag>(tagtree.size());
        for (Map.Entry entry : tagtree.entrySet()) {
            taglist.add((ConfigTag)entry.getValue());
        }
        Collections.sort(taglist, new TagOrderComparator(sortMode));
        for (ConfigTag configTag : taglist) {
            configTag.save(writer, braces, bracequalifier);
        }
    }

    public static ArrayList getSortedTagList(TreeMap tagtree, int sortMode) {
        ArrayList<ConfigTag> taglist = new ArrayList<ConfigTag>(tagtree.size());
        for (Map.Entry tag : tagtree.entrySet()) {
            taglist.add((ConfigTag)tag.getValue());
        }
        Collections.sort(taglist, new TagOrderComparator(sortMode));
        return taglist;
    }

    public ConfigFile setNewLineMode(int mode) {
        this.newlinemode = mode;
        for (Map.Entry entry : this.maintags.entrySet()) {
            ConfigTag tag = (ConfigTag)entry.getValue();
            if (this.newlinemode == 0) {
                tag.newline = false;
                continue;
            }
            if (this.newlinemode == 1) {
                tag.newline = tag.brace;
                continue;
            }
            if (this.newlinemode != 2) continue;
            tag.newline = true;
        }
        this.saveConfig();
        return this;
    }

    public ConfigFile setSortMode(int mode) {
        this.sortMode = mode;
        this.saveConfig();
        return this;
    }

    public static class TagOrderComparator
    implements Comparator {
        int sortMode;

        public TagOrderComparator(int sortMode) {
            this.sortMode = sortMode;
        }

        public int compare(ConfigTag o1, ConfigTag o2) {
            if (o1.position == o2.position) {
                if (o1.brace == o2.brace) {
                    switch (this.sortMode) {
                        case 1: {
                            if (o1.value == null) {
                                return o2.value == null ? 0 : 1;
                            }
                            if (o2.value == null) {
                                return -1;
                            }
                            return o1.value.compareTo(o2.value);
                        }
                    }
                    return o1.name.compareTo(o2.name);
                }
                return o1.brace ? 1 : -1;
            }
            return Integer.valueOf(o1.position).compareTo(o2.position);
        }
    }
}

