/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.ObfuscationManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMHelper {
    public static MethodNode findMethod(ObfuscationManager.MethodMapping methodmap, ClassNode cnode) {
        for (MethodNode mnode : cnode.methods) {
            if (!methodmap.matches(mnode)) continue;
            return mnode;
        }
        return null;
    }

    public static ClassNode createClassNode(byte[] bytes) {
        ClassNode cnode = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)cnode, 0);
        return cnode;
    }

    public static byte[] createBytes(ClassNode cnode, int i) {
        ClassWriter cw = new ClassWriter(i);
        cnode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

