/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.inventory;

import codechicken.core.Vector3;
import com.google.common.base.Objects;
import net.minecraftforge.common.ForgeDirection;

public class InventoryUtils {
    public static final ForgeDirection[] chestSides = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH};

    public static ur decrStackSize(la inv, int slot, int size) {
        ur item = inv.a(slot);
        if (item != null) {
            if (item.a <= size) {
                ur itemstack = item;
                inv.a(slot, null);
                inv.d();
                return itemstack;
            }
            ur itemstack1 = item.a(size);
            if (item.a == 0) {
                inv.a(slot, null);
            }
            inv.d();
            return itemstack1;
        }
        return null;
    }

    public static ur getStackInSlotOnClosing(la inv, int slot) {
        ur stack = inv.a(slot);
        inv.a(slot, null);
        return stack;
    }

    public static int incrStackSize(ur base, ur addition) {
        if (InventoryUtils.canStack(base, addition)) {
            return InventoryUtils.incrStackSize(base, addition.a);
        }
        return 0;
    }

    public static int incrStackSize(ur base, int addition) {
        int totalSize = base.a + addition;
        if (totalSize <= base.d()) {
            return addition;
        }
        if (base.a < base.d()) {
            return base.d() - base.a;
        }
        return 0;
    }

    public static by writeItemStacksToTag(ur[] items) {
        by tagList = new by();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                bq tag = new bq();
                tag.a("Slot", (short)i);
                items[i].b(tag);
                tagList.a((cd)tag);
            }
            ++i;
        }
        return tagList;
    }

    public static void readItemStacksFromTag(ur[] items, by tagList) {
        int i = 0;
        while (i < tagList.c()) {
            bq tag = (bq)tagList.b(i);
            items[tag.d((String)"Slot")] = ur.a((bq)tag);
            ++i;
        }
    }

    public static void dropItem(ur stack, yc world, Vector3 dropLocation) {
        px item = new px(world, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.w = world.t.nextGaussian() * 0.05;
        item.x = world.t.nextGaussian() * 0.05 + (double)0.2f;
        item.y = world.t.nextGaussian() * 0.05;
        world.d((lq)item);
    }

    public static ur copyStack(ur stack, int quantity) {
        stack = stack.l();
        stack.a = quantity;
        return stack;
    }

    public static boolean areStacksSameTypeCrafting(ur stack1, ur stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.c == stack2.c && (stack1.j() == stack2.j() || stack1.j() == -1 || stack2.j() == -1 || stack1.b().n());
    }

    public static boolean mergeItemStack(la inv, int fslot, int lslot, ur stack, boolean doMerge) {
        if (doMerge && !InventoryUtils.mergeItemStack(inv, fslot, lslot, stack, false)) {
            return false;
        }
        stack = stack.l();
        int pass = 0;
        while (pass < 2) {
            int slot = fslot;
            while (slot < lslot) {
                block8: {
                    block9: {
                        block7: {
                            ur base = inv.a(slot);
                            if (base == null) break block7;
                            int added = InventoryUtils.incrStackSize(base, stack);
                            if (added == 0) break block8;
                            stack.a -= added;
                            if (doMerge) {
                                base.a += added;
                                inv.a(slot, base);
                            }
                            break block9;
                        }
                        if (pass == 1) {
                            int quantity = Math.min(inv.c(), stack.a);
                            if (doMerge) {
                                inv.a(slot, InventoryUtils.copyStack(stack, quantity));
                            }
                            stack.a -= quantity;
                        }
                    }
                    if (stack.a == 0) {
                        return true;
                    }
                }
                ++slot;
            }
            ++pass;
        }
        return false;
    }

    public static boolean areStacksIdentical(ur stack1, ur stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.c == stack2.c && stack1.j() == stack2.j() && stack1.a == stack2.a && Objects.equal((Object)stack1.p(), (Object)stack2.p());
    }

    public static la getInventory(yc world, int x2, int y2, int z2) {
        any tile = world.q(x2, y2, z2);
        if (!(tile instanceof la)) {
            return null;
        }
        if (tile instanceof anm) {
            return InventoryUtils.getChest((anm)tile);
        }
        return (la)tile;
    }

    public static la getChest(anm chest) {
        ForgeDirection[] forgeDirectionArray = chestSides;
        int n = chestSides.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeDirection fside = forgeDirectionArray[n2];
            if (chest.k.a(chest.l + fside.offsetX, chest.m + fside.offsetY, chest.n + fside.offsetZ) == chest.q().cm) {
                return new kz("container.chestDouble", (la)((anm)chest.k.q(chest.l + fside.offsetX, chest.m + fside.offsetY, chest.n + fside.offsetZ)), (la)chest);
            }
            ++n2;
        }
        return chest;
    }

    public static boolean canStack(ur stack1, ur stack2) {
        return stack1 != null && stack2 != null && stack1.c == stack2.c && (!stack2.g() || stack2.j() == stack1.j()) && ur.a((ur)stack2, (ur)stack1);
    }
}

