/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.render;

import codechicken.core.Vector3;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static Vector3[] vectors = new Vector3[8];

    static {
        int i = 0;
        while (i < vectors.length) {
            RenderUtils.vectors[i] = new Vector3();
            ++i;
        }
    }

    public static int bindLiquidTexture(int liquidID, int liquidMeta) {
        if (liquidID < amq.p.length) {
            amq liquidBlock = amq.p[liquidID];
            ForgeHooksClient.bindTexture((String)liquidBlock.getTextureFile(), (int)0);
            return liquidBlock.a(0, liquidMeta);
        }
        up liquidItem = up.e[liquidID];
        ForgeHooksClient.bindTexture((String)liquidItem.getTextureFile(), (int)0);
        return liquidItem.b(liquidMeta);
    }

    public static void renderLiquidQuad(Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4, int texIndex, double res) {
        double tx1 = (double)(texIndex % 16) / 16.0;
        double ty1 = (double)(texIndex / 16) / 16.0;
        double ty2 = ty1 + 0.0625;
        Vector3 wide = vectors[0].set(point4).subtract(point1);
        Vector3 high = vectors[1].set(point1).subtract(point2);
        double wlen = wide.mag();
        double hlen = high.mag();
        double x2 = 0.0;
        while (x2 < wlen) {
            double rx = wlen - x2;
            if (rx > res) {
                rx = res;
            }
            double y2 = 0.0;
            while (y2 < hlen) {
                double ry = hlen - y2;
                if (ry > res) {
                    ry = res;
                }
                Vector3 dx1 = vectors[2].set(wide).multiply(x2 / wlen);
                Vector3 dx2 = vectors[3].set(wide).multiply((x2 + rx) / wlen);
                Vector3 dy1 = vectors[4].set(high).multiply(y2 / hlen);
                Vector3 dy2 = vectors[5].set(high).multiply((y2 + ry) / hlen);
                baz.a.a(point2.x + dx1.x + dy2.x, point2.y + dx1.y + dy2.y, point2.z + dx1.z + dy2.z, tx1, ty2 - ry / res * 0.0625);
                baz.a.a(point2.x + dx1.x + dy1.x, point2.y + dx1.y + dy1.y, point2.z + dx1.z + dy1.z, tx1, ty2);
                baz.a.a(point2.x + dx2.x + dy1.x, point2.y + dx2.y + dy1.y, point2.z + dx2.z + dy1.z, tx1 + rx / res * 0.0625, ty2);
                baz.a.a(point2.x + dx2.x + dy2.x, point2.y + dx2.y + dy2.y, point2.z + dx2.z + dy2.z, tx1 + rx / res * 0.0625, ty2 - ry / res * 0.0625);
                y2 += ry;
            }
            x2 += rx;
        }
    }

    public static void disableLightMapTexture() {
        bfe.a((int)bfe.b);
        GL11.glDisable((int)3553);
        bfe.a((int)bfe.a);
    }

    public static void enableLightMapTexture() {
        bfe.a((int)bfe.b);
        GL11.glEnable((int)3553);
        bfe.a((int)bfe.a);
    }

    public static void translateToWorldCoords(lq entity, float frame) {
        double interpPosX = entity.T + (entity.t - entity.T) * (double)frame;
        double interpPosY = entity.U + (entity.u - entity.U) * (double)frame;
        double interpPosZ = entity.V + (entity.v - entity.V) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static void drawOutlinedBoundingBox(aoe par1AxisAlignedBB) {
        baz var2 = baz.a;
        var2.b(3);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a();
        var2.b(3);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a();
        var2.b(1);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.c);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.d, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.b, par1AxisAlignedBB.f);
        var2.a(par1AxisAlignedBB.a, par1AxisAlignedBB.e, par1AxisAlignedBB.f);
        var2.a();
    }

    public static void setupBrightness(yc world, int x2, int y2, int z2) {
        int var3 = world.i(x2, y2, z2, 0);
        bfe.a((int)bfe.b, (float)(var3 % 65535), (float)(var3 / 65535));
    }

    public static void renderLiquidCuboid(double[] bound, int texIndex, double res) {
        RenderUtils.renderLiquidQuad(new Vector3(bound[0], bound[2], bound[4]), new Vector3(bound[1], bound[2], bound[4]), new Vector3(bound[1], bound[2], bound[5]), new Vector3(bound[0], bound[2], bound[5]), texIndex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound[0], bound[3], bound[4]), new Vector3(bound[0], bound[3], bound[5]), new Vector3(bound[1], bound[3], bound[5]), new Vector3(bound[1], bound[3], bound[4]), texIndex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound[0], bound[3], bound[4]), new Vector3(bound[0], bound[2], bound[4]), new Vector3(bound[0], bound[2], bound[5]), new Vector3(bound[0], bound[3], bound[5]), texIndex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound[1], bound[3], bound[5]), new Vector3(bound[1], bound[2], bound[5]), new Vector3(bound[1], bound[2], bound[4]), new Vector3(bound[1], bound[3], bound[4]), texIndex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound[1], bound[3], bound[4]), new Vector3(bound[1], bound[2], bound[4]), new Vector3(bound[0], bound[2], bound[4]), new Vector3(bound[0], bound[3], bound[4]), texIndex, res);
        RenderUtils.renderLiquidQuad(new Vector3(bound[0], bound[3], bound[5]), new Vector3(bound[0], bound[2], bound[5]), new Vector3(bound[1], bound[2], bound[5]), new Vector3(bound[1], bound[3], bound[5]), texIndex, res);
    }

    public static void renderBlockOverlaySide(int x2, int y2, int z2, int side, double tx1, double tx2, double ty1, double ty2) {
        double[] points = new double[]{(double)x2 - 0.009, (double)x2 + 1.009, (double)y2 - 0.009, (double)y2 + 1.009, (double)z2 - 0.009, (double)z2 + 1.009};
        baz tessellator = baz.a;
        switch (side) {
            case 0: {
                tessellator.a(points[0], points[2], points[4], tx1, ty1);
                tessellator.a(points[1], points[2], points[4], tx2, ty1);
                tessellator.a(points[1], points[2], points[5], tx2, ty2);
                tessellator.a(points[0], points[2], points[5], tx1, ty2);
                break;
            }
            case 1: {
                tessellator.a(points[1], points[3], points[4], tx2, ty1);
                tessellator.a(points[0], points[3], points[4], tx1, ty1);
                tessellator.a(points[0], points[3], points[5], tx1, ty2);
                tessellator.a(points[1], points[3], points[5], tx2, ty2);
                break;
            }
            case 2: {
                tessellator.a(points[0], points[3], points[4], tx2, ty1);
                tessellator.a(points[1], points[3], points[4], tx1, ty1);
                tessellator.a(points[1], points[2], points[4], tx1, ty2);
                tessellator.a(points[0], points[2], points[4], tx2, ty2);
                break;
            }
            case 3: {
                tessellator.a(points[1], points[3], points[5], tx2, ty1);
                tessellator.a(points[0], points[3], points[5], tx1, ty1);
                tessellator.a(points[0], points[2], points[5], tx1, ty2);
                tessellator.a(points[1], points[2], points[5], tx2, ty2);
                break;
            }
            case 4: {
                tessellator.a(points[0], points[3], points[5], tx2, ty1);
                tessellator.a(points[0], points[3], points[4], tx1, ty1);
                tessellator.a(points[0], points[2], points[4], tx1, ty2);
                tessellator.a(points[0], points[2], points[5], tx2, ty2);
                break;
            }
            case 5: {
                tessellator.a(points[1], points[3], points[4], tx2, ty1);
                tessellator.a(points[1], points[3], points[5], tx1, ty1);
                tessellator.a(points[1], points[2], points[5], tx1, ty2);
                tessellator.a(points[1], points[2], points[4], tx2, ty2);
            }
        }
    }
}

