/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.world;

import codechicken.core.world.ChunkExtension;
import java.util.HashMap;

public abstract class WorldExtension {
    public final yc world;
    public HashMap chunkMap = new HashMap();

    public WorldExtension(yc world) {
        this.world = world;
    }

    public void load() {
    }

    public void unload() {
    }

    public void save() {
    }

    public void preTick() {
    }

    public void postTick() {
    }

    protected final void addChunk(ChunkExtension extension) {
        this.chunkMap.put(extension.chunk, extension);
    }

    protected final void loadChunk(zz chunk) {
        ((ChunkExtension)this.chunkMap.get(chunk)).load();
    }

    protected final void unloadChunk(zz chunk) {
        if (this.world.I && !this.chunkMap.containsKey(chunk)) {
            return;
        }
        ((ChunkExtension)this.chunkMap.get(chunk)).unload();
    }

    protected final void loadChunkData(zz chunk, bq tag) {
        ((ChunkExtension)this.chunkMap.get(chunk)).loadData(tag);
    }

    protected final void saveChunkData(zz chunk, bq tag) {
        ((ChunkExtension)this.chunkMap.get(chunk)).saveData(tag);
    }

    protected final void remChunk(zz chunk) {
        this.chunkMap.remove(chunk);
    }

    protected final void watchChunk(zz chunk, iq player) {
        ((ChunkExtension)this.chunkMap.get(chunk)).watchPlayer(player);
    }

    protected final void unwatchChunk(zz chunk, iq player) {
        ((ChunkExtension)this.chunkMap.get(chunk)).unwatchPlayer(player);
    }

    protected final void sendChunkUpdates(zz chunk) {
        ((ChunkExtension)this.chunkMap.get(chunk)).sendUpdatePackets();
    }
}

