/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.world;

import codechicken.core.PacketCustom;
import codechicken.core.world.WorldExtension;
import codechicken.core.world.WorldExtensionInstantiator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WorldExtensionManager {
    private static final String channel = "CCWEM";
    private static boolean initialised;
    private static ArrayList extensionIntialisers;
    private static HashMap worldMap;

    static {
        extensionIntialisers = new ArrayList();
        worldMap = new HashMap();
    }

    public static void registerWorldExtension(WorldExtensionInstantiator init) {
        if (!initialised) {
            WorldExtensionManager.init();
        }
        init.instantiatorID = extensionIntialisers.size();
        extensionIntialisers.add(init);
    }

    private static void init() {
        initialised = true;
        MinecraftForge.EVENT_BUS.register((Object)new WorldExtensionEventHandler());
        TickRegistry.registerTickHandler((ITickHandler)new WorldExtensionServerTickHandler(), (Side)Side.SERVER);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            TickRegistry.registerTickHandler((ITickHandler)new WorldExtensionClientTickHandler(), (Side)Side.CLIENT);
            PacketCustom.assignHandler(channel, 0, 255, new WorldExtensionManagerPacketHandler());
        }
    }

    private static void onWorldLoad(yc world) {
        WorldExtension[] extensions = new WorldExtension[extensionIntialisers.size()];
        int i = 0;
        while (i < extensions.length) {
            extensions[i] = ((WorldExtensionInstantiator)extensionIntialisers.get(i)).createWorldExtension(world);
            ++i;
        }
        worldMap.put(world, extensions);
        WorldExtension[] worldExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            WorldExtension extension = worldExtensionArray[n2];
            extension.load();
            ++n2;
        }
    }

    private static void createChunkExtension(yc world, zz chunk) {
        WorldExtension[] extensions = (WorldExtension[])worldMap.get(world);
        int i = 0;
        while (i < extensionIntialisers.size()) {
            extensions[i].addChunk(((WorldExtensionInstantiator)extensionIntialisers.get(i)).createChunkExtension(chunk, extensions[i]));
            ++i;
        }
    }

    private static void removeChunk(yc world, zz chunk) {
        WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(world);
        int n = worldExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorldExtension extension = worldExtensionArray[n2];
            extension.remChunk(chunk);
            ++n2;
        }
    }

    private static void preTick(yc world) {
        WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(world);
        int n = worldExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorldExtension extension = worldExtensionArray[n2];
            extension.preTick();
            ++n2;
        }
    }

    private static void postTick(yc world) {
        WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(world);
        int n = worldExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorldExtension extension = worldExtensionArray[n2];
            extension.postTick();
            ++n2;
        }
    }

    public static WorldExtension getWorldExtension(yc world, int instantiatorID) {
        return ((WorldExtension[])worldMap.get(world))[instantiatorID];
    }

    public static class WorldExtensionClientTickHandler
    implements ITickHandler {
        public void tickStart(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.CLIENT)) {
                ayp world = Minecraft.x().e;
                if (worldMap.containsKey(world)) {
                    WorldExtensionManager.preTick((yc)world);
                }
            }
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.CLIENT)) {
                ayp world = Minecraft.x().e;
                if (worldMap.containsKey(world)) {
                    WorldExtensionManager.postTick((yc)world);
                }
            }
        }

        public EnumSet ticks() {
            return EnumSet.of(TickType.CLIENT);
        }

        public String getLabel() {
            return "WorldExtenstions";
        }
    }

    public static class WorldExtensionEventHandler {
        private zz dataLoad;
        private zz dataUnload;

        @ForgeSubscribe
        public void onChunkDataLoad(ChunkDataEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            WorldExtensionManager.createChunkExtension(event.world, event.getChunk());
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.loadChunkData(event.getChunk(), event.getData());
                ++n2;
            }
            this.dataLoad = event.getChunk();
        }

        @ForgeSubscribe
        public void onChunkDataSave(ChunkDataEvent.Save event) {
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.saveChunkData(event.getChunk(), event.getData());
                ++n2;
            }
            if (this.dataUnload == event.getChunk()) {
                WorldExtensionManager.removeChunk(event.world, event.getChunk());
            }
        }

        @ForgeSubscribe
        public void onChunkLoad(ChunkEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
            if (this.dataLoad != event.getChunk()) {
                WorldExtensionManager.createChunkExtension(event.world, event.getChunk());
            }
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.loadChunk(event.getChunk());
                ++n2;
            }
        }

        @ForgeSubscribe
        public void onChunkUnLoad(ChunkEvent.Unload event) {
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.unloadChunk(event.getChunk());
                ++n2;
            }
            if (event.world.I) {
                WorldExtensionManager.removeChunk(event.world, event.getChunk());
            } else {
                this.dataUnload = event.getChunk();
            }
        }

        @ForgeSubscribe
        public void onWorldSave(WorldEvent.Save event) {
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.save();
                ++n2;
            }
        }

        @ForgeSubscribe
        public void onWorldLoad(WorldEvent.Load event) {
            if (!worldMap.containsKey(event.world)) {
                WorldExtensionManager.onWorldLoad(event.world);
            }
        }

        @ForgeSubscribe
        public void onWorldUnLoad(WorldEvent.Unload event) {
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.remove(event.world);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.unload();
                ++n2;
            }
        }

        @ForgeSubscribe
        public void onChunkWatch(ChunkWatchEvent.Watch event) {
            PacketCustom packet = new PacketCustom(WorldExtensionManager.channel, 1);
            packet.writeInt(event.chunk.a);
            packet.writeInt(event.chunk.b);
            packet.sendToPlayer(event.player);
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.player.p);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.watchChunk(event.player.p.e(event.chunk.a, event.chunk.b), event.player);
                ++n2;
            }
        }

        @ForgeSubscribe
        public void onChunkUnWatch(ChunkWatchEvent.UnWatch event) {
            WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(event.player.p);
            int n = worldExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                WorldExtension extension = worldExtensionArray[n2];
                extension.unwatchChunk(event.player.p.e(event.chunk.a, event.chunk.b), event.player);
                ++n2;
            }
        }
    }

    public static class WorldExtensionManagerPacketHandler
    implements PacketCustom.ICustomPacketHandler.IClientPacketHandler {
        @Override
        public void handlePacket(PacketCustom packetCustom, ayh nethandler, Minecraft mc) {
            switch (packetCustom.getType()) {
                case 1: {
                    ayp world = mc.e;
                    zz chunk = world.e(packetCustom.readInt(), packetCustom.readInt());
                    WorldExtensionManager.createChunkExtension((yc)world, chunk);
                    WorldExtension[] worldExtensionArray = (WorldExtension[])worldMap.get(world);
                    int n = worldExtensionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        WorldExtension extension = worldExtensionArray[n2];
                        extension.loadChunk(chunk);
                        ++n2;
                    }
                    break;
                }
            }
        }
    }

    public static class WorldExtensionServerTickHandler
    implements ITickHandler {
        public void tickStart(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.WORLD)) {
                WorldExtensionManager.preTick((yc)tickData[0]);
            }
        }

        public void tickEnd(EnumSet type, Object ... tickData) {
            if (type.contains(TickType.WORLD)) {
                WorldExtensionManager.postTick((yc)tickData[0]);
            }
        }

        public EnumSet ticks() {
            return EnumSet.of(TickType.WORLD, TickType.CLIENT);
        }

        public String getLabel() {
            return "WorldExtenstions";
        }
    }
}

