/*
 * Decompiled with CFR 0.152.
 */
package ic2.core;

import ic2.api.ExplosionWhitelist;
import ic2.core.IC2;
import ic2.core.IC2DamageSource;
import ic2.core.IC2Potion;
import ic2.core.item.armor.ItemArmorHazmat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ExplosionIC2 {
    private Random ExplosionRNG = new Random();
    private yc worldObj;
    private int mapHeight;
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public lq exploder;
    public float power;
    public float explosionDropRate;
    public float explosionDamage;
    public lh damageSource;
    public String igniter;
    public List entitiesInRange;
    public Map vecMap = new HashMap();
    public Map destroyedBlockPositions = new HashMap();
    private final double dropPowerLimit = 8.0;
    private final int secondaryRayCount = 5;

    public ExplosionIC2(yc world, lq entity, double d, double d1, double d2, float power, float drop, float entitydamage, lh damagesource) {
        this.worldObj = world;
        this.mapHeight = IC2.getWorldHeight(world);
        this.exploder = entity;
        this.power = power;
        this.explosionDropRate = drop;
        this.explosionDamage = entitydamage;
        this.explosionX = d;
        this.explosionY = d1;
        this.explosionZ = d2;
        this.damageSource = damagesource;
    }

    public ExplosionIC2(yc world, lq entity, double d, double d1, double d2, float power, float drop, float entitydamage) {
        this(world, entity, d, d1, d2, power, drop, entitydamage, lh.k);
    }

    public ExplosionIC2(yc world, lq entity, double d, double d1, double d2, float power, float drop, float entitydamage, lh damagesource, String igniter) {
        this(world, entity, d, d1, d2, power, drop, entitydamage, damagesource);
        this.igniter = igniter;
    }

    public void doExplosion() {
        if (this.power <= 0.0f) {
            return;
        }
        double maxDistance = (double)this.power / 0.4;
        this.entitiesInRange = this.worldObj.a(md.class, aoe.a((double)(this.explosionX - maxDistance), (double)(this.explosionY - maxDistance), (double)(this.explosionZ - maxDistance), (double)(this.explosionX + maxDistance), (double)(this.explosionY + maxDistance), (double)(this.explosionZ + maxDistance)));
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / maxDistance));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int theta_n = 0; theta_n < steps; ++theta_n) {
                double phi = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)theta_n;
                this.shootRay(this.explosionX, this.explosionY, this.explosionZ, phi, theta, this.power, phi_n % 8 == 0 && theta_n % 8 == 0);
            }
        }
        if (this.damageSource == IC2DamageSource.nuke) {
            for (md entity : this.worldObj.a(md.class, aoe.a((double)(this.explosionX - 100.0), (double)(this.explosionY - 100.0), (double)(this.explosionZ - 100.0), (double)(this.explosionX + 100.0), (double)(this.explosionY + 100.0), (double)(this.explosionZ + 100.0)))) {
                if (ItemArmorHazmat.hasCompleteHazmat(entity)) continue;
                double distance = entity.f(this.explosionX, this.explosionY, this.explosionZ);
                int hungerLength = (int)(120.0 * (100.0 - distance));
                int poisonLength = (int)(80.0 * (30.0 - distance));
                if (hungerLength >= 0) {
                    entity.d(new lm(ll.s.H, hungerLength, 0));
                }
                if (poisonLength < 0) continue;
                entity.d(new lm(IC2Potion.radiation.H, poisonLength, 0));
            }
        }
        IC2.network.initiateExplosionEffect(this.worldObj, this.explosionX, this.explosionY, this.explosionZ);
        HashMap blocksToDrop = new HashMap();
        for (Map.Entry entry : this.destroyedBlockPositions.entrySet()) {
            int x = ((yv)entry.getKey()).a;
            int y = ((yv)entry.getKey()).b;
            int z = ((yv)entry.getKey()).c;
            int blockId = this.worldObj.a(x, y, z);
            if (blockId == 0) continue;
            if (((Boolean)entry.getValue()).booleanValue()) {
                double effectX = (float)x + this.worldObj.t.nextFloat();
                double effectY = (float)y + this.worldObj.t.nextFloat();
                double effectZ = (float)z + this.worldObj.t.nextFloat();
                double d3 = effectX - this.explosionX;
                double d4 = effectY - this.explosionY;
                double d5 = effectZ - this.explosionZ;
                double effectDistance = ke.a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                d3 /= effectDistance;
                d4 /= effectDistance;
                d5 /= effectDistance;
                double d7 = 0.5 / (effectDistance / (double)this.power + 0.1);
                this.worldObj.a("explode", (effectX + this.explosionX) / 2.0, (effectY + this.explosionY) / 2.0, (effectZ + this.explosionZ) / 2.0, d3 *= (d7 *= (double)(this.worldObj.t.nextFloat() * this.worldObj.t.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                this.worldObj.a("smoke", effectX, effectY, effectZ, d3, d4, d5);
                amq block = amq.p[blockId];
                if (this.worldObj.t.nextFloat() <= this.explosionDropRate) {
                    int meta = this.worldObj.h(x, y, z);
                    for (ur itemStack : block.getBlockDropped(this.worldObj, x, y, z, meta, 0)) {
                        ItemWithMeta itemWithMeta;
                        Map map;
                        XZposition xZposition = new XZposition(x / 2, z / 2);
                        if (!blocksToDrop.containsKey(xZposition)) {
                            blocksToDrop.put(xZposition, new HashMap());
                        }
                        if (!(map = (Map)blocksToDrop.get(xZposition)).containsKey(itemWithMeta = new ItemWithMeta(itemStack.c, itemStack.j()))) {
                            map.put(itemWithMeta, new DropData(itemStack.a, y));
                            continue;
                        }
                        map.put(itemWithMeta, ((DropData)map.get(itemWithMeta)).add(itemStack.a, y));
                    }
                }
            }
            this.worldObj.e(x, y, z, 0);
            amq.p[blockId].k(this.worldObj, x, y, z);
        }
        for (Map.Entry entry : blocksToDrop.entrySet()) {
            XZposition xZposition = (XZposition)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                int stackSize;
                ItemWithMeta itemWithMeta = (ItemWithMeta)entry2.getKey();
                for (int count = ((DropData)entry2.getValue()).n; count > 0; count -= stackSize) {
                    stackSize = Math.min(count, 64);
                    px entityitem = new px(this.worldObj, (double)((float)xZposition.x + this.worldObj.t.nextFloat()) * 2.0, (double)((DropData)entry2.getValue()).maxY + 0.5, (double)((float)xZposition.z + this.worldObj.t.nextFloat()) * 2.0, new ur(itemWithMeta.itemId, stackSize, itemWithMeta.metaData));
                    entityitem.b = 10;
                    this.worldObj.d((lq)entityitem);
                }
            }
        }
    }

    private void shootRay(double x, double y, double z, double phi, double theta, double power, boolean killEntities) {
        double deltaX = Math.sin(theta) * Math.cos(phi);
        double deltaY = Math.cos(theta);
        double deltaZ = Math.sin(theta) * Math.sin(phi);
        do {
            int blockId = this.worldObj.a((int)x, (int)y, (int)z);
            double absorption = 0.5;
            if (blockId > 0) {
                absorption += ((double)amq.p[blockId].getExplosionResistance(this.exploder, this.worldObj, (int)x, (int)y, (int)z, this.explosionX, this.explosionY, this.explosionZ) + 4.0) * 0.3;
            }
            if (absorption > 1000.0 && !ExplosionWhitelist.isBlockWhitelisted(amq.p[blockId])) {
                absorption = 0.5;
            } else {
                yv position;
                if (absorption > power) break;
                if (blockId > 0 && (!this.destroyedBlockPositions.containsKey(position = new yv((int)x, (int)y, (int)z)) || power > 8.0 && ((Boolean)this.destroyedBlockPositions.get(position)).booleanValue())) {
                    this.destroyedBlockPositions.put(position, power <= 8.0);
                }
            }
            if (killEntities) {
                Iterator it2 = this.entitiesInRange.iterator();
                while (it2.hasNext()) {
                    md entity = (md)it2.next();
                    if (!((entity.t - x) * (entity.t - x) + (entity.u - y) * (entity.u - y) + (entity.v - z) * (entity.v - z) <= 25.0)) continue;
                    double dx = entity.t - this.explosionX;
                    double dy = entity.u - this.explosionY;
                    double dz = entity.v - this.explosionZ;
                    double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    double distanceFactor = power / 2.0 / (Math.pow(distance, 0.8) + 1.0);
                    entity.a(this.damageSource, (int)Math.pow(distanceFactor * 3.0, 2.0));
                    if (this.damageSource == IC2DamageSource.nuke && entity instanceof qx && this.igniter != null && ((qx)entity).bR.equals(this.igniter) && entity.aU() <= 0) {
                        IC2.achievements.issueAchievement((qx)entity, "dieFromOwnNuke");
                    }
                    entity.w += (dx /= distance) * distanceFactor;
                    entity.x += (dy /= distance) * distanceFactor;
                    entity.y += (dz /= distance) * distanceFactor;
                    it2.remove();
                }
            }
            if (absorption > 10.0) {
                for (int i = 0; i < 5; ++i) {
                    this.shootRay(x, y, z, this.ExplosionRNG.nextDouble() * 2.0 * Math.PI, this.ExplosionRNG.nextDouble() * Math.PI, absorption * 0.4, false);
                }
            }
            power -= absorption;
            x += deltaX;
            z += deltaZ;
        } while (!((y += deltaY) <= 0.0) && !(y >= (double)this.mapHeight));
    }

    static class DropData {
        int n;
        int maxY;

        DropData(int n, int y) {
            this.n = n;
            this.maxY = y;
        }

        public DropData add(int n, int y) {
            this.n += n;
            if (y > this.maxY) {
                this.maxY = y;
            }
            return this;
        }
    }

    static class ItemWithMeta {
        int itemId;
        int metaData;

        ItemWithMeta(int itemId, int metaData) {
            this.itemId = itemId;
            this.metaData = metaData;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemWithMeta) {
                ItemWithMeta itemWithMeta = (ItemWithMeta)obj;
                return itemWithMeta.itemId == this.itemId && itemWithMeta.metaData == this.metaData;
            }
            return false;
        }

        public int hashCode() {
            return this.itemId * 31 ^ this.metaData;
        }
    }

    static class XZposition {
        int x;
        int z;

        XZposition(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (obj instanceof XZposition) {
                XZposition xZposition = (XZposition)obj;
                return xZposition.x == this.x && xZposition.z == this.z;
            }
            return false;
        }

        public int hashCode() {
            return this.x * 31 ^ this.z;
        }
    }
}

