/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.api.BaseSeed;
import ic2.api.CropCard;
import ic2.api.Crops;
import ic2.api.TECrop;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.crop.IC2Crops;
import ic2.core.item.ItemCropSeed;
import ic2.core.util.StackUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TileEntityCrop
extends TECrop
implements INetworkDataProvider,
INetworkUpdateListener {
    public int growthPoints = 0;
    public boolean upgraded = false;
    public char ticker = (char)IC2.random.nextInt(tickRate);
    public boolean dirty = true;
    public static char tickRate = (char)256;
    private boolean created = false;
    public byte humidity = (byte)-1;
    public byte nutrients = (byte)-1;
    public byte airQuality = (byte)-1;

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.id = nbttagcompound.d("cropid");
        this.size = nbttagcompound.c("size");
        this.statGrowth = nbttagcompound.c("statGrowth");
        this.statGain = nbttagcompound.c("statGain");
        this.statResistance = nbttagcompound.c("statResistance");
        for (int x = 0; x < this.custumData.length; ++x) {
            this.custumData[x] = nbttagcompound.d("data" + x);
        }
        this.growthPoints = nbttagcompound.e("growthPoints");
        try {
            this.nutrientStorage = nbttagcompound.e("nutrientStorage");
            this.waterStorage = nbttagcompound.e("waterStorage");
        }
        catch (Throwable e) {
            this.nutrientStorage = nbttagcompound.c("nutrientStorage");
            this.waterStorage = nbttagcompound.c("waterStorage");
        }
        this.upgraded = nbttagcompound.n("upgraded");
        this.scanLevel = nbttagcompound.c("scanLevel");
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("cropid", this.id);
        nbttagcompound.a("size", this.size);
        nbttagcompound.a("statGrowth", this.statGrowth);
        nbttagcompound.a("statGain", this.statGain);
        nbttagcompound.a("statResistance", this.statResistance);
        for (int x = 0; x < this.custumData.length; ++x) {
            nbttagcompound.a("data" + x, this.custumData[x]);
        }
        nbttagcompound.a("growthPoints", this.growthPoints);
        nbttagcompound.a("nutrientStorage", this.nutrientStorage);
        nbttagcompound.a("waterStorage", this.waterStorage);
        nbttagcompound.a("upgraded", this.upgraded);
        nbttagcompound.a("scanLevel", this.scanLevel);
    }

    public void g() {
        super.g();
        if (!this.created && !IC2.platform.isSimulating()) {
            IC2.network.requestInitialData(this);
            this.created = true;
        }
        this.ticker = (char)(this.ticker + '\u0001');
        if (this.ticker % tickRate == 0) {
            this.tick();
        }
        if (this.dirty) {
            this.dirty = false;
            this.k.i(this.l, this.m, this.n);
            this.k.c(yo.b, this.l, this.m, this.n);
            if (IC2.platform.isSimulating()) {
                IC2.network.announceBlockUpdate(this.k, this.l, this.m, this.n);
                if (!IC2.platform.isRendering()) {
                    for (String field : this.getNetworkedFields()) {
                        IC2.network.updateTileEntityField(this, field);
                    }
                }
            }
        }
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(2);
        ret.add("id");
        ret.add("size");
        ret.add("upgraded");
        ret.add("custumData");
        return ret;
    }

    public void tick() {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (this.ticker % (tickRate << 2) == 0) {
            this.humidity = this.updateHumidity();
        }
        if ((this.ticker + tickRate) % (tickRate << 2) == 0) {
            this.nutrients = this.updateNutrients();
        }
        if ((this.ticker + tickRate * 2) % (tickRate << 2) == 0) {
            this.airQuality = this.updateAirQuality();
        }
        if (!(this.id >= 0 || this.upgraded && this.attemptCrossing())) {
            if (IC2.random.nextInt(100) == 0 && !this.hasEx()) {
                this.reset();
                this.id = (short)IC2Crops.weed.getId();
                this.size = 1;
            } else {
                if (this.exStorage > 0 && IC2.random.nextInt(10) == 0) {
                    --this.exStorage;
                }
                return;
            }
        }
        this.crop().tick(this);
        if (this.crop().canGrow(this)) {
            this.growthPoints += this.calcGrowthRate();
            if (this.id > -1 && this.growthPoints >= this.crop().growthDuration(this)) {
                this.growthPoints = 0;
                this.size = (byte)(this.size + 1);
                this.dirty = true;
            }
        }
        if (this.nutrientStorage > 0) {
            --this.nutrientStorage;
        }
        if (this.waterStorage > 0) {
            --this.waterStorage;
        }
        if (this.crop().isWeed(this) && IC2.random.nextInt(50) - this.statGrowth <= 2) {
            this.generateWeed();
        }
    }

    public void generateWeed() {
        int block;
        int x = this.l;
        int y = this.m;
        int z = this.n;
        switch (IC2.random.nextInt(4)) {
            case 0: {
                ++x;
            }
            case 1: {
                --x;
            }
            case 2: {
                ++z;
            }
            case 3: {
                --z;
            }
        }
        if (this.k.q(x, y, z) instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)this.k.q(x, y, z);
            if (crop.id == -1 || !crop.crop().isWeed(crop) && IC2.random.nextInt(32) >= crop.statResistance && !crop.hasEx()) {
                byte newGrowth = this.statGrowth;
                if (crop.statGrowth > newGrowth) {
                    newGrowth = crop.statGrowth;
                }
                if (newGrowth < 31 && IC2.random.nextBoolean()) {
                    newGrowth = (byte)(newGrowth + 1);
                }
                crop.reset();
                crop.id = 0;
                crop.size = 1;
                crop.statGrowth = newGrowth;
            }
        } else if (this.k.a(x, y, z) == 0 && ((block = this.k.a(x, y - 1, z)) == amq.y.cm || block == amq.x.cm || block == amq.aD.cm)) {
            this.k.e(x, y - 1, z, amq.x.cm);
            this.k.d(x, y, z, amq.aa.cm, 1);
        }
    }

    public boolean hasEx() {
        if (this.exStorage > 0) {
            this.exStorage -= 5;
            return true;
        }
        return false;
    }

    public boolean attemptCrossing() {
        int i;
        if (IC2.random.nextInt(3) != 0) {
            return false;
        }
        LinkedList crops = new LinkedList();
        this.askCropJoinCross(this.l - 1, this.m, this.n, crops);
        this.askCropJoinCross(this.l + 1, this.m, this.n, crops);
        this.askCropJoinCross(this.l, this.m, this.n - 1, crops);
        this.askCropJoinCross(this.l, this.m, this.n + 1, crops);
        if (crops.size() < 2) {
            return false;
        }
        int[] ratios = new int[256];
        for (int i2 = 1; i2 < ratios.length; ++i2) {
            if (!CropCard.idExists(i2) || !CropCard.getCrop(i2).canGrow(this)) continue;
            for (int j = 0; j < crops.size(); ++j) {
                int n = i2;
                ratios[n] = ratios[n] + this.calculateRatioFor(CropCard.getCrop(i2), ((TileEntityCrop)crops.get(j)).crop());
            }
        }
        int total = 0;
        for (i = 0; i < ratios.length; ++i) {
            total += ratios[i];
        }
        total = IC2.random.nextInt(total);
        for (i = 0; i < ratios.length; ++i) {
            if (ratios[i] > 0 && ratios[i] > total) {
                total = i;
                break;
            }
            total -= ratios[i];
        }
        this.upgraded = false;
        this.id = (short)total;
        this.dirty = true;
        this.size = 1;
        this.statGrowth = 0;
        this.statResistance = 0;
        this.statGain = 0;
        for (i = 0; i < crops.size(); ++i) {
            this.statGrowth = (byte)(this.statGrowth + ((TileEntityCrop)crops.get((int)i)).statGrowth);
            this.statResistance = (byte)(this.statResistance + ((TileEntityCrop)crops.get((int)i)).statResistance);
            this.statGain = (byte)(this.statGain + ((TileEntityCrop)crops.get((int)i)).statGain);
        }
        int count = crops.size();
        this.statGrowth = (byte)(this.statGrowth / count);
        this.statResistance = (byte)(this.statResistance / count);
        this.statGain = (byte)(this.statGain / count);
        this.statGrowth = (byte)(this.statGrowth + (IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statGrowth < 0) {
            this.statGrowth = 0;
        }
        if (this.statGrowth > 31) {
            this.statGrowth = (byte)31;
        }
        this.statGain = (byte)(this.statGain + (IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statGain < 0) {
            this.statGain = 0;
        }
        if (this.statGain > 31) {
            this.statGain = (byte)31;
        }
        this.statResistance = (byte)(this.statResistance + (IC2.random.nextInt(1 + 2 * count) - count));
        if (this.statResistance < 0) {
            this.statResistance = 0;
        }
        if (this.statResistance > 31) {
            this.statResistance = (byte)31;
        }
        return true;
    }

    public int calculateRatioFor(CropCard a, CropCard b) {
        int i;
        if (a == b) {
            return 500;
        }
        int value = 0;
        for (i = 0; i < 5; ++i) {
            int c = a.stat(i) - b.stat(i);
            if (c < 0) {
                c *= -1;
            }
            switch (c) {
                default: {
                    --value;
                }
                case 0: {
                    value += 2;
                }
                case 1: {
                    ++value;
                }
                case 2: 
            }
        }
        for (i = 0; i < a.attributes().length; ++i) {
            for (int j = 0; j < b.attributes().length; ++j) {
                if (!a.attributes()[i].equalsIgnoreCase(b.attributes()[j])) continue;
                value += 5;
            }
        }
        if (b.tier() < a.tier() - 1) {
            value -= 2 * (a.tier() - b.tier());
        }
        if (b.tier() - 3 > a.tier()) {
            value -= b.tier() - a.tier();
        }
        if (value < 0) {
            value = 0;
        }
        return value;
    }

    public void askCropJoinCross(int x, int y, int z, LinkedList crops) {
        if (!(this.k.q(x, y, z) instanceof TileEntityCrop)) {
            return;
        }
        TileEntityCrop sidecrop = (TileEntityCrop)this.k.q(x, y, z);
        if (sidecrop.id <= 0) {
            return;
        }
        if (!sidecrop.crop().canGrow(this) || !sidecrop.crop().canCross(sidecrop)) {
            return;
        }
        int base = 4;
        if (sidecrop.statGrowth >= 16) {
            ++base;
        }
        if (sidecrop.statGrowth >= 30) {
            ++base;
        }
        if (sidecrop.statResistance >= 28) {
            base += 27 - sidecrop.statResistance;
        }
        if (base >= IC2.random.nextInt(20)) {
            crops.add(sidecrop);
        }
    }

    public boolean leftclick(qx player) {
        if (this.id < 0) {
            if (this.upgraded) {
                this.upgraded = false;
                this.dirty = true;
                if (IC2.platform.isSimulating()) {
                    StackUtil.dropAsEntity(this.k, this.l, this.m, this.n, new ur(Ic2Items.crop.b()));
                }
                return true;
            }
            return false;
        }
        return this.crop().leftclick(this, player);
    }

    @Override
    public boolean pick(boolean manual) {
        int i;
        if (this.id < 0) {
            return false;
        }
        boolean bonus = this.harvest(false);
        float firstchance = this.crop().dropSeedChance(this);
        for (int i2 = 0; i2 < this.statResistance; ++i2) {
            firstchance *= 1.1f;
        }
        int drop = 0;
        if (bonus) {
            if (IC2.random.nextFloat() <= (firstchance + 1.0f) * 0.8f) {
                ++drop;
            }
            float chance = this.crop().dropSeedChance(this) + (float)this.statGrowth / 100.0f;
            if (!manual) {
                chance *= 0.8f;
            }
            for (i = 23; i < this.statGain; ++i) {
                chance *= 0.95f;
            }
            if (IC2.random.nextFloat() <= chance) {
                ++drop;
            }
        } else if (IC2.random.nextFloat() <= firstchance * 1.5f) {
            ++drop;
        }
        ur[] re = new ur[drop];
        for (i = 0; i < drop; ++i) {
            re[i] = this.crop().getSeeds(this);
        }
        this.reset();
        if (IC2.platform.isSimulating() && re != null && re.length > 0) {
            for (int x = 0; x < re.length; ++x) {
                if (re[x].c != Ic2Items.cropSeed.c) {
                    re[x].d = null;
                }
                StackUtil.dropAsEntity(this.k, this.l, this.m, this.n, re[x]);
            }
        }
        return true;
    }

    public boolean rightclick(qx player) {
        ur current = player.bS();
        if (current != null) {
            if (this.id < 0) {
                if (current.c == Ic2Items.crop.c && !this.upgraded) {
                    if (!player.cd.d) {
                        --current.a;
                        if (current.a <= 0) {
                            player.bJ.a[player.bJ.c] = null;
                        }
                    }
                    this.upgraded = true;
                    this.dirty = true;
                    return true;
                }
                if (this.applyBaseSeed(current, player)) {
                    return true;
                }
            } else if (current.c == Ic2Items.cropnalyzer.c) {
                if (IC2.platform.isSimulating()) {
                    String desc = this.getScanned();
                    if (desc == null) {
                        desc = "Unknown Crop";
                    }
                    IC2.platform.messagePlayer(player, desc);
                }
                return true;
            }
            if (current.c == up.ax.cj || current.c == Ic2Items.waterCell.b().cj) {
                if (this.waterStorage < 10) {
                    this.waterStorage = 10;
                    return true;
                }
                return current.c == up.ax.cj;
            }
            if (current.c == up.S.cj) {
                if (this.nutrientStorage <= 50) {
                    this.nutrientStorage += 25;
                    --current.a;
                    if (current.a <= 0) {
                        player.bJ.a[player.bJ.c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.c == up.aW.cj && current.j() == 15 || current.c == Ic2Items.fertilizer.c) {
                if (this.applyFertilizer(true)) {
                    --current.a;
                    if (current.a <= 0) {
                        player.bJ.a[player.bJ.c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.c == Ic2Items.hydratingCell.c) {
                if (this.applyHydration(true, current)) {
                    if (current.a <= 0) {
                        player.bJ.a[player.bJ.c] = null;
                    }
                    return true;
                }
                return false;
            }
            if (current.c == Ic2Items.weedEx.c && this.applyWeedEx(true)) {
                current.a(1, (md)player);
                if (current.j() >= current.k()) {
                    --current.a;
                }
                if (current.a <= 0) {
                    player.bJ.a[player.bJ.c] = null;
                }
                return true;
            }
        }
        if (this.id < 0) {
            return false;
        }
        return this.crop().rightclick(this, player);
    }

    public boolean applyBaseSeed(ur current, qx player) {
        BaseSeed seed = CropCard.getBaseSeed(current);
        if (seed != null) {
            if (current.a < seed.stackSize) {
                return false;
            }
            if (this.tryPlantIn(seed.id, seed.size, seed.statGrowth, seed.statGain, seed.statResistance, 1)) {
                if (current.b().s()) {
                    current = current.b().getContainerItemStack(current);
                } else {
                    current.a -= seed.stackSize;
                    if (current.a <= 0) {
                        player.bJ.a[player.bJ.c] = null;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean tryPlantIn(int i, int si, int statGr, int statGa, int statRe, int scan) {
        if (this.id > -1 || i <= 0 || this.upgraded) {
            return false;
        }
        if (!CropCard.getCrop(i).canGrow(this)) {
            return false;
        }
        this.reset();
        this.id = (short)i;
        this.size = (byte)si;
        this.statGrowth = (byte)statGr;
        this.statGain = (byte)statGa;
        this.statResistance = (byte)statRe;
        this.scanLevel = (byte)scan;
        return true;
    }

    public boolean applyFertilizer(boolean manual) {
        if (this.nutrientStorage >= 100) {
            return false;
        }
        this.nutrientStorage += manual ? 100 : 90;
        return true;
    }

    public boolean applyHydration(boolean manual, ur current) {
        int apply;
        if (!manual && this.waterStorage >= 180 || this.waterStorage >= 200) {
            return false;
        }
        int n = apply = manual ? 200 - this.waterStorage : 180 - this.waterStorage;
        if (apply + current.j() > current.k()) {
            apply = current.k() - current.j();
        }
        current.a(apply, null);
        if (current.j() >= current.k()) {
            --current.a;
        }
        this.waterStorage += apply;
        return true;
    }

    public boolean applyWeedEx(boolean manual) {
        boolean trigger;
        if (this.exStorage >= 100 && manual || this.exStorage >= 150) {
            return false;
        }
        this.exStorage += 50;
        boolean bl = trigger = this.k.t.nextInt(3) == 0;
        if (manual) {
            boolean bl2 = trigger = this.k.t.nextInt(5) == 0;
        }
        if (this.id > 0 && this.exStorage >= 75 && trigger) {
            switch (this.k.t.nextInt(5)) {
                case 0: {
                    if (this.statGrowth > 0) {
                        this.statGrowth = (byte)(this.statGrowth - 1);
                    }
                }
                case 1: {
                    if (this.statGain <= 0) break;
                    this.statGain = (byte)(this.statGain - 1);
                }
            }
            if (this.statResistance > 0) {
                this.statResistance = (byte)(this.statResistance - 1);
            }
        }
        return true;
    }

    @Override
    public boolean harvest(boolean manual) {
        if (this.id < 0 || !this.crop().canBeHarvested(this)) {
            return false;
        }
        float chance = this.crop().dropGainChance();
        for (int i = 0; i < this.statGain; ++i) {
            chance *= 1.03f;
        }
        chance -= IC2.random.nextFloat();
        int drop = 0;
        while (chance > 0.0f) {
            ++drop;
            chance -= IC2.random.nextFloat();
        }
        ur[] re = new ur[drop];
        for (int i = 0; i < drop; ++i) {
            re[i] = this.crop().getGain(this);
            if (re[i] == null || IC2.random.nextInt(100) > this.statGain) continue;
            ++re[i].a;
        }
        this.size = this.crop().getSizeAfterHarvest(this);
        this.dirty = true;
        if (IC2.platform.isSimulating() && re != null && re.length > 0) {
            for (int x = 0; x < re.length; ++x) {
                StackUtil.dropAsEntity(this.k, this.l, this.m, this.n, re[x]);
            }
        }
        return true;
    }

    public void onNeighbourChange() {
        if (this.id < 0) {
            return;
        }
        this.crop().onNeighbourChange(this);
    }

    public boolean emitRedstone() {
        if (this.id < 0) {
            return false;
        }
        return this.crop().emitRedstone(this);
    }

    public void onBlockDestroyed() {
        if (this.id < 0) {
            return;
        }
        this.crop().onBlockDestroyed(this);
    }

    public int getEmittedLight() {
        if (this.id < 0) {
            return 0;
        }
        return this.crop().getEmittedLight(this);
    }

    @Override
    public byte getHumidity() {
        if (this.humidity == -1) {
            this.humidity = this.updateHumidity();
        }
        return this.humidity;
    }

    @Override
    public byte getNutrients() {
        if (this.nutrients == -1) {
            this.nutrients = this.updateNutrients();
        }
        return this.nutrients;
    }

    @Override
    public byte getAirQuality() {
        if (this.airQuality == -1) {
            this.airQuality = this.updateAirQuality();
        }
        return this.airQuality;
    }

    public byte updateHumidity() {
        int value = Crops.getHumidityBiomeBonus(this.k.t().a(this.l, this.n));
        if (this.k.h(this.l, this.m - 1, this.n) >= 7) {
            value += 2;
        }
        if (this.waterStorage >= 5) {
            value += 2;
        }
        return (byte)(value += (this.waterStorage + 24) / 25);
    }

    public byte updateNutrients() {
        int value = Crops.getNutrientBiomeBonus(this.k.t().a(this.l, this.n));
        for (int i = 2; i < 5 && this.k.a(this.l, this.m - i, this.n) == amq.y.cm; ++i) {
            ++value;
        }
        return (byte)(value += (this.nutrientStorage + 19) / 20);
    }

    public byte updateAirQuality() {
        int value = 0;
        int height = (this.m - 64) / 15;
        if (height > 4) {
            height = 4;
        }
        if (height < 0) {
            height = 0;
        }
        value += height;
        int fresh = 9;
        for (int x = this.l - 1; x < this.l + 1 && fresh > 0; ++x) {
            for (int z = this.n - 1; z < this.n + 1 && fresh > 0; ++z) {
                if (!this.k.s(x, this.m, z) && !(this.k.q(x, this.m, z) instanceof TileEntityCrop)) continue;
                --fresh;
            }
        }
        value += fresh / 2;
        if (this.k.k(this.l, this.m + 1, this.n)) {
            value += 2;
        }
        return (byte)value;
    }

    public byte updateMultiCulture() {
        LinkedList crops = new LinkedList();
        for (int x = -1; x < 1; ++x) {
            for (int z = -1; z < 1; ++z) {
                if (!(this.k.q(x + this.l, this.m, z + this.n) instanceof TileEntityCrop)) continue;
                this.addIfNotPresent(((TileEntityCrop)this.k.q(x + this.l, this.m, z + this.n)).crop(), crops);
            }
        }
        return (byte)(crops.size() - 1);
    }

    public void addIfNotPresent(CropCard crop, LinkedList crops) {
        for (int i = 0; i < crops.size(); ++i) {
            if (crop != crops.get(i)) continue;
            return;
        }
        crops.add(crop);
    }

    public int calcGrowthRate() {
        int have;
        int base = 3 + IC2.random.nextInt(7) + this.statGrowth;
        int need = (this.crop().tier() - 1) * 4 + this.statGrowth + this.statGain + this.statResistance;
        if (need < 0) {
            need = 0;
        }
        if ((have = this.crop().weightInfluences(this, this.getHumidity(), this.getNutrients(), this.getAirQuality()) * 5) >= need) {
            base = base * (100 + (have - need)) / 100;
        } else {
            int neg = (need - have) * 4;
            if (neg > 100 && IC2.random.nextInt(32) > this.statResistance) {
                this.reset();
                base = 0;
            } else if ((base = base * (100 - neg) / 100) < 0) {
                base = 0;
            }
        }
        return base;
    }

    public void calcTrampling() {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (IC2.random.nextInt(100) == 0 && IC2.random.nextInt(40) > this.statResistance) {
            this.reset();
            this.k.d(this.l, this.m - 1, this.n, amq.y.cm, 0);
        }
    }

    public CropCard crop() {
        return CropCard.getCrop(this.id);
    }

    public int getSprite() {
        if (this.id < 0) {
            if (!this.upgraded) {
                return 0;
            }
            return 1;
        }
        return this.crop().getSpriteIndex(this);
    }

    public void onEntityCollision(lq entity) {
        if (this.id < 0) {
            return;
        }
        if (this.crop().onEntityCollision(this, entity)) {
            this.calcTrampling();
        }
    }

    @Override
    public void reset() {
        this.id = (short)-1;
        this.size = 0;
        this.custumData = new short[16];
        this.dirty = true;
        this.statGain = 0;
        this.statResistance = 0;
        this.statGrowth = 0;
        this.nutrients = (byte)-1;
        this.airQuality = (byte)-1;
        this.humidity = (byte)-1;
        this.growthPoints = 0;
        this.upgraded = false;
        this.scanLevel = 0;
    }

    @Override
    public void updateState() {
        this.dirty = true;
    }

    public String getScanned() {
        if (this.scanLevel <= 0 || this.id < 0) {
            return null;
        }
        if (this.scanLevel >= 4) {
            return this.crop().name() + " - Gr: " + this.statGrowth + " Ga: " + this.statGain + " Re: " + this.statResistance;
        }
        return this.crop().name();
    }

    @Override
    public boolean isBlockBelow(amq block) {
        for (int i = 1; i < 4; ++i) {
            int id = this.k.a(this.l, this.m - i, this.n);
            if (id == 0) {
                return false;
            }
            if (amq.p[id] != block) continue;
            return true;
        }
        return false;
    }

    @Override
    public ur generateSeeds(short plant, byte growth, byte gain, byte resis, byte scan) {
        return ItemCropSeed.generateItemStackFromValues(plant, growth, gain, resis, scan);
    }

    @Override
    public void addLocal(String s1, String s2) {
        IC2.platform.addLocalization(s1, s2);
    }

    @Override
    public void onNetworkUpdate(String field) {
        this.dirty = true;
    }
}

