/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.generator.container.ContainerWaterGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class TileEntityWaterGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public static Random randomizer = new Random();
    public int ticker;
    public int water = 0;
    public int microStorage = 0;
    public int maxWater = 2000;

    public TileEntityWaterGenerator() {
        super(2, 2, 2);
        this.production = 2;
        this.ticker = randomizer.nextInt(this.tickRate());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateWaterCount();
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxWater;
    }

    @Override
    public boolean gainFuel() {
        if (this.inventory[1] != null && this.maxWater - this.fuel >= 500) {
            if (this.inventory[1].c == up.ax.cj) {
                this.production = 1;
                this.fuel += 500;
                this.inventory[1].c = up.aw.cj;
                return true;
            }
            if (this.inventory[1].c == Ic2Items.waterCell.c) {
                this.production = 2;
                this.fuel += 500;
                --this.inventory[1].a;
                if (this.inventory[1].a <= 0) {
                    this.inventory[1] = null;
                }
                return true;
            }
            LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ur)this.inventory[1]);
            if (liquid != null && liquid.itemID == amq.E.cm) {
                this.fuel += 500;
                if (this.inventory[1].b().s()) {
                    this.production = 1;
                    this.inventory[1] = this.inventory[1].b().getContainerItemStack(this.inventory[1]);
                } else {
                    this.production = 2;
                    --this.inventory[1].a;
                    if (this.inventory[1].a <= 0) {
                        this.inventory[1] = null;
                    }
                }
                return true;
            }
        } else if (this.fuel <= 0) {
            this.flowPower();
            this.production = this.microStorage / 100;
            this.microStorage -= this.production * 100;
            if (this.production > 0) {
                ++this.fuel;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean gainFuelSub(ur stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxWater;
    }

    public void flowPower() {
        if (this.ticker++ % this.tickRate() == 0) {
            this.updateWaterCount();
        }
        this.water = this.water * IC2.energyGeneratorWater / 100;
        if (this.water > 0) {
            this.microStorage += this.water;
        }
    }

    public void updateWaterCount() {
        int count = 0;
        for (int x = this.l - 1; x < this.l + 2; ++x) {
            for (int y = this.m - 1; y < this.m + 2; ++y) {
                for (int z = this.n - 1; z < this.n + 2; ++z) {
                    if (this.k.a(x, y, z) != amq.D.cm && this.k.a(x, y, z) != amq.E.cm) continue;
                    ++count;
                }
            }
        }
        this.water = count;
    }

    @Override
    public String b() {
        return "Water Mill";
    }

    @Override
    public String getGuiClassName(qx entityPlayer) {
        return "block.generator.gui.GuiWaterGenerator";
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/WatermillLoop.ogg";
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public ContainerIC2 getGuiContainer(qx entityPlayer) {
        return new ContainerWaterGenerator(entityPlayer, this);
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

