/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.Direction;
import ic2.api.IElectricItem;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.item.ElectricItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TileEntityElecMachine
extends TileEntityMachine
implements IEnergySink {
    public int energy = 0;
    public int fuelslot;
    public int maxEnergy;
    public int maxInput;
    public int tier = 0;
    public boolean addedToEnergyNet = false;

    public TileEntityElecMachine(int slots, int fuelslot, int maxenergy, int maxinput) {
        super(slots);
        this.fuelslot = fuelslot;
        this.maxEnergy = maxenergy;
        this.maxInput = maxinput;
        this.tier = 1;
    }

    public TileEntityElecMachine(int slots, int fuelslot, int maxenergy, int maxinput, int tier) {
        super(slots);
        this.fuelslot = fuelslot;
        this.maxEnergy = maxenergy;
        this.maxInput = maxinput;
        this.tier = tier;
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.energy = nbttagcompound.e("energy");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energy", this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public boolean provideEnergy() {
        boolean ret = false;
        if (this.inventory[this.fuelslot] == null) {
            return false;
        }
        int id = this.inventory[this.fuelslot].c;
        if (up.e[id] instanceof IElectricItem) {
            if (!((IElectricItem)up.e[id]).canProvideEnergy()) {
                return false;
            }
            int transfer = ElectricItem.discharge(this.inventory[this.fuelslot], this.maxEnergy - this.energy, this.tier, false, false);
            this.energy += transfer;
            return ret || transfer > 0;
        }
        if (id == up.aC.cj) {
            this.energy += this.maxEnergy;
            --this.inventory[this.fuelslot].a;
            if (this.inventory[this.fuelslot].a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            return true;
        }
        if (id == Ic2Items.suBattery.c) {
            this.energy += 1000;
            --this.inventory[this.fuelslot].a;
            if (this.inventory[this.fuelslot].a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            return true;
        }
        return ret;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public int demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            IC2.explodeMachineAt(this.k, this.l, this.m, this.n);
            return 0;
        }
        this.energy += amount;
        int re = 0;
        if (this.energy > this.maxEnergy) {
            re = this.energy - this.maxEnergy;
            this.energy = this.maxEnergy;
        }
        return re;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return true;
    }

    public boolean isRedstonePowered() {
        return this.k.B(this.l, this.m, this.n);
    }
}

