/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityMagnetizer
extends TileEntityBlock
implements IEnergySink {
    public int energy = 0;
    public int ticker = 0;
    public int maxEnergy = 100;
    public int maxInput = 32;
    public boolean addedToEnergyNet = false;

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.energy = nbttagcompound.d("energy");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energy", (short)this.energy);
    }

    @Override
    public boolean canUpdate() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void g() {
        int need;
        int y;
        super.g();
        if (this.ticker-- > 0) {
            return;
        }
        boolean change = false;
        for (y = this.m - 1; y > 0 && y >= this.m - 20 && this.energy > 0 && this.k.a(this.l, y, this.n) == Ic2Items.ironFence.c; --y) {
            need = 15 - this.k.h(this.l, y, this.n);
            if (need <= 0) continue;
            change = true;
            if (need > this.energy) {
                this.energy = need;
            }
            this.k.c(this.l, y, this.n, this.k.h(this.l, y, this.n) + need);
            IC2.network.announceBlockUpdate(this.k, this.l, y, this.n);
            this.energy -= need;
        }
        for (y = this.m + 1; y < IC2.getWorldHeight(this.k) && y <= this.m + 20 && this.energy > 0 && this.k.a(this.l, y, this.n) == Ic2Items.ironFence.c; ++y) {
            need = 15 - this.k.h(this.l, y, this.n);
            if (need <= 0) continue;
            change = true;
            if (need > this.energy) {
                this.energy = need;
            }
            this.k.c(this.l, y, this.n, this.k.h(this.l, y, this.n) + need);
            IC2.network.announceBlockUpdate(this.k, this.l, y, this.n);
            this.energy -= need;
        }
        if (!change) {
            this.ticker = 10;
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return true;
    }

    @Override
    public int demandsEnergy() {
        return this.maxEnergy - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            IC2.explodeMachineAt(this.k, this.l, this.m, this.n);
            return 0;
        }
        int need = amount;
        if (this.energy + amount >= this.maxEnergy + this.maxInput) {
            need = this.maxEnergy + this.maxInput - this.energy - 1;
        }
        this.energy += need;
        return amount - need;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }
}

