/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.Direction;
import ic2.api.IPaintableBlock;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.BlockMultiID;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.TileEntityCable;
import ic2.core.block.wiring.TileEntityCableDetector;
import ic2.core.block.wiring.TileEntityCableSplitter;
import ic2.core.item.block.ItemBlockRare;
import ic2.core.item.tool.ItemToolCutter;
import ic2.core.util.AabbUtil;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;

public class BlockCable
extends BlockMultiID
implements IPaintableBlock {
    private static final Direction[] directions = Direction.values();

    public BlockCable(int i) {
        super(i, agi.f);
        this.c(0.2f);
        this.a(k);
        Ic2Items.copperCableBlock = new ur((amq)this, 1, 1);
        Ic2Items.insulatedCopperCableBlock = new ur((amq)this, 1, 0);
        Ic2Items.goldCableBlock = new ur((amq)this, 1, 2);
        Ic2Items.insulatedGoldCableBlock = new ur((amq)this, 1, 3);
        Ic2Items.doubleInsulatedGoldCableBlock = new ur((amq)this, 1, 4);
        Ic2Items.ironCableBlock = new ur((amq)this, 1, 5);
        Ic2Items.insulatedIronCableBlock = new ur((amq)this, 1, 6);
        Ic2Items.doubleInsulatedIronCableBlock = new ur((amq)this, 1, 7);
        Ic2Items.trippleInsulatedIronCableBlock = new ur((amq)this, 1, 8);
        Ic2Items.glassFiberCableBlock = new ur((amq)this, 1, 9);
        Ic2Items.tinCableBlock = new ur((amq)this, 1, 10);
        Ic2Items.detectorCableBlock = new ur((amq)this, 1, 11);
        Ic2Items.splitterCableBlock = new ur((amq)this, 1, 12);
        GameRegistry.registerBlock((amq)this, ItemBlockRare.class, (String)"cableBlock");
    }

    public String getTextureFile() {
        return "/ic2/sprites/block_cable.png";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int d(ym iblockaccess, int x, int y, int z, int side) {
        short cableType;
        int color = 0;
        any te = iblockaccess.q(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            cableType = (short)iblockaccess.h(x, y, z);
            return cableType * 16 + color;
        }
        TileEntityCable cable = (TileEntityCable)te;
        if (cable.foamed != 0) {
            if (cable.foamed != 1) return 208 + cable.foamColor;
            return 178;
        }
        cableType = cable.cableType;
        if (!(te instanceof TileEntityCableDetector) && !(te instanceof TileEntityCableSplitter)) {
            color = cable.color;
            return cableType * 16 + color;
        }
        color = cable.getActive() ? 1 : 0;
        return cableType * 16 + color;
    }

    @Override
    public int a(int side, int meta) {
        return meta * 16;
    }

    public aoh a(yc world, int x, int y, int z, aoj origin, aoj absDirection) {
        any te = world.q(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return null;
        }
        TileEntityCable tileEntityCable = (TileEntityCable)te;
        aoj direction = aoj.a((double)(absDirection.c - origin.c), (double)(absDirection.d - origin.d), (double)(absDirection.e - origin.e));
        double maxLength = direction.b();
        double halfThickness = (double)tileEntityCable.getCableThickness() / 2.0;
        boolean hit = false;
        aoj intersection = aoj.a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, aoe.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness)), intersection);
        if (intersectingDirection != null && intersection.d(origin) <= maxLength) {
            hit = true;
        }
        for (Direction dir : directions) {
            if (hit) break;
            any target = dir.applyToTileEntity(tileEntityCable);
            if (!tileEntityCable.canInteractWith(target)) continue;
            aoe bbox = null;
            switch (dir) {
                case XN: {
                    bbox = aoe.a((double)x, (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case XP: {
                    bbox = aoe.a((double)((double)x + 0.5), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 1.0), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case YN: {
                    bbox = aoe.a((double)((double)x + 0.5 - halfThickness), (double)y, (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case YP: {
                    bbox = aoe.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 1.0), (double)((double)z + 0.5 + halfThickness));
                    break;
                }
                case ZN: {
                    bbox = aoe.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)z, (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5));
                    break;
                }
                case ZP: {
                    bbox = aoe.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 1.0));
                }
            }
            intersectingDirection = AabbUtil.getIntersection(origin, direction, bbox, intersection);
            if (intersectingDirection == null || !(intersection.d(origin) <= maxLength)) continue;
            hit = true;
        }
        if (hit) {
            return new aoh(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public aoe getCollisionBoundingBoxFromPool(yc world, int x, int y, int z, int meta) {
        double halfThickness = TileEntityCable.getCableThickness(meta);
        return aoe.a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
    }

    public aoe e(yc world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public aoe b_(yc world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    public aoe getCommonBoundingBoxFromPool(yc world, int x, int y, int z, boolean selectionBoundingBox) {
        any te = world.q(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return this.getCollisionBoundingBoxFromPool(world, x, y, z, 3);
        }
        TileEntityCable cable = (TileEntityCable)te;
        double halfThickness = cable.foamed == 1 && selectionBoundingBox ? 0.5 : (double)cable.getCableThickness() / 2.0;
        double minX = (double)x + 0.5 - halfThickness;
        double minY = (double)y + 0.5 - halfThickness;
        double minZ = (double)z + 0.5 - halfThickness;
        double maxX = (double)x + 0.5 + halfThickness;
        double maxY = (double)y + 0.5 + halfThickness;
        double maxZ = (double)z + 0.5 + halfThickness;
        if (cable.canInteractWith(world.q(x - 1, y, z))) {
            minX = x;
        }
        if (cable.canInteractWith(world.q(x, y - 1, z))) {
            minY = y;
        }
        if (cable.canInteractWith(world.q(x, y, z - 1))) {
            minZ = z;
        }
        if (cable.canInteractWith(world.q(x + 1, y, z))) {
            maxX = x + 1;
        }
        if (cable.canInteractWith(world.q(x, y + 1, z))) {
            maxY = y + 1;
        }
        if (cable.canInteractWith(world.q(x, y, z + 1))) {
            maxZ = z + 1;
        }
        return aoe.a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public boolean isBlockNormalCube(yc world, int x, int y, int z) {
        any te = world.q(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean a(yc world, int x, int y, int z, qx entityPlayer, int side, float a, float b, float c) {
        ur cur = entityPlayer.bS();
        if (cur != null && cur.c == amq.H.cm) {
            if (!IC2.platform.isSimulating()) {
                return true;
            }
            any te = world.q(x, y, z);
            if (te instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)te;
                if (cable.foamed == 1 && cable.changeFoam((byte)2)) {
                    --cur.a;
                    if (cur.a <= 0) {
                        entityPlayer.bJ.a[entityPlayer.bJ.c] = null;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static int getCableColor(ym iblockaccess, int i, int j, int k) {
        any te = iblockaccess.q(i, j, k);
        return te instanceof TileEntityCable ? (int)((TileEntityCable)te).color : 0;
    }

    @Override
    public boolean colorBlock(yc world, int i, int j, int k, int color) {
        return ((TileEntityCable)world.q(i, j, k)).changeColor(color);
    }

    public boolean canHarvestBlock(qx player, int md2) {
        return true;
    }

    @Override
    public ArrayList getBlockDropped(yc world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ur> ret = new ArrayList<ur>();
        any te = world.q(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            ret.add(new ur(Ic2Items.insulatedCopperCableItem.c, 1, (int)cable.cableType));
        } else if (metadata != 13) {
            ret.add(new ur(Ic2Items.insulatedCopperCableItem.c, 1, metadata));
        }
        return ret;
    }

    @Override
    public void a(yc world, int x, int y, int z, int a, int b) {
        any te;
        if (world.h(x, y, z) == 13 && (te = world.q(x, y, z)) instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            StackUtil.dropAsEntity(world, x, y, z, new ur(Ic2Items.insulatedCopperCableItem.c, 1, (int)cable.cableType));
        }
        super.a(world, x, y, z, a, b);
    }

    @Override
    public TileEntityBlock createNewTileEntity(yc world, int meta) {
        if (meta == 11) {
            return new TileEntityCableDetector((short)meta);
        }
        if (meta == 12) {
            return new TileEntityCableSplitter((short)meta);
        }
        return new TileEntityCable((short)meta);
    }

    public boolean b() {
        return false;
    }

    public int d() {
        return IC2.platform.getRenderId("cable");
    }

    public boolean c() {
        return false;
    }

    public void a(yc world, int i, int j, int k, qx entityplayer) {
        if (entityplayer.bS() != null && entityplayer.bS().b() instanceof ItemToolCutter) {
            ItemToolCutter.cutInsulationFrom(entityplayer.bS(), world, i, j, k);
        }
    }

    public boolean b(ym iblockaccess, int x, int y, int z, int side) {
        any te = iblockaccess.q(x, y, z);
        if (te instanceof TileEntityCableDetector) {
            return ((TileEntityCableDetector)te).getActive();
        }
        return false;
    }

    @Override
    public void a(int i, tj tabs, List itemList) {
    }

    public float m(yc world, int x, int y, int z) {
        if (world != null && world.h(x, y, z) == 13) {
            return 3.0f;
        }
        return 0.2f;
    }

    public float getExplosionResistance(lq exploder, yc world, int x, int y, int z, double src_x, double src_y, double src_z) {
        any te = world.q(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 2) {
                return 90.0f;
            }
        }
        return 6.0f;
    }

    public boolean canConnectRedstone(ym world, int X, int Y, int Z, int direction) {
        int meta = world.h(X, Y, Z);
        return meta == 11 || meta == 12;
    }

    @Override
    public ur getPickBlock(aoh target, yc world, int x, int y, int z) {
        return new ur(Ic2Items.insulatedCopperCableItem.c, 1, world.h(x, y, z));
    }
}

