/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.Direction;
import ic2.api.IElectricItem;
import ic2.api.IEnergyStorage;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.block.wiring.ContainerElectricBlock;
import ic2.core.item.ElectricItem;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TileEntityElectricBlock
extends TileEntityMachine
implements IEnergySink,
IEnergySource,
IHasGui,
ISidedInventory,
INetworkClientTileEntityEventListener,
IEnergyStorage {
    public bn translate;
    public int tier;
    public int output;
    public int maxStorage;
    public int energy = 0;
    public byte redstoneMode = 0;
    public static byte redstoneModes = (byte)6;
    private boolean isEmittingRedstone = false;
    private int redstoneUpdateInhibit = 5;
    public boolean addedToEnergyNet = false;

    public TileEntityElectricBlock(int tierc, int outputc, int maxStoragec) {
        super(2);
        this.tier = tierc;
        this.output = outputc;
        this.maxStorage = maxStoragec;
        this.translate = bn.a();
    }

    public String getNameByTier() {
        switch (this.tier) {
            case 1: {
                return this.translate.b("blockBatBox.name");
            }
            case 2: {
                return this.translate.b("blockMFE.name");
            }
            case 3: {
                return this.translate.b("blockMFSU.name");
            }
        }
        return null;
    }

    public float getChargeLevel() {
        float ret = (float)this.energy / (float)this.maxStorage;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.setActiveWithoutNotify(nbttagcompound.n("active"));
        this.energy = nbttagcompound.e("energy");
        if (this.maxStorage > Integer.MAX_VALUE) {
            this.energy *= 10;
        }
        this.redstoneMode = nbttagcompound.c("redstoneMode");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        int write = this.energy;
        if (this.maxStorage > Integer.MAX_VALUE) {
            write /= 10;
        }
        nbttagcompound.a("energy", write);
        nbttagcompound.a("active", this.getActive());
        nbttagcompound.a("redstoneMode", this.redstoneMode);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void g() {
        boolean shouldEmitRedstone;
        super.g();
        boolean needsInvUpdate = false;
        if (this.energy > 0 && this.inventory[0] != null && up.e[this.inventory[0].c] instanceof IElectricItem) {
            int sent = ElectricItem.charge(this.inventory[0], this.energy, this.tier, false, false);
            this.energy -= sent;
            boolean bl = needsInvUpdate = sent > 0;
        }
        if (this.demandsEnergy() > 0 && this.inventory[1] != null) {
            if (up.e[this.inventory[1].c] instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)up.e[this.inventory[1].c];
                if (item.canProvideEnergy()) {
                    int gain = ElectricItem.discharge(this.inventory[1], this.maxStorage - this.energy, this.tier, false, false);
                    this.energy += gain;
                    needsInvUpdate = gain > 0;
                }
            } else {
                int id = this.inventory[1].c;
                int gain = 0;
                if (id == up.aC.cj) {
                    gain = 500;
                }
                if (id == Ic2Items.suBattery.c) {
                    gain = 1000;
                }
                if (gain > 0 && gain <= this.maxStorage - this.energy) {
                    --this.inventory[1].a;
                    if (this.inventory[1].a <= 0) {
                        this.inventory[1] = null;
                    }
                    this.energy += gain;
                }
            }
        }
        if (!(this.energy < this.output || this.redstoneMode == 4 && this.k.A(this.l, this.m, this.n) || this.redstoneMode == 5 && this.k.A(this.l, this.m, this.n) && this.energy < this.maxStorage)) {
            EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, this.output);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.energy -= this.output - event.amount;
        }
        if ((shouldEmitRedstone = this.shouldEmitRedstone()) != this.isEmittingRedstone) {
            this.isEmittingRedstone = shouldEmitRedstone;
            this.setActive(this.isEmittingRedstone);
            this.k.h(this.l, this.m, this.n, this.k.a(this.l, this.m, this.n));
        }
        if (needsInvUpdate) {
            this.d();
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return !this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(any receiver, Direction direction) {
        return this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public int getMaxEnergyOutput() {
        return this.output;
    }

    @Override
    public int demandsEnergy() {
        return this.maxStorage - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.output) {
            IC2.explodeMachineAt(this.k, this.l, this.m, this.n);
            return 0;
        }
        int need = amount;
        if (this.energy + amount >= this.maxStorage + this.output) {
            need = this.maxStorage + this.output - this.energy - 1;
        }
        this.energy += need;
        return amount - need;
    }

    @Override
    public int getMaxSafeInput() {
        return this.output;
    }

    @Override
    public ContainerIC2 getGuiContainer(qx entityPlayer) {
        return new ContainerElectricBlock(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(qx entityPlayer) {
        return "block.wiring.GuiElectricBlock";
    }

    @Override
    public void onGuiClosed(qx entityPlayer) {
    }

    @Override
    public boolean wrenchCanSetFacing(qx entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short facing) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        super.setFacing(facing);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
    }

    public boolean isEmittingRedstone() {
        return this.isEmittingRedstone;
    }

    public boolean shouldEmitRedstone() {
        boolean shouldEmitRedstone = false;
        switch (this.redstoneMode) {
            case 1: {
                shouldEmitRedstone = this.energy >= this.maxStorage;
                break;
            }
            case 2: {
                shouldEmitRedstone = this.energy > this.output && this.energy < this.maxStorage;
                break;
            }
            case 3: {
                boolean bl = shouldEmitRedstone = this.energy < this.output;
            }
        }
        if (this.isEmittingRedstone == shouldEmitRedstone || this.redstoneUpdateInhibit == 0) {
            this.redstoneUpdateInhibit = 5;
            return shouldEmitRedstone;
        }
        --this.redstoneUpdateInhibit;
        return this.isEmittingRedstone;
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public void onNetworkEvent(qx player, int event) {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode >= redstoneModes) {
            this.redstoneMode = 0;
        }
        switch (this.redstoneMode) {
            case 0: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Nothing");
                break;
            }
            case 1: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if full");
                break;
            }
            case 2: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if partially filled");
                break;
            }
            case 3: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if empty");
                break;
            }
            case 4: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Do not output energy");
                break;
            }
            case 5: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Do not output energy unless full");
            }
        }
    }

    @Override
    public int getStored() {
        return this.energy;
    }

    @Override
    public int getCapacity() {
        return this.maxStorage;
    }

    @Override
    public int getOutput() {
        return this.output;
    }

    @Override
    public void setStored(int energy) {
        this.energy = energy;
    }

    @Override
    public int addEnergy(int amount) {
        this.energy += amount;
        return amount;
    }

    @Override
    public boolean isTeleporterCompatible(Direction side) {
        return true;
    }
}

