/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.TileEntityCable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityLuminator
extends any
implements IEnergySink {
    public int energy = 0;
    public int ticker = -1;
    public boolean ignoreBlockStay = false;
    public int maxInput = 32;
    public boolean addedToEnergyNet = false;
    private boolean loaded = false;

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.energy = nbttagcompound.d("energy");
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energy", (short)this.energy);
    }

    public void s() {
        super.s();
        if (!this.loaded) {
            if (!this.r() && this.k != null) {
                if (IC2.platform.isSimulating()) {
                    IC2.addSingleTickCallback(this.k, new ITickCallback(){

                        @Override
                        public void tickCallback(yc world) {
                            TileEntityLuminator.this.onLoaded();
                        }
                    });
                } else {
                    this.onLoaded();
                }
            } else {
                IC2.log.warning(this + " (" + this.l + "," + this.m + "," + this.n + ") was not added, isInvalid=" + this.r() + ", worldObj=" + this.k);
            }
        }
    }

    public void w_() {
        super.w_();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public void g() {
        if (IC2.platform.isSimulating()) {
            ++this.ticker;
            if (this.ticker % 4 == 0) {
                --this.energy;
                if (this.energy <= 0) {
                    this.k.d(this.l, this.m, this.n, Ic2Items.luminator.c, this.k.h(this.l, this.m, this.n));
                }
            }
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return emitter instanceof TileEntityCable;
    }

    @Override
    public int demandsEnergy() {
        return this.getMaxEnergy() - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.maxInput) {
            this.poof();
            return 0;
        }
        if (amount <= 0) {
            return 0;
        }
        if (this.k.a(this.l, this.m, this.n) == Ic2Items.luminator.c) {
            this.k.d(this.l, this.m, this.n, Ic2Items.activeLuminator.c, this.k.h(this.l, this.m, this.n));
            TileEntityLuminator newLumi = (TileEntityLuminator)this.k.q(this.l, this.m, this.n);
            return newLumi.injectEnergy(directionFrom, amount);
        }
        int need = amount;
        if (this.energy + amount >= this.getMaxEnergy() + this.maxInput) {
            need = this.getMaxEnergy() + this.maxInput - this.energy - 1;
        }
        this.energy += need;
        return amount - need;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }

    public int getMaxEnergy() {
        return 10000;
    }

    public void poof() {
        this.k.e(this.l, this.m, this.n, 0);
        ExplosionIC2 explosion = new ExplosionIC2(this.k, null, 0.5 + (double)this.l, 0.5 + (double)this.m, 0.5 + (double)this.n, 0.5f, 0.85f, 2.0f);
        explosion.doExplosion();
    }

    public boolean canCableConnectFrom(int x, int y, int z) {
        int facing = this.k.h(this.l, this.m, this.n);
        switch (facing) {
            case 0: {
                return x == this.l && y == this.m + 1 && z == this.n;
            }
            case 1: {
                return x == this.l && y == this.m - 1 && z == this.n;
            }
            case 2: {
                return x == this.l && y == this.m && z == this.n + 1;
            }
            case 3: {
                return x == this.l && y == this.m && z == this.n - 1;
            }
            case 4: {
                return x == this.l + 1 && y == this.m && z == this.n;
            }
            case 5: {
                return x == this.l - 1 && y == this.m && z == this.n;
            }
        }
        return false;
    }
}

