/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.EnergyNet;
import ic2.core.IC2;
import ic2.core.item.ItemIC2;
import ic2.core.util.StackUtil;
import java.text.DecimalFormat;

public class ItemToolMeter
extends ItemIC2 {
    public ItemToolMeter(int i, int index) {
        super(i, index);
        this.ck = 1;
        this.e(0);
    }

    public boolean onItemUseFirst(ur itemstack, qx entityplayer, yc world, int i, int j, int k, int l, float hitX, float hitY, float hitZ) {
        any tileEntity = world.q(i, j, k);
        if ((tileEntity instanceof IEnergySource || tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) && IC2.platform.isSimulating()) {
            bq nbtData = StackUtil.getOrCreateNbtData(itemstack);
            long currentTotalEnergyEmitted = EnergyNet.getForWorld(world).getTotalEnergyEmitted(tileEntity);
            long currentTotalEnergySunken = EnergyNet.getForWorld(world).getTotalEnergySunken(tileEntity);
            long currentMeasureTime = world.G();
            if (nbtData.e("lastMeasuredTileEntityX") != i || nbtData.e("lastMeasuredTileEntityY") != j || nbtData.e("lastMeasuredTileEntityZ") != k) {
                nbtData.a("lastMeasuredTileEntityX", i);
                nbtData.a("lastMeasuredTileEntityY", j);
                nbtData.a("lastMeasuredTileEntityZ", k);
                IC2.platform.messagePlayer(entityplayer, "Starting new measurement");
            } else {
                long measurePeriod = currentMeasureTime - nbtData.f("lastMeasureTime");
                if (measurePeriod < 1L) {
                    measurePeriod = 1L;
                }
                double deltaEmitted = (double)(currentTotalEnergyEmitted - nbtData.f("lastTotalEnergyEmitted")) / (double)measurePeriod;
                double deltaSunken = (double)(currentTotalEnergySunken - nbtData.f("lastTotalEnergySunken")) / (double)measurePeriod;
                DecimalFormat powerFormat = new DecimalFormat("0.##");
                IC2.platform.messagePlayer(entityplayer, "Measured power [EU/t]: " + powerFormat.format(deltaSunken) + " in " + powerFormat.format(deltaEmitted) + " out " + powerFormat.format(deltaSunken - deltaEmitted) + " gain" + " (avg. over " + measurePeriod + " ticks)");
            }
            nbtData.a("lastTotalEnergyEmitted", currentTotalEnergyEmitted);
            nbtData.a("lastTotalEnergySunken", currentTotalEnergySunken);
            nbtData.a("lastMeasureTime", currentMeasureTime);
            return true;
        }
        return false;
    }
}

