/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkItemEventListener;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.item.IHandHeldInventory;
import ic2.core.item.armor.ItemArmorQuantumSuit;
import ic2.core.network.DataEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;

public class NetworkManager
implements IPacketHandler {
    private final int updatePeriod = 2;
    protected static Map fieldsToUpdateSet = new HashMap();
    private Map ticksLeftToUpdate = new HashMap();

    public void onTick(yc world) {
        int worldTicksLeftToUpdate = !this.ticksLeftToUpdate.containsKey(world) ? 2 : (Integer)this.ticksLeftToUpdate.get(world);
        if (--worldTicksLeftToUpdate == 0) {
            this.sendUpdatePacket(world);
            worldTicksLeftToUpdate = 2;
        }
        this.ticksLeftToUpdate.put(world, worldTicksLeftToUpdate);
    }

    public void updateTileEntityField(any te, String field) {
        if (!fieldsToUpdateSet.containsKey(te.k)) {
            fieldsToUpdateSet.put(te.k, new HashSet());
        }
        Set worldFieldsToUpdateSet = (Set)fieldsToUpdateSet.get(te.k);
        worldFieldsToUpdateSet.add(new TileEntityField(te, field));
        if (worldFieldsToUpdateSet.size() > 10000) {
            this.sendUpdatePacket(te.k);
        }
    }

    public void initiateTileEntityEvent(any te, int event, boolean limitRange) {
        int maxDistance = limitRange ? 400 : MinecraftServer.D().ad().a() + 16;
        yc world = te.k;
        di packet = null;
        for (Object obj : world.h) {
            iq entityPlayer = (iq)obj;
            int distanceX = te.l - (int)entityPlayer.t;
            int distanceZ = te.n - (int)entityPlayer.v;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(1);
                    os.writeInt(world.u.h);
                    os.writeInt(te.l);
                    os.writeInt(te.m);
                    os.writeInt(te.n);
                    os.writeInt(event);
                    os.close();
                    packet = new di();
                    packet.a = "ic2";
                    packet.r = false;
                    packet.c = buffer.toByteArray();
                    packet.b = buffer.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            PacketDispatcher.sendPacketToPlayer(packet, (Player)((Player)entityPlayer));
        }
    }

    public void initiateItemEvent(qx player, ur itemStack, int event, boolean limitRange) {
        if (player.bR.length() > 127) {
            return;
        }
        int maxDistance = limitRange ? 400 : MinecraftServer.D().ad().a() + 16;
        di packet = null;
        for (Object obj : player.p.h) {
            iq entityPlayer = (iq)obj;
            int distanceX = (int)player.t - (int)entityPlayer.t;
            int distanceZ = (int)player.v - (int)entityPlayer.v;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(2);
                    os.writeByte(player.bR.length());
                    os.writeChars(player.bR);
                    os.writeInt(itemStack.c);
                    os.writeInt(itemStack.j());
                    os.writeInt(event);
                    os.close();
                    packet = new di();
                    packet.a = "ic2";
                    packet.r = false;
                    packet.c = buffer.toByteArray();
                    packet.b = buffer.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            PacketDispatcher.sendPacketToPlayer(packet, (Player)((Player)entityPlayer));
        }
    }

    public void announceBlockUpdate(yc world, int x, int y, int z) {
        di packet = null;
        for (Object obj : world.h) {
            iq entityPlayer = (iq)obj;
            int distance = Math.min(Math.abs(x - (int)entityPlayer.t), Math.abs(z - (int)entityPlayer.v));
            if (distance > MinecraftServer.D().ad().a() + 16) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(3);
                    os.writeInt(world.u.h);
                    os.writeInt(x);
                    os.writeInt(y);
                    os.writeInt(z);
                    os.writeShort(world.a(x, y, z));
                    os.writeByte(world.h(x, y, z));
                    os.close();
                    packet = new di();
                    packet.a = "ic2";
                    packet.r = true;
                    packet.c = buffer.toByteArray();
                    packet.b = buffer.size();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            PacketDispatcher.sendPacketToPlayer(packet, (Player)((Player)entityPlayer));
        }
    }

    public void requestInitialData(INetworkDataProvider dataProvider) {
    }

    public void initiateClientItemEvent(ur itemStack, int event) {
    }

    public void initiateClientTileEntityEvent(any te, int event) {
    }

    public void initiateGuiDisplay(iq entityPlayer, IHasGui inventory, int windowId) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(4);
            if (inventory instanceof any) {
                any te = (any)inventory;
                os.writeByte(0);
                os.writeInt(te.k.u.h);
                os.writeInt(te.l);
                os.writeInt(te.m);
                os.writeInt(te.n);
            } else if (entityPlayer.bJ.g() != null && entityPlayer.bJ.g().b() instanceof IHandHeldInventory) {
                os.writeByte(1);
                os.writeInt(entityPlayer.bJ.c);
            } else {
                IC2.platform.displayError("An unknown GUI type was attempted to be displayed.\nThis could happen due to corrupted data from a player or a bug.\n\n(Technical information: " + inventory + ")");
            }
            os.writeInt(windowId);
            os.close();
            di packet = new di();
            packet.a = "ic2";
            packet.r = false;
            packet.c = buffer.toByteArray();
            packet.b = buffer.size();
            PacketDispatcher.sendPacketToPlayer((ef)packet, (Player)((Player)entityPlayer));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendUpdatePacket(yc world) {
        if (!fieldsToUpdateSet.containsKey(world)) {
            return;
        }
        Set worldFieldsToUpdateSet = (Set)fieldsToUpdateSet.get(world);
        if (worldFieldsToUpdateSet.isEmpty()) {
            return;
        }
        for (Object obj : world.h) {
            iq entityPlayer = (iq)obj;
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                buffer.write(0);
                GZIPOutputStream gzip = new GZIPOutputStream(buffer);
                DataOutputStream os = new DataOutputStream(gzip);
                os.writeInt(world.u.h);
                for (TileEntityField tef : worldFieldsToUpdateSet) {
                    int distance;
                    if (tef.te.r() || tef.te.k != world || tef.target != null && tef.target != entityPlayer || (distance = Math.min(Math.abs(tef.te.l - (int)entityPlayer.t), Math.abs(tef.te.n - (int)entityPlayer.v))) > MinecraftServer.D().ad().a() + 16) continue;
                    os.writeInt(tef.te.l);
                    os.writeInt(tef.te.m);
                    os.writeInt(tef.te.n);
                    os.writeShort(tef.field.length());
                    os.writeChars(tef.field);
                    Field field = null;
                    try {
                        Class<?> fieldDeclaringClass = tef.te.getClass();
                        do {
                            try {
                                field = fieldDeclaringClass.getDeclaredField(tef.field);
                            }
                            catch (NoSuchFieldException e) {
                                fieldDeclaringClass = fieldDeclaringClass.getSuperclass();
                            }
                        } while (field == null && fieldDeclaringClass != null);
                        if (field == null) {
                            throw new NoSuchFieldException(tef.field);
                        }
                        field.setAccessible(true);
                        DataEncoder.encode(os, field.get(tef.te));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                os.close();
                gzip.close();
                if (buffer.size() <= 1) continue;
                di packet = new di();
                packet.a = "ic2";
                packet.r = true;
                packet.c = buffer.toByteArray();
                packet.b = buffer.size();
                PacketDispatcher.sendPacketToPlayer((ef)packet, (Player)((Player)entityPlayer));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        worldFieldsToUpdateSet.clear();
    }

    public void onPacketData(ce network, di packet, Player iplayer) {
        block19: {
            iq player = (iq)iplayer;
            ByteArrayInputStream isRaw = new ByteArrayInputStream(packet.c, 1, packet.c.length - 1);
            try {
                block1 : switch (packet.c[0]) {
                    case 0: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int dimensionId = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        for (in world : DimensionManager.getWorlds()) {
                            if (dimensionId != world.u.h) continue;
                            any te = world.q(x, y, z);
                            if (te instanceof INetworkDataProvider) {
                                if (!fieldsToUpdateSet.containsKey(world)) {
                                    fieldsToUpdateSet.put(world, new HashSet());
                                }
                                Set worldFieldsToUpdateSet = (Set)fieldsToUpdateSet.get(world);
                                for (String field : ((INetworkDataProvider)te).getNetworkedFields()) {
                                    worldFieldsToUpdateSet.add(new TileEntityField(te, field, player));
                                    if (worldFieldsToUpdateSet.size() <= 10000) continue;
                                    this.sendUpdatePacket((yc)world);
                                }
                            }
                            break block19;
                        }
                        break;
                    }
                    case 1: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int itemId = is.readInt();
                        int itemDamage = is.readInt();
                        int event = is.readInt();
                        if (itemId >= up.e.length) break;
                        up item = up.e[itemId];
                        if (item instanceof INetworkItemEventListener) {
                            ((INetworkItemEventListener)item).onNetworkEvent(itemDamage, (qx)player, event);
                        }
                        break;
                    }
                    case 2: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int keyState = is.readInt();
                        IC2.keyboard.processKeyUpdate((qx)player, keyState);
                        break;
                    }
                    case 3: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int dimensionId = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        int event = is.readInt();
                        for (in world : DimensionManager.getWorlds()) {
                            if (dimensionId != world.u.h) continue;
                            any te = world.q(x, y, z);
                            if (te instanceof INetworkClientTileEntityEventListener) {
                                ((INetworkClientTileEntityEventListener)te).onNetworkEvent((qx)player, event);
                                break block1;
                            }
                            break block19;
                        }
                        break;
                    }
                    case 4: {
                        GZIPInputStream gzip = new GZIPInputStream((InputStream)isRaw, packet.c.length - 1);
                        DataInputStream is = new DataInputStream(gzip);
                        int clientNetworkProtocolVersion = is.readInt();
                        if (clientNetworkProtocolVersion != 1) {
                            player.a.c("IC2 network protocol version mismatch (expected 1 (1.112.184-lf), got " + clientNetworkProtocolVersion + ")");
                        }
                        boolean enableQuantumSpeedOnSprint = is.readByte() != 0;
                        ItemArmorQuantumSuit.enableQuantumSpeedOnSprintMap.put(player, enableQuantumSpeedOnSprint);
                        is.readInt();
                        Properties clientRuntimeIdProperties = new Properties();
                        clientRuntimeIdProperties.load(is);
                        is.close();
                        for (Map.Entry<Object, Object> mapEntry : IC2.runtimeIdProperties.entrySet()) {
                            String key = (String)mapEntry.getKey();
                            String value = (String)mapEntry.getValue();
                            if (!clientRuntimeIdProperties.containsKey(key)) {
                                player.a.c("IC2 id value missing (" + key + ")");
                                break block1;
                            }
                            int separatorPos = key.indexOf(46);
                            if (separatorPos == -1) continue;
                            String section = key.substring(0, separatorPos);
                            key.substring(separatorPos + 1);
                            if (!section.equals("block") && !section.equals("item") || value.equals(clientRuntimeIdProperties.get(key))) continue;
                            player.a.c("IC2 id mismatch (" + key + ": expected " + value + ", got " + clientRuntimeIdProperties.get(key) + ")");
                        }
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void initiateKeyUpdate(int keyState) {
    }

    public void sendLoginData() {
    }

    public void initiateExplosionEffect(yc world, double x, double y, double z) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(5);
            os.writeInt(world.u.h);
            os.writeDouble(x);
            os.writeDouble(y);
            os.writeDouble(z);
            os.close();
            di packet = new di();
            packet.a = "ic2";
            packet.r = false;
            packet.c = buffer.toByteArray();
            packet.b = buffer.size();
            for (Object player : world.h) {
                iq entityPlayer = (iq)player;
                if (!(entityPlayer.e(x, y, z) < 128.0)) continue;
                PacketDispatcher.sendPacketToPlayer((ef)packet, (Player)((Player)entityPlayer));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class TileEntityField {
        any te;
        String field;
        iq target = null;

        TileEntityField(any te, String field) {
            this.te = te;
            this.field = field;
        }

        TileEntityField(any te, String field, iq target) {
            this.te = te;
            this.field = field;
            this.target = target;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TileEntityField) {
                TileEntityField tef = (TileEntityField)obj;
                return tef.te == this.te && tef.field.equals(this.field);
            }
            return false;
        }

        public int hashCode() {
            return this.te.hashCode() * 31 ^ this.field.hashCode();
        }
    }
}

