/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.core.IBox;
import buildcraft.builders.FillerPattern;
import buildcraft.core.DefaultProps;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtil;

public class FillerFlattener
extends FillerPattern {
    @Override
    public boolean iteratePattern(any tile, IBox box, ur stackToPlace) {
        int xMin = (int)box.pMin().x;
        int yMin = (int)box.pMin().y;
        int zMin = (int)box.pMin().z;
        int xMax = (int)box.pMax().x;
        int zMax = (int)box.pMax().z;
        int sizeX = xMax - xMin + 1;
        int sizeZ = zMax - zMin + 1;
        boolean[][] blockedColumns = new boolean[sizeX][sizeZ];
        for (int i = 0; i < blockedColumns.length; ++i) {
            for (int j = 0; j < blockedColumns[0].length; ++j) {
                blockedColumns[i][j] = false;
            }
        }
        boolean found = false;
        int lastX = Integer.MAX_VALUE;
        int lastY = Integer.MAX_VALUE;
        int lastZ = Integer.MAX_VALUE;
        for (int y2 = yMin - 1; y2 >= 0; --y2) {
            found = false;
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (!BlockUtil.canChangeBlock(tile.k, x, y2, z)) {
                        return true;
                    }
                    if (blockedColumns[x - xMin][z - zMin]) continue;
                    if (!BlockUtil.isSoftBlock(tile.k, x, y2, z)) {
                        blockedColumns[x - xMin][z - zMin] = true;
                        continue;
                    }
                    found = true;
                    lastX = x;
                    lastY = y2;
                    lastZ = z;
                }
            }
            if (!found) break;
        }
        if (lastX != Integer.MAX_VALUE && stackToPlace != null) {
            stackToPlace.b().a(stackToPlace, CoreProxy.proxy.getBuildCraftPlayer(tile.k), tile.k, lastX, lastY - 1, lastZ, 1, 0.0f, 0.0f, 0.0f);
        }
        if (lastX != Integer.MAX_VALUE) {
            return false;
        }
        return !this.empty(xMin, yMin, zMin, xMax, 256, zMax, tile.k);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex() {
        return 69;
    }

    @Override
    public String getName() {
        return "Flatten";
    }
}

