/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.LaserKind;
import buildcraft.api.core.Position;
import buildcraft.core.EntityBlock;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;

public class TileMarker
extends TileBuildCraft
implements IAreaProvider {
    private static int maxSize = 64;
    @TileNetworkData
    public Origin origin = new Origin();
    private EntityBlock[] lasers;
    private EntityBlock[] signals;
    @TileNetworkData
    public boolean showSignals = false;
    private Position initVectO;
    private Position[] initVect;

    public void updateSignals() {
        if (CoreProxy.proxy.isSimulating(this.k)) {
            this.showSignals = this.k.B(this.l, this.m, this.n);
            this.sendNetworkUpdate();
        }
    }

    private void switchSignals() {
        if (this.signals != null) {
            for (EntityBlock b : this.signals) {
                if (b == null) continue;
                CoreProxy.proxy.removeEntity(b);
            }
            this.signals = null;
        }
        if (this.showSignals) {
            this.signals = new EntityBlock[6];
            if (!this.origin.isSet() || !this.origin.vect[0].isSet()) {
                this.signals[0] = Utils.createLaser(this.k, new Position(this.l, this.m, this.n), new Position(this.l + maxSize - 1, this.m, this.n), LaserKind.Blue);
                this.signals[1] = Utils.createLaser(this.k, new Position(this.l - maxSize + 1, this.m, this.n), new Position(this.l, this.m, this.n), LaserKind.Blue);
            }
            if (!this.origin.isSet() || !this.origin.vect[1].isSet()) {
                this.signals[2] = Utils.createLaser(this.k, new Position(this.l, this.m, this.n), new Position(this.l, this.m + maxSize - 1, this.n), LaserKind.Blue);
                this.signals[3] = Utils.createLaser(this.k, new Position(this.l, this.m - maxSize + 1, this.n), new Position(this.l, this.m, this.n), LaserKind.Blue);
            }
            if (!this.origin.isSet() || !this.origin.vect[2].isSet()) {
                this.signals[4] = Utils.createLaser(this.k, new Position(this.l, this.m, this.n), new Position(this.l, this.m, this.n + maxSize - 1), LaserKind.Blue);
                this.signals[5] = Utils.createLaser(this.k, new Position(this.l, this.m, this.n - maxSize + 1), new Position(this.l, this.m, this.n), LaserKind.Blue);
            }
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateSignals();
        if (this.initVectO != null) {
            this.origin = new Origin();
            this.origin.vectO = new TileWrapper((int)this.initVectO.x, (int)this.initVectO.y, (int)this.initVectO.z);
            for (int i = 0; i < 3; ++i) {
                if (this.initVect[i] == null) continue;
                this.linkTo((TileMarker)this.k.q((int)this.initVect[i].x, (int)this.initVect[i].y, (int)this.initVect[i].z), i);
            }
        }
    }

    public void tryConnection() {
        if (CoreProxy.proxy.isRenderWorld(this.k)) {
            return;
        }
        for (int j = 0; j < 3; ++j) {
            if (this.origin.isSet() && this.origin.vect[j].isSet()) continue;
            this.setVect(j);
        }
        this.sendNetworkUpdate();
    }

    void setVect(int n) {
        int markerId = BuildCraftBuilders.markerBlock.cm;
        int[] coords = new int[]{this.l, this.m, this.n};
        if (!this.origin.isSet() || !this.origin.vect[n].isSet()) {
            for (int j = 1; j < maxSize; ++j) {
                TileMarker marker;
                int n2 = n;
                coords[n2] = coords[n2] + j;
                int blockId = this.k.a(coords[0], coords[1], coords[2]);
                if (blockId == markerId && this.linkTo(marker = (TileMarker)this.k.q(coords[0], coords[1], coords[2]), n)) break;
                int n3 = n;
                coords[n3] = coords[n3] - j;
                int n4 = n;
                coords[n4] = coords[n4] - j;
                blockId = this.k.a(coords[0], coords[1], coords[2]);
                if (blockId == markerId && this.linkTo(marker = (TileMarker)this.k.q(coords[0], coords[1], coords[2]), n)) break;
                int n5 = n;
                coords[n5] = coords[n5] + j;
            }
        }
    }

    private boolean linkTo(TileMarker marker, int n) {
        if (marker == null) {
            return false;
        }
        if (this.origin.isSet() && marker.origin.isSet()) {
            return false;
        }
        if (!this.origin.isSet() && !marker.origin.isSet()) {
            marker.origin = this.origin = new Origin();
            this.origin.vectO = new TileWrapper(this.l, this.m, this.n);
            this.origin.vect[n] = new TileWrapper(marker.l, marker.m, marker.n);
        } else if (!this.origin.isSet()) {
            this.origin = marker.origin;
            this.origin.vect[n] = new TileWrapper(this.l, this.m, this.n);
        } else {
            marker.origin = this.origin;
            this.origin.vect[n] = new TileWrapper(marker.l, marker.m, marker.n);
        }
        this.origin.vectO.getMarker(this.k).createLasers();
        this.updateSignals();
        marker.updateSignals();
        return true;
    }

    private void createLasers() {
        if (this.lasers != null) {
            for (EntityBlock entity : this.lasers) {
                if (entity == null) continue;
                CoreProxy.proxy.removeEntity(entity);
            }
        }
        this.lasers = new EntityBlock[12];
        Origin o = this.origin;
        if (!this.origin.vect[0].isSet()) {
            o.xMin = this.origin.vectO.x;
            o.xMax = this.origin.vectO.x;
        } else if (this.origin.vect[0].x < this.l) {
            o.xMin = this.origin.vect[0].x;
            o.xMax = this.l;
        } else {
            o.xMin = this.l;
            o.xMax = this.origin.vect[0].x;
        }
        if (!this.origin.vect[1].isSet()) {
            o.yMin = this.origin.vectO.y;
            o.yMax = this.origin.vectO.y;
        } else if (this.origin.vect[1].y < this.m) {
            o.yMin = this.origin.vect[1].y;
            o.yMax = this.m;
        } else {
            o.yMin = this.m;
            o.yMax = this.origin.vect[1].y;
        }
        if (!this.origin.vect[2].isSet()) {
            o.zMin = this.origin.vectO.z;
            o.zMax = this.origin.vectO.z;
        } else if (this.origin.vect[2].z < this.n) {
            o.zMin = this.origin.vect[2].z;
            o.zMax = this.n;
        } else {
            o.zMin = this.n;
            o.zMax = this.origin.vect[2].z;
        }
        this.lasers = Utils.createLaserBox(this.k, o.xMin, o.yMin, o.zMin, o.xMax, o.yMax, o.zMax, LaserKind.Red);
    }

    @Override
    public int xMin() {
        if (this.origin.isSet()) {
            return this.origin.xMin;
        }
        return this.l;
    }

    @Override
    public int yMin() {
        if (this.origin.isSet()) {
            return this.origin.yMin;
        }
        return this.m;
    }

    @Override
    public int zMin() {
        if (this.origin.isSet()) {
            return this.origin.zMin;
        }
        return this.n;
    }

    @Override
    public int xMax() {
        if (this.origin.isSet()) {
            return this.origin.xMax;
        }
        return this.l;
    }

    @Override
    public int yMax() {
        if (this.origin.isSet()) {
            return this.origin.yMax;
        }
        return this.m;
    }

    @Override
    public int zMax() {
        if (this.origin.isSet()) {
            return this.origin.zMax;
        }
        return this.n;
    }

    @Override
    public void w_() {
        super.w_();
        this.destroy();
    }

    @Override
    public void destroy() {
        TileMarker markerOrigin = null;
        if (this.origin.isSet()) {
            TileMarker mark;
            markerOrigin = this.origin.vectO.getMarker(this.k);
            Origin o = this.origin;
            if (markerOrigin != null && markerOrigin.lasers != null) {
                for (EntityBlock entityBlock : markerOrigin.lasers) {
                    if (entityBlock == null) continue;
                    entityBlock.x();
                }
                markerOrigin.lasers = null;
            }
            for (TileWrapper tileWrapper : o.vect) {
                mark = tileWrapper.getMarker(this.k);
                if (mark == null) continue;
                if (mark.lasers != null) {
                    for (EntityBlock entity : mark.lasers) {
                        if (entity == null) continue;
                        entity.x();
                    }
                    mark.lasers = null;
                }
                if (mark == this) continue;
                mark.origin = new Origin();
            }
            if (markerOrigin != this) {
                markerOrigin.origin = new Origin();
            }
            for (TileWrapper tileWrapper : o.vect) {
                mark = tileWrapper.getMarker(this.k);
                if (mark == null) continue;
                mark.updateSignals();
            }
            markerOrigin.updateSignals();
        }
        if (this.signals != null) {
            for (EntityBlock block : this.signals) {
                if (block == null) continue;
                block.x();
            }
        }
        this.signals = null;
        if (CoreProxy.proxy.isSimulating(this.k) && markerOrigin != null && markerOrigin != this) {
            markerOrigin.sendNetworkUpdate();
        }
    }

    @Override
    public void removeFromWorld() {
        if (!this.origin.isSet()) {
            return;
        }
        Origin o = this.origin;
        for (TileWrapper m : (TileWrapper[])o.vect.clone()) {
            if (!m.isSet()) continue;
            this.k.e(m.x, m.y, m.z, 0);
            BuildCraftBuilders.markerBlock.c(this.k, m.x, m.y, m.z, BuildCraftBuilders.markerBlock.cm, 0);
        }
        this.k.e(o.vectO.x, o.vectO.y, o.vectO.z, 0);
        BuildCraftBuilders.markerBlock.c(this.k, o.vectO.x, o.vectO.y, o.vectO.z, BuildCraftBuilders.markerBlock.cm, 0);
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.b("vectO")) {
            this.initVectO = new Position(nbttagcompound.l("vectO"));
            this.initVect = new Position[3];
            for (int i = 0; i < 3; ++i) {
                if (!nbttagcompound.b("vect" + i)) continue;
                this.initVect[i] = new Position(nbttagcompound.l("vect" + i));
            }
        }
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        if (this.origin.isSet() && this.origin.vectO.getMarker(this.k) == this) {
            bq vectO = new bq();
            new Position(this.origin.vectO.getMarker(this.k)).writeToNBT(vectO);
            nbttagcompound.a("vectO", (cd)vectO);
            for (int i = 0; i < 3; ++i) {
                if (!this.origin.vect[i].isSet()) continue;
                bq vect = new bq();
                new Position(this.origin.vect[i].x, this.origin.vect[i].y, this.origin.vect[i].z).writeToNBT(vect);
                nbttagcompound.a("vect" + i, (cd)vect);
            }
        }
    }

    @Override
    public void postPacketHandling(PacketUpdate packet) {
        super.postPacketHandling(packet);
        this.switchSignals();
        if (this.origin.vectO.isSet()) {
            this.origin.vectO.getMarker(this.k).updateSignals();
            for (TileWrapper w2 : this.origin.vect) {
                TileMarker m = w2.getMarker(this.k);
                if (m == null) continue;
                m.updateSignals();
            }
        }
        this.createLasers();
    }

    public static class Origin {
        @TileNetworkData
        public TileWrapper vectO = new TileWrapper();
        @TileNetworkData(staticSize=3)
        public TileWrapper[] vect = new TileWrapper[]{new TileWrapper(), new TileWrapper(), new TileWrapper()};
        @TileNetworkData
        public int xMin;
        @TileNetworkData
        public int yMin;
        @TileNetworkData
        public int zMin;
        @TileNetworkData
        public int xMax;
        @TileNetworkData
        public int yMax;
        @TileNetworkData
        public int zMax;

        public boolean isSet() {
            return this.vectO.isSet();
        }
    }

    public static class TileWrapper {
        @TileNetworkData
        public int x;
        @TileNetworkData
        public int y;
        @TileNetworkData
        public int z;
        private TileMarker marker;

        public TileWrapper() {
            this.x = Integer.MAX_VALUE;
            this.y = Integer.MAX_VALUE;
            this.z = Integer.MAX_VALUE;
        }

        public TileWrapper(int x, int y2, int z) {
            this.x = x;
            this.y = y2;
            this.z = z;
        }

        public boolean isSet() {
            return this.x != Integer.MAX_VALUE;
        }

        public TileMarker getMarker(yc world) {
            if (!this.isSet()) {
                return null;
            }
            if (this.marker == null) {
                this.marker = (TileMarker)world.q(this.x, this.y, this.z);
            }
            return this.marker;
        }

        public void reset() {
            this.x = Integer.MAX_VALUE;
            this.y = Integer.MAX_VALUE;
            this.z = Integer.MAX_VALUE;
        }
    }
}

