/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.core.IBuilderInventory;
import buildcraft.core.blueprints.BptBase;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptSlot;
import java.util.LinkedList;

public class BptBuilderTemplate
extends BptBuilderBase {
    LinkedList clearList = new LinkedList();
    LinkedList buildList = new LinkedList();

    public BptBuilderTemplate(BptBase bluePrint, yc world, int x, int y2, int z) {
        super(bluePrint, world, x, y2, z);
        BptSlot slot;
        int zCoord;
        int yCoord;
        int xCoord;
        int k;
        int i;
        int j;
        for (j = bluePrint.sizeY - 1; j >= 0; --j) {
            for (i = 0; i < bluePrint.sizeX; ++i) {
                for (k = 0; k < bluePrint.sizeZ; ++k) {
                    xCoord = i + x - bluePrint.anchorX;
                    yCoord = j + y2 - bluePrint.anchorY;
                    zCoord = k + z - bluePrint.anchorZ;
                    slot = bluePrint.contents[i][j][k];
                    if (slot != null && slot.blockId != 0) continue;
                    slot = new BptSlot();
                    slot.meta = 0;
                    slot.blockId = 0;
                    slot.x = xCoord;
                    slot.y = yCoord;
                    slot.z = zCoord;
                    slot.mode = BptSlot.Mode.ClearIfInvalid;
                    this.clearList.add(slot);
                }
            }
        }
        for (j = 0; j < bluePrint.sizeY; ++j) {
            for (i = 0; i < bluePrint.sizeX; ++i) {
                for (k = 0; k < bluePrint.sizeZ; ++k) {
                    xCoord = i + x - bluePrint.anchorX;
                    yCoord = j + y2 - bluePrint.anchorY;
                    zCoord = k + z - bluePrint.anchorZ;
                    slot = bluePrint.contents[i][j][k];
                    if (slot != null) {
                        slot = slot.clone();
                    } else {
                        slot = new BptSlot();
                        slot.meta = 0;
                        slot.blockId = 0;
                    }
                    slot.x = xCoord;
                    slot.y = yCoord;
                    slot.z = zCoord;
                    slot.mode = BptSlot.Mode.Build;
                    if (slot.blockId == 0) continue;
                    this.buildList.add(slot);
                }
            }
        }
    }

    private void checkDone() {
        this.done = this.clearList.size() == 0 && this.buildList.size() == 0;
    }

    @Override
    public BptSlot getNextBlock(yc world, IBuilderInventory inv) {
        if (this.clearList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.clearList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        if (this.buildList.size() != 0) {
            BptSlot slot = this.internalGetNextBlock(world, inv, this.buildList);
            this.checkDone();
            if (slot != null) {
                return slot;
            }
            return null;
        }
        this.checkDone();
        return null;
    }

    public BptSlot internalGetNextBlock(yc world, IBuilderInventory inv, LinkedList list) {
        BptSlot result = null;
        block0: while (list.size() > 0) {
            BptSlot slot = (BptSlot)list.getFirst();
            if (BuildCraftAPI.softBlock(slot.blockId) == BuildCraftAPI.softBlock(world.a(slot.x, slot.y, slot.z))) {
                list.removeFirst();
                continue;
            }
            if (slot.mode == BptSlot.Mode.ClearIfInvalid) {
                result = slot;
                list.removeFirst();
                break;
            }
            int size = inv.k_();
            for (int i = 0; i < size; ++i) {
                ur stack;
                if (!inv.isBuildingMaterial(i) || (stack = inv.a(i, 1)) == null || stack.a <= 0) continue;
                result = slot.clone();
                result.stackToUse = stack;
                list.removeFirst();
                break block0;
            }
        }
        return result;
    }
}

