/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.utils.SessionVars;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public abstract class GuiBuildCraft
extends avf {
    protected LedgerManager ledgerManager = new LedgerManager(this);
    protected any tile;

    public GuiBuildCraft(BuildCraftContainer container, la inventory) {
        super((rq)container);
        if (inventory instanceof any) {
            this.tile = (any)inventory;
        }
        this.initLedgers(inventory);
    }

    protected void initLedgers(la inventory) {
    }

    protected void b(int par1, int par2) {
        this.ledgerManager.drawLedgers(par1, par2);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.b);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.l.a(string)) / 2;
    }

    protected void a(int par1, int par2, int mouseButton) {
        super.a(par1, par2, mouseButton);
        this.ledgerManager.handleMouseClicked(par1, par2, mouseButton);
    }

    protected abstract class Ledger {
        private boolean open;
        protected int overlayColor = 0xFFFFFF;
        public int currentShiftX = 0;
        public int currentShiftY = 0;
        protected int limitWidth = 128;
        protected int maxWidth = 124;
        protected int minWidth;
        protected int currentWidth = this.minWidth = 24;
        protected int maxHeight = 24;
        protected int minHeight;
        protected int currentHeight = this.minHeight = 24;

        protected Ledger() {
        }

        public void update() {
            if (this.open && this.currentWidth < this.maxWidth) {
                this.currentWidth += 4;
            } else if (!this.open && this.currentWidth > this.minWidth) {
                this.currentWidth -= 4;
            }
            if (this.open && this.currentHeight < this.maxHeight) {
                this.currentHeight += 4;
            } else if (!this.open && this.currentHeight > this.minHeight) {
                this.currentHeight -= 4;
            }
        }

        public int getHeight() {
            return this.currentHeight;
        }

        public abstract void draw(int var1, int var2);

        public abstract String getTooltip();

        public boolean handleMouseClicked(int x, int y2, int mouseButton) {
            return false;
        }

        public boolean intersectsWith(int mouseX, int mouseY, int shiftX, int shiftY) {
            return mouseX >= shiftX && mouseX <= shiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + this.getHeight();
        }

        public void setFullyOpen() {
            this.open = true;
            this.currentWidth = this.maxWidth;
            this.currentHeight = this.maxHeight;
        }

        public void toggleOpen() {
            if (this.open) {
                this.open = false;
                SessionVars.setOpenedLedger(null);
            } else {
                this.open = true;
                SessionVars.setOpenedLedger(this.getClass());
            }
        }

        public boolean isVisible() {
            return true;
        }

        public boolean isOpen() {
            return this.open;
        }

        protected boolean isFullyOpened() {
            return this.currentWidth >= this.maxWidth;
        }

        protected void drawBackground(int x, int y2) {
            int texture = ((GuiBuildCraft)GuiBuildCraft.this).f.o.b(DefaultProps.TEXTURE_PATH_GUI + "/ledger.png");
            float colorR = (float)(this.overlayColor >> 16 & 0xFF) / 255.0f;
            float colorG = (float)(this.overlayColor >> 8 & 0xFF) / 255.0f;
            float colorB = (float)(this.overlayColor & 0xFF) / 255.0f;
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            ((GuiBuildCraft)GuiBuildCraft.this).f.o.b(texture);
            GuiBuildCraft.this.b(x, y2, 0, 256 - this.currentHeight, 4, this.currentHeight);
            GuiBuildCraft.this.b(x + 4, y2, 256 - this.currentWidth + 4, 0, this.currentWidth - 4, 4);
            GuiBuildCraft.this.b(x, y2, 0, 0, 4, 4);
            GuiBuildCraft.this.b(x + 4, y2 + 4, 256 - this.currentWidth + 4, 256 - this.currentHeight + 4, this.currentWidth - 4, this.currentHeight - 4);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        protected void drawIcon(String texture, int iconIndex, int x, int y2) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int tex = ((GuiBuildCraft)GuiBuildCraft.this).f.o.b(texture);
            ((GuiBuildCraft)GuiBuildCraft.this).f.o.b(tex);
            int textureRow = iconIndex >> 4;
            int textureColumn = iconIndex - 16 * textureRow;
            GuiBuildCraft.this.b(x, y2, 16 * textureColumn, 16 * textureRow, 16, 16);
        }
    }

    protected class LedgerManager {
        private GuiBuildCraft gui;
        protected ArrayList ledgers = new ArrayList();

        public LedgerManager(GuiBuildCraft gui) {
            this.gui = gui;
        }

        public void add(Ledger ledger) {
            this.ledgers.add(ledger);
            if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
                ledger.setFullyOpen();
            }
        }

        public void insert(Ledger ledger) {
            this.ledgers.add(this.ledgers.size() - 1, ledger);
        }

        protected Ledger getAtPosition(int mX, int mY) {
            int xShift = (this.gui.g - this.gui.b) / 2 + this.gui.b;
            int yShift = (this.gui.h - this.gui.c) / 2 + 8;
            for (int i = 0; i < this.ledgers.size(); ++i) {
                Ledger ledger = (Ledger)this.ledgers.get(i);
                if (!ledger.isVisible()) continue;
                ledger.currentShiftX = xShift;
                ledger.currentShiftY = yShift;
                if (ledger.intersectsWith(mX, mY, xShift, yShift)) {
                    return ledger;
                }
                yShift += ledger.getHeight();
            }
            return null;
        }

        protected void drawLedgers(int mouseX, int mouseY) {
            int xPos = 8;
            for (Ledger ledger : this.ledgers) {
                ledger.update();
                if (!ledger.isVisible()) continue;
                ledger.draw(GuiBuildCraft.this.b, xPos);
                xPos += ledger.getHeight();
            }
            Ledger ledger = this.getAtPosition(mouseX, mouseY);
            if (ledger != null) {
                int startX = mouseX - (this.gui.g - this.gui.b) / 2 + 12;
                int startY = mouseY - (this.gui.h - this.gui.c) / 2 - 12;
                String tooltip = ledger.getTooltip();
                int textWidth = GuiBuildCraft.this.l.a(tooltip);
                GuiBuildCraft.this.a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
                GuiBuildCraft.this.l.a(tooltip, startX, startY, -1);
            }
        }

        public void handleMouseClicked(int x, int y2, int mouseButton) {
            Ledger ledger;
            if (mouseButton == 0 && (ledger = this.getAtPosition(x, y2)) != null && !ledger.handleMouseClicked(x, y2, mouseButton)) {
                for (Ledger other : this.ledgers) {
                    if (other == ledger || !other.isOpen()) continue;
                    other.toggleOpen();
                }
                ledger.toggleOpen();
            }
        }
    }
}

