/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.ByteBuffer;
import buildcraft.core.network.ClassMapping;
import buildcraft.core.network.PacketPayload;

public class TilePacketWrapper {
    ClassMapping[] rootMappings;

    public TilePacketWrapper(Class c) {
        this(new Class[]{c});
    }

    public TilePacketWrapper(Class[] c) {
        this.rootMappings = new ClassMapping[c.length];
        for (int i = 0; i < c.length; ++i) {
            this.rootMappings[i] = new ClassMapping(c[i]);
        }
    }

    public PacketPayload toPayload(any tile) {
        int sizeF = 0;
        int sizeS = 0;
        for (int i = 0; i < this.rootMappings.length; ++i) {
            int[] size = this.rootMappings[i].getSize();
            sizeF += size[1];
            sizeS += size[2];
        }
        PacketPayload payload = new PacketPayload(0, sizeF, sizeS);
        ByteBuffer buf = new ByteBuffer();
        buf.writeInt(tile.l);
        buf.writeInt(tile.m);
        buf.writeInt(tile.n);
        try {
            this.rootMappings[0].setData(tile, buf, payload.floatPayload, payload.stringPayload, new ClassMapping.Indexes(0, 0));
            payload.intPayload = buf.readIntArray();
            return payload;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PacketPayload toPayload(Object obj) {
        return this.toPayload(0, 0, 0, new Object[]{obj});
    }

    public PacketPayload toPayload(int x, int y2, int z, Object obj) {
        return this.toPayload(x, y2, z, new Object[]{obj});
    }

    public PacketPayload toPayload(int x, int y2, int z, Object[] obj) {
        int sizeF = 0;
        int sizeS = 0;
        for (int i = 0; i < this.rootMappings.length; ++i) {
            int[] size = this.rootMappings[i].getSize();
            sizeF += size[1];
            sizeS += size[2];
        }
        PacketPayload payload = new PacketPayload(0, sizeF, sizeS);
        ByteBuffer buf = new ByteBuffer();
        buf.writeInt(x);
        buf.writeInt(y2);
        buf.writeInt(z);
        try {
            ClassMapping.Indexes ind = new ClassMapping.Indexes(0, 0);
            for (int i = 0; i < this.rootMappings.length; ++i) {
                this.rootMappings[i].setData(obj[i], buf, payload.floatPayload, payload.stringPayload, ind);
            }
            payload.intPayload = buf.readIntArray();
            return payload;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void fromPayload(any tile, PacketPayload packet) {
        try {
            ByteBuffer buf = new ByteBuffer();
            buf.writeIntArray(packet.intPayload);
            buf.readInt();
            buf.readInt();
            buf.readInt();
            this.rootMappings[0].updateFromData(tile, buf, packet.floatPayload, packet.stringPayload, new ClassMapping.Indexes(0, 0));
            packet.intPayload = buf.readIntArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fromPayload(Object obj, PacketPayload packet) {
        this.fromPayload(new Object[]{obj}, packet);
    }

    public void fromPayload(Object[] obj, PacketPayload packet) {
        try {
            ByteBuffer buf = new ByteBuffer();
            buf.writeIntArray(packet.intPayload);
            buf.readInt();
            buf.readInt();
            buf.readInt();
            ClassMapping.Indexes ind = new ClassMapping.Indexes(0, 0);
            for (int i = 0; i < this.rootMappings.length; ++i) {
                this.rootMappings[i].updateFromData(obj[i], buf, packet.floatPayload, packet.stringPayload, ind);
            }
            packet.intPayload = buf.readIntArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

