/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.network;

import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketSlotChange;
import buildcraft.core.network.PacketUpdate;
import buildcraft.silicon.TileAssemblyAdvancedWorkbench;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.gui.ContainerAssemblyTable;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PacketHandlerSilicon
implements IPacketHandler {
    public void onPacketData(ce manager, di packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.c));
        try {
            int packetID = data.read();
            switch (packetID) {
                case 22: {
                    PacketUpdate packetT = new PacketUpdate();
                    packetT.readData(data);
                    this.onSelectionUpdate((qx)player, packetT);
                    break;
                }
                case 21: {
                    PacketUpdate packetA = new PacketUpdate();
                    packetA.readData(data);
                    this.onAssemblySelect((qx)player, packetA);
                    break;
                }
                case 20: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    this.onAssemblyGetSelection((qx)player, packetC);
                    break;
                }
                case 70: {
                    PacketSlotChange packet1 = new PacketSlotChange();
                    packet1.readData(data);
                    this.onAdvancedWorkbenchSet((qx)player, packet1);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onSelectionUpdate(qx player, PacketUpdate packet) {
        rq container = player.bL;
        if (container instanceof ContainerAssemblyTable) {
            TileAssemblyTable.SelectionMessage message = new TileAssemblyTable.SelectionMessage();
            TileAssemblyTable.selectionMessageWrapper.fromPayload(message, packet.payload);
            ((ContainerAssemblyTable)container).handleSelectionMessage(message);
        }
    }

    private TileAssemblyTable getAssemblyTable(yc world, int x, int y2, int z) {
        if (!world.f(x, y2, z)) {
            return null;
        }
        any tile = world.q(x, y2, z);
        if (!(tile instanceof TileAssemblyTable)) {
            return null;
        }
        return (TileAssemblyTable)tile;
    }

    private TileAssemblyAdvancedWorkbench getAdvancedWorkbench(yc world, int x, int y2, int z) {
        if (!world.f(x, y2, z)) {
            return null;
        }
        any tile = world.q(x, y2, z);
        if (!(tile instanceof TileAssemblyAdvancedWorkbench)) {
            return null;
        }
        return (TileAssemblyAdvancedWorkbench)tile;
    }

    private void onAssemblyGetSelection(qx player, PacketCoordinates packet) {
        TileAssemblyTable tile = this.getAssemblyTable(player.p, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        tile.sendSelectionTo(player);
    }

    private void onAssemblySelect(qx player, PacketUpdate packet) {
        TileAssemblyTable tile = this.getAssemblyTable(player.p, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        TileAssemblyTable.SelectionMessage message = new TileAssemblyTable.SelectionMessage();
        TileAssemblyTable.selectionMessageWrapper.fromPayload(message, packet.payload);
        tile.handleSelectionMessage(message);
    }

    private void onAdvancedWorkbenchSet(qx player, PacketSlotChange packet1) {
        TileAssemblyAdvancedWorkbench tile = this.getAdvancedWorkbench(player.p, packet1.posX, packet1.posY, packet1.posZ);
        if (tile == null) {
            return;
        }
        tile.updateCraftingMatrix(packet1.slot, packet1.stack);
    }
}

