/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.power.IPowerReceptor;
import net.minecraftforge.common.ForgeDirection;

public class EnergyPulser {
    private IPowerReceptor powerReceptor;
    private boolean isActive = false;
    private float progress = 0.0f;
    private int progressPart = 0;
    private float pulseSpeed = 0.0f;
    private int maxHeat = 1000;

    public EnergyPulser(IPowerReceptor receptor) {
        this.powerReceptor = receptor;
    }

    public void update() {
        if (this.powerReceptor == null) {
            return;
        }
        if (this.progressPart != 0) {
            this.progress += this.getPulseSpeed();
            if ((double)this.progress > 0.5 && this.progressPart == 1) {
                this.progressPart = 2;
                this.powerReceptor.getPowerProvider().receiveEnergy(1.0f, ForgeDirection.WEST);
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isActive) {
            this.progressPart = 1;
        }
    }

    public void enablePulse() {
        this.isActive = true;
    }

    public void disablePulse() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    private float getPulseSpeed() {
        return 0.1f;
    }

    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("IsActive", this.isActive);
        nbttagcompound.a("ProgressPart", (short)this.progressPart);
        nbttagcompound.a("Progress", this.progress);
    }

    public void readFromNBT(bq nbttagcompound) {
        this.isActive = nbttagcompound.n("IsActive");
        this.progressPart = nbttagcompound.d("ProgressPart");
        this.progress = nbttagcompound.g("Progress");
    }
}

