/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.network;

import buildcraft.core.network.PacketCoordinates;
import buildcraft.transport.PipeRenderState;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PipeRenderStatePacket
extends PacketCoordinates {
    private PipeRenderState renderState;
    public int pipeId;

    public PipeRenderStatePacket() {
    }

    public PipeRenderStatePacket(PipeRenderState renderState, int pipeId, int x, int y2, int z) {
        super(1, x, y2, z);
        this.pipeId = pipeId;
        this.isChunkDataPacket = true;
        this.renderState = renderState;
    }

    public PipeRenderState getRenderState() {
        return this.renderState;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.pipeId);
        this.renderState.writeData(data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.pipeId = data.readInt();
        this.renderState = new PipeRenderState();
        this.renderState.readData(data);
    }

    @Override
    public int getID() {
        return 1;
    }

    public void setPipeId(int pipeId) {
        this.pipeId = pipeId;
    }

    public int getPipeId() {
        return this.pipeId;
    }
}

