/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.DefaultProps;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogicGold;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsGold
extends Pipe
implements IPipeTransportItemsHook {
    public PipeItemsGold(int itemID) {
        super(new PipeTransportItems(), new PipeLogicGold(), itemID);
    }

    @Override
    public String getTextureFile() {
        return DefaultProps.TEXTURE_BLOCKS;
    }

    @Override
    public int getTextureIndex(ForgeDirection direction) {
        return 30;
    }

    @Override
    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        return possibleOrientations;
    }

    @Override
    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
        item.setSpeed(Math.min(Math.max(Utils.pipeNormalSpeed, item.getSpeed()) * 2.0f, Utils.pipeNormalSpeed * 30.0f));
    }

    @Override
    public void readjustSpeed(IPipedItem item) {
        item.setSpeed(Math.min(Math.max(Utils.pipeNormalSpeed, item.getSpeed()) * 2.0f, Utils.pipeNormalSpeed * 30.0f));
    }
}

